/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.stereotype.Service;

@Service
public class DataBufferListParser {
    private static final Logger log = LogManager.getLogger(DataBufferListParser.class);

    public String parse(List<DataBuffer> dataBufferList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != dataBufferList) {
            try {
                for (DataBuffer dataBuffer : dataBufferList) {
                    log.trace("data buffer -> (capacity) {} (readableByteCount) {}", (Object)dataBuffer.capacity(), (Object)dataBuffer.readableByteCount());
                    int size = dataBuffer.readableByteCount() < dataBuffer.capacity() ? dataBuffer.readableByteCount() : dataBuffer.capacity();
                    byte[] byteArray = new byte[size];
                    for (int index = 0; index < size; ++index) {
                        byte current;
                        byteArray[index] = current = dataBuffer.getByte(index);
                    }
                    log.trace("formed -> (byteArray) {}", (Object)byteArray);
                    String dataBufferString = new String(byteArray);
                    log.trace("extracted -> (dataBufferString) {}", (Object)dataBufferString);
                    stringBuilder.append(dataBufferString);
                }
            }
            catch (UnsupportedOperationException e) {
                log.error("error identifying String from dataBufferList", (Throwable)e);
            }
        }
        String completeDataBufferString = stringBuilder.toString();
        log.debug("got -> (completeDataBufferString) {}", (Object)completeDataBufferString);
        return completeDataBufferString;
    }
}

