/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;
import open.source.exchange.model.ExContentDisposition;
import open.source.exchange.model.ExZonedDateTime;
import open.source.exchange.parser.CharsetParser;
import open.source.exchange.parser.ObjectParser;
import open.source.exchange.parser.ZonedDateTimeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.stereotype.Service;

@Service
public class ContentDispositionParser {
    private static final Logger log = LogManager.getLogger(ContentDispositionParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private CharsetParser charsetParser;
    @Autowired
    private ZonedDateTimeParser zonedDateTimeParser;

    public ExContentDisposition parse(ContentDisposition contentDisposition) {
        log.trace("parse -> (contentDisposition) {}", (Object)contentDisposition);
        ExContentDisposition exContentDisposition = null;
        if (null != contentDisposition) {
            ExBase exBase = this.objectParser.parse(contentDisposition);
            exContentDisposition = new ExContentDisposition(exBase);
            Charset charset = contentDisposition.getCharset();
            ExCharset exCharset = this.charsetParser.parse(charset);
            exContentDisposition.setCharset(exCharset);
            ZonedDateTime creationDate = contentDisposition.getCreationDate();
            ExZonedDateTime exCreationDate = this.zonedDateTimeParser.parse(creationDate);
            exContentDisposition.setCreationDate(exCreationDate);
            String filename = contentDisposition.getFilename();
            exContentDisposition.setFilename(filename);
            ZonedDateTime modificationDate = contentDisposition.getModificationDate();
            ExZonedDateTime exModificationDate = this.zonedDateTimeParser.parse(modificationDate);
            exContentDisposition.setModificationDate(exModificationDate);
            String name = contentDisposition.getName();
            exContentDisposition.setName(name);
            ZonedDateTime readDate = contentDisposition.getReadDate();
            ExZonedDateTime exReadDate = this.zonedDateTimeParser.parse(readDate);
            exContentDisposition.setReadDate(exReadDate);
            Long size = contentDisposition.getSize();
            exContentDisposition.setSize(size);
            String type = contentDisposition.getType();
            exContentDisposition.setType(type);
        }
        return exContentDisposition;
    }
}

