/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.util.ArrayList;
import java.util.List;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExChronology;
import open.source.exchange.model.ExEra;
import open.source.exchange.parser.EraParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChronologyParser {
    private static final Logger log = LogManager.getLogger(ChronologyParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private EraParser eraParser;

    public ExChronology parse(Chronology chronology) {
        log.trace("parse -> (chronology) {}", (Object)chronology);
        ExChronology exChronology = null;
        if (null != chronology) {
            ExBase exBase = this.objectParser.parse(chronology);
            exChronology = new ExChronology(exBase);
            ChronoLocalDate dateNow = chronology.dateNow();
            exChronology.setDateNow(dateNow);
            List<Era> eras = chronology.eras();
            if (null != eras && !eras.isEmpty()) {
                ArrayList<ExEra> exList = new ArrayList<ExEra>();
                for (Era era : eras) {
                    ExEra exEra = this.eraParser.parse(era);
                    exList.add(exEra);
                }
                exChronology.setEras(exList);
            }
            String calendarType = chronology.getCalendarType();
            exChronology.setCalendarType(calendarType);
            String id = chronology.getId();
            exChronology.setId(id);
        }
        return exChronology;
    }
}

