/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import java.nio.charset.Charset;
import java.util.Set;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CharsetParser {
    private static final Logger log = LogManager.getLogger(CharsetParser.class);
    @Autowired
    private ObjectParser objectParser;

    public ExCharset parse(Charset charset) {
        log.trace("parse -> (charset) {}", (Object)charset);
        ExCharset exCharset = null;
        if (null != charset) {
            ExBase exBase = this.objectParser.parse(charset);
            exCharset = new ExCharset(exBase);
            Set<String> aliases = charset.aliases();
            exCharset.setAliases(aliases);
            boolean canEncode = charset.canEncode();
            exCharset.setCanEncode(canEncode);
            String displayName = charset.displayName();
            exCharset.setDisplayName(displayName);
            boolean isRegistered = charset.isRegistered();
            exCharset.setRegistered(isRegistered);
            String name = charset.name();
            exCharset.setName(name);
        }
        return exCharset;
    }
}

