/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.parser;

import open.source.exchange.entity.ExApplicationContext;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExEnvironment;
import open.source.exchange.parser.EnvironmentParser;
import open.source.exchange.parser.ObjectParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ApplicationContextParser {
    private static final Logger log = LogManager.getLogger(ApplicationContextParser.class);
    @Autowired
    private ObjectParser objectParser;
    @Autowired
    private EnvironmentParser environmentParser;

    private ExApplicationContext parseCore(ApplicationContext applicationContext) {
        log.trace("parse core -> (applicationContext) {}", (Object)applicationContext);
        ExApplicationContext exApplicationContext = null;
        if (null != applicationContext) {
            ExBase exBase = this.objectParser.parse(applicationContext);
            exApplicationContext = new ExApplicationContext(exBase);
            String applicationName = applicationContext.getApplicationName();
            exApplicationContext.setApplicationName(applicationName);
            int beanDefinitionCount = applicationContext.getBeanDefinitionCount();
            exApplicationContext.setBeanDefinitionCount(beanDefinitionCount);
            String[] beanDefinitionNames = applicationContext.getBeanDefinitionNames();
            exApplicationContext.setBeanDefinitionNames(beanDefinitionNames);
            String displayName = applicationContext.getDisplayName();
            exApplicationContext.setDisplayName(displayName);
            Environment environment = applicationContext.getEnvironment();
            ExEnvironment exEnvironment = this.environmentParser.parse(environment);
            exApplicationContext.setEnvironment(exEnvironment);
            String id = applicationContext.getId();
            exApplicationContext.setId(id);
            long startupDate = applicationContext.getStartupDate();
            exApplicationContext.setStartupDate(startupDate);
        }
        return exApplicationContext;
    }

    private ExApplicationContext parseNonCore(ApplicationContext applicationContext, ExApplicationContext exApplicationContext) {
        log.trace("parse non core -> (applicationContext) {} (exApplicationContext) {}", (Object)applicationContext, (Object)exApplicationContext);
        if (null != exApplicationContext) {
            ApplicationContext parent = applicationContext.getParent();
            ExApplicationContext exParent = this.parseCore(parent);
            exApplicationContext.setParent(exParent);
        }
        return exApplicationContext;
    }

    public ExApplicationContext parse(ApplicationContext applicationContext) {
        log.trace("parse -> (applicationContext) {}", (Object)applicationContext);
        ExApplicationContext exApplicationContext = this.parseCore(applicationContext);
        return this.parseNonCore(applicationContext, exApplicationContext);
    }
}

