/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExDate;
import open.source.exchange.model.ExPrincipal;
import open.source.exchange.model.ExPublicKey;
import open.source.exchange.model.ExX500Principal;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExX509Certificate
extends ExBase
implements Serializable {
    private int basicConstraints;
    private Set<String> criticalExtensionOIDs;
    private byte[] encoded;
    private List<String> extendedKeyUsage;
    private Collection<List<Object>> issuerAlternativeNames;
    private ExPrincipal issuerDN;
    private boolean[] issuerUniqueID;
    private ExX500Principal issuerX500Principal;
    private boolean[] keyUsage;
    private Set<String> nonCriticalExtensionOIDs;
    private ExDate notAfter;
    private ExDate notBefore;
    private ExPublicKey publicKey;
    private BigInteger serialNumber;
    private String signatureAlgorithmName;
    private String signatureAlgorithmOID;
    private byte[] signatureAlgorithmParams;
    private byte[] signature;
    private Collection<List<Object>> subjectAlternativeNames;
    private ExPrincipal subjectDN;
    private boolean[] subjectUniqueID;
    private ExX500Principal subjectX500Principal;
    private byte[] tbsCertificate;
    private String type;
    private int version;
    private boolean hasUnsupportedCriticalExtension;
    private Boolean notYetValidFlag;
    private Boolean expiredFlag;

    public ExX509Certificate(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExX509CertificateBuilder builder() {
        return new ExX509CertificateBuilder();
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.criticalExtensionOIDs;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public List<String> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public Collection<List<Object>> getIssuerAlternativeNames() {
        return this.issuerAlternativeNames;
    }

    public ExPrincipal getIssuerDN() {
        return this.issuerDN;
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public ExX500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.nonCriticalExtensionOIDs;
    }

    public ExDate getNotAfter() {
        return this.notAfter;
    }

    public ExDate getNotBefore() {
        return this.notBefore;
    }

    public ExPublicKey getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    public String getSignatureAlgorithmOID() {
        return this.signatureAlgorithmOID;
    }

    public byte[] getSignatureAlgorithmParams() {
        return this.signatureAlgorithmParams;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public Collection<List<Object>> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public ExPrincipal getSubjectDN() {
        return this.subjectDN;
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public ExX500Principal getSubjectX500Principal() {
        return this.subjectX500Principal;
    }

    public byte[] getTbsCertificate() {
        return this.tbsCertificate;
    }

    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isHasUnsupportedCriticalExtension() {
        return this.hasUnsupportedCriticalExtension;
    }

    public Boolean getNotYetValidFlag() {
        return this.notYetValidFlag;
    }

    public Boolean getExpiredFlag() {
        return this.expiredFlag;
    }

    public void setBasicConstraints(int basicConstraints) {
        this.basicConstraints = basicConstraints;
    }

    public void setCriticalExtensionOIDs(Set<String> criticalExtensionOIDs) {
        this.criticalExtensionOIDs = criticalExtensionOIDs;
    }

    public void setEncoded(byte[] encoded) {
        this.encoded = encoded;
    }

    public void setExtendedKeyUsage(List<String> extendedKeyUsage) {
        this.extendedKeyUsage = extendedKeyUsage;
    }

    public void setIssuerAlternativeNames(Collection<List<Object>> issuerAlternativeNames) {
        this.issuerAlternativeNames = issuerAlternativeNames;
    }

    public void setIssuerDN(ExPrincipal issuerDN) {
        this.issuerDN = issuerDN;
    }

    public void setIssuerUniqueID(boolean[] issuerUniqueID) {
        this.issuerUniqueID = issuerUniqueID;
    }

    public void setIssuerX500Principal(ExX500Principal issuerX500Principal) {
        this.issuerX500Principal = issuerX500Principal;
    }

    public void setKeyUsage(boolean[] keyUsage) {
        this.keyUsage = keyUsage;
    }

    public void setNonCriticalExtensionOIDs(Set<String> nonCriticalExtensionOIDs) {
        this.nonCriticalExtensionOIDs = nonCriticalExtensionOIDs;
    }

    public void setNotAfter(ExDate notAfter) {
        this.notAfter = notAfter;
    }

    public void setNotBefore(ExDate notBefore) {
        this.notBefore = notBefore;
    }

    public void setPublicKey(ExPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSignatureAlgorithmName(String signatureAlgorithmName) {
        this.signatureAlgorithmName = signatureAlgorithmName;
    }

    public void setSignatureAlgorithmOID(String signatureAlgorithmOID) {
        this.signatureAlgorithmOID = signatureAlgorithmOID;
    }

    public void setSignatureAlgorithmParams(byte[] signatureAlgorithmParams) {
        this.signatureAlgorithmParams = signatureAlgorithmParams;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setSubjectAlternativeNames(Collection<List<Object>> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    public void setSubjectDN(ExPrincipal subjectDN) {
        this.subjectDN = subjectDN;
    }

    public void setSubjectUniqueID(boolean[] subjectUniqueID) {
        this.subjectUniqueID = subjectUniqueID;
    }

    public void setSubjectX500Principal(ExX500Principal subjectX500Principal) {
        this.subjectX500Principal = subjectX500Principal;
    }

    public void setTbsCertificate(byte[] tbsCertificate) {
        this.tbsCertificate = tbsCertificate;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setHasUnsupportedCriticalExtension(boolean hasUnsupportedCriticalExtension) {
        this.hasUnsupportedCriticalExtension = hasUnsupportedCriticalExtension;
    }

    public void setNotYetValidFlag(Boolean notYetValidFlag) {
        this.notYetValidFlag = notYetValidFlag;
    }

    public void setExpiredFlag(Boolean expiredFlag) {
        this.expiredFlag = expiredFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExX509Certificate)) {
            return false;
        }
        ExX509Certificate other = (ExX509Certificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBasicConstraints() != other.getBasicConstraints()) {
            return false;
        }
        Set<String> this$criticalExtensionOIDs = this.getCriticalExtensionOIDs();
        Set<String> other$criticalExtensionOIDs = other.getCriticalExtensionOIDs();
        if (this$criticalExtensionOIDs == null ? other$criticalExtensionOIDs != null : !((Object)this$criticalExtensionOIDs).equals(other$criticalExtensionOIDs)) {
            return false;
        }
        if (!Arrays.equals(this.getEncoded(), other.getEncoded())) {
            return false;
        }
        List<String> this$extendedKeyUsage = this.getExtendedKeyUsage();
        List<String> other$extendedKeyUsage = other.getExtendedKeyUsage();
        if (this$extendedKeyUsage == null ? other$extendedKeyUsage != null : !((Object)this$extendedKeyUsage).equals(other$extendedKeyUsage)) {
            return false;
        }
        Collection<List<Object>> this$issuerAlternativeNames = this.getIssuerAlternativeNames();
        Collection<List<Object>> other$issuerAlternativeNames = other.getIssuerAlternativeNames();
        if (this$issuerAlternativeNames == null ? other$issuerAlternativeNames != null : !((Object)this$issuerAlternativeNames).equals(other$issuerAlternativeNames)) {
            return false;
        }
        ExPrincipal this$issuerDN = this.getIssuerDN();
        ExPrincipal other$issuerDN = other.getIssuerDN();
        if (this$issuerDN == null ? other$issuerDN != null : !((Object)this$issuerDN).equals(other$issuerDN)) {
            return false;
        }
        if (!Arrays.equals(this.getIssuerUniqueID(), other.getIssuerUniqueID())) {
            return false;
        }
        ExX500Principal this$issuerX500Principal = this.getIssuerX500Principal();
        ExX500Principal other$issuerX500Principal = other.getIssuerX500Principal();
        if (this$issuerX500Principal == null ? other$issuerX500Principal != null : !((Object)this$issuerX500Principal).equals(other$issuerX500Principal)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyUsage(), other.getKeyUsage())) {
            return false;
        }
        Set<String> this$nonCriticalExtensionOIDs = this.getNonCriticalExtensionOIDs();
        Set<String> other$nonCriticalExtensionOIDs = other.getNonCriticalExtensionOIDs();
        if (this$nonCriticalExtensionOIDs == null ? other$nonCriticalExtensionOIDs != null : !((Object)this$nonCriticalExtensionOIDs).equals(other$nonCriticalExtensionOIDs)) {
            return false;
        }
        ExDate this$notAfter = this.getNotAfter();
        ExDate other$notAfter = other.getNotAfter();
        if (this$notAfter == null ? other$notAfter != null : !((Object)this$notAfter).equals(other$notAfter)) {
            return false;
        }
        ExDate this$notBefore = this.getNotBefore();
        ExDate other$notBefore = other.getNotBefore();
        if (this$notBefore == null ? other$notBefore != null : !((Object)this$notBefore).equals(other$notBefore)) {
            return false;
        }
        ExPublicKey this$publicKey = this.getPublicKey();
        ExPublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
            return false;
        }
        BigInteger this$serialNumber = this.getSerialNumber();
        BigInteger other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !((Object)this$serialNumber).equals(other$serialNumber)) {
            return false;
        }
        String this$signatureAlgorithmName = this.getSignatureAlgorithmName();
        String other$signatureAlgorithmName = other.getSignatureAlgorithmName();
        if (this$signatureAlgorithmName == null ? other$signatureAlgorithmName != null : !this$signatureAlgorithmName.equals(other$signatureAlgorithmName)) {
            return false;
        }
        String this$signatureAlgorithmOID = this.getSignatureAlgorithmOID();
        String other$signatureAlgorithmOID = other.getSignatureAlgorithmOID();
        if (this$signatureAlgorithmOID == null ? other$signatureAlgorithmOID != null : !this$signatureAlgorithmOID.equals(other$signatureAlgorithmOID)) {
            return false;
        }
        if (!Arrays.equals(this.getSignatureAlgorithmParams(), other.getSignatureAlgorithmParams())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        Collection<List<Object>> this$subjectAlternativeNames = this.getSubjectAlternativeNames();
        Collection<List<Object>> other$subjectAlternativeNames = other.getSubjectAlternativeNames();
        if (this$subjectAlternativeNames == null ? other$subjectAlternativeNames != null : !((Object)this$subjectAlternativeNames).equals(other$subjectAlternativeNames)) {
            return false;
        }
        ExPrincipal this$subjectDN = this.getSubjectDN();
        ExPrincipal other$subjectDN = other.getSubjectDN();
        if (this$subjectDN == null ? other$subjectDN != null : !((Object)this$subjectDN).equals(other$subjectDN)) {
            return false;
        }
        if (!Arrays.equals(this.getSubjectUniqueID(), other.getSubjectUniqueID())) {
            return false;
        }
        ExX500Principal this$subjectX500Principal = this.getSubjectX500Principal();
        ExX500Principal other$subjectX500Principal = other.getSubjectX500Principal();
        if (this$subjectX500Principal == null ? other$subjectX500Principal != null : !((Object)this$subjectX500Principal).equals(other$subjectX500Principal)) {
            return false;
        }
        if (!Arrays.equals(this.getTbsCertificate(), other.getTbsCertificate())) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isHasUnsupportedCriticalExtension() != other.isHasUnsupportedCriticalExtension()) {
            return false;
        }
        Boolean this$notYetValidFlag = this.getNotYetValidFlag();
        Boolean other$notYetValidFlag = other.getNotYetValidFlag();
        if (this$notYetValidFlag == null ? other$notYetValidFlag != null : !((Object)this$notYetValidFlag).equals(other$notYetValidFlag)) {
            return false;
        }
        Boolean this$expiredFlag = this.getExpiredFlag();
        Boolean other$expiredFlag = other.getExpiredFlag();
        return !(this$expiredFlag == null ? other$expiredFlag != null : !((Object)this$expiredFlag).equals(other$expiredFlag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExX509Certificate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBasicConstraints();
        Set<String> $criticalExtensionOIDs = this.getCriticalExtensionOIDs();
        result = result * 59 + ($criticalExtensionOIDs == null ? 43 : ((Object)$criticalExtensionOIDs).hashCode());
        result = result * 59 + Arrays.hashCode(this.getEncoded());
        List<String> $extendedKeyUsage = this.getExtendedKeyUsage();
        result = result * 59 + ($extendedKeyUsage == null ? 43 : ((Object)$extendedKeyUsage).hashCode());
        Collection<List<Object>> $issuerAlternativeNames = this.getIssuerAlternativeNames();
        result = result * 59 + ($issuerAlternativeNames == null ? 43 : ((Object)$issuerAlternativeNames).hashCode());
        ExPrincipal $issuerDN = this.getIssuerDN();
        result = result * 59 + ($issuerDN == null ? 43 : ((Object)$issuerDN).hashCode());
        result = result * 59 + Arrays.hashCode(this.getIssuerUniqueID());
        ExX500Principal $issuerX500Principal = this.getIssuerX500Principal();
        result = result * 59 + ($issuerX500Principal == null ? 43 : ((Object)$issuerX500Principal).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyUsage());
        Set<String> $nonCriticalExtensionOIDs = this.getNonCriticalExtensionOIDs();
        result = result * 59 + ($nonCriticalExtensionOIDs == null ? 43 : ((Object)$nonCriticalExtensionOIDs).hashCode());
        ExDate $notAfter = this.getNotAfter();
        result = result * 59 + ($notAfter == null ? 43 : ((Object)$notAfter).hashCode());
        ExDate $notBefore = this.getNotBefore();
        result = result * 59 + ($notBefore == null ? 43 : ((Object)$notBefore).hashCode());
        ExPublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        BigInteger $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : ((Object)$serialNumber).hashCode());
        String $signatureAlgorithmName = this.getSignatureAlgorithmName();
        result = result * 59 + ($signatureAlgorithmName == null ? 43 : $signatureAlgorithmName.hashCode());
        String $signatureAlgorithmOID = this.getSignatureAlgorithmOID();
        result = result * 59 + ($signatureAlgorithmOID == null ? 43 : $signatureAlgorithmOID.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignatureAlgorithmParams());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        Collection<List<Object>> $subjectAlternativeNames = this.getSubjectAlternativeNames();
        result = result * 59 + ($subjectAlternativeNames == null ? 43 : ((Object)$subjectAlternativeNames).hashCode());
        ExPrincipal $subjectDN = this.getSubjectDN();
        result = result * 59 + ($subjectDN == null ? 43 : ((Object)$subjectDN).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSubjectUniqueID());
        ExX500Principal $subjectX500Principal = this.getSubjectX500Principal();
        result = result * 59 + ($subjectX500Principal == null ? 43 : ((Object)$subjectX500Principal).hashCode());
        result = result * 59 + Arrays.hashCode(this.getTbsCertificate());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isHasUnsupportedCriticalExtension() ? 79 : 97);
        Boolean $notYetValidFlag = this.getNotYetValidFlag();
        result = result * 59 + ($notYetValidFlag == null ? 43 : ((Object)$notYetValidFlag).hashCode());
        Boolean $expiredFlag = this.getExpiredFlag();
        result = result * 59 + ($expiredFlag == null ? 43 : ((Object)$expiredFlag).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExX509Certificate(basicConstraints=" + this.getBasicConstraints() + ", criticalExtensionOIDs=" + this.getCriticalExtensionOIDs() + ", encoded=" + Arrays.toString(this.getEncoded()) + ", extendedKeyUsage=" + this.getExtendedKeyUsage() + ", issuerAlternativeNames=" + this.getIssuerAlternativeNames() + ", issuerDN=" + this.getIssuerDN() + ", issuerUniqueID=" + Arrays.toString(this.getIssuerUniqueID()) + ", issuerX500Principal=" + this.getIssuerX500Principal() + ", keyUsage=" + Arrays.toString(this.getKeyUsage()) + ", nonCriticalExtensionOIDs=" + this.getNonCriticalExtensionOIDs() + ", notAfter=" + this.getNotAfter() + ", notBefore=" + this.getNotBefore() + ", publicKey=" + this.getPublicKey() + ", serialNumber=" + this.getSerialNumber() + ", signatureAlgorithmName=" + this.getSignatureAlgorithmName() + ", signatureAlgorithmOID=" + this.getSignatureAlgorithmOID() + ", signatureAlgorithmParams=" + Arrays.toString(this.getSignatureAlgorithmParams()) + ", signature=" + Arrays.toString(this.getSignature()) + ", subjectAlternativeNames=" + this.getSubjectAlternativeNames() + ", subjectDN=" + this.getSubjectDN() + ", subjectUniqueID=" + Arrays.toString(this.getSubjectUniqueID()) + ", subjectX500Principal=" + this.getSubjectX500Principal() + ", tbsCertificate=" + Arrays.toString(this.getTbsCertificate()) + ", type=" + this.getType() + ", version=" + this.getVersion() + ", hasUnsupportedCriticalExtension=" + this.isHasUnsupportedCriticalExtension() + ", notYetValidFlag=" + this.getNotYetValidFlag() + ", expiredFlag=" + this.getExpiredFlag() + ")";
    }

    public ExX509Certificate() {
    }

    public ExX509Certificate(int basicConstraints, Set<String> criticalExtensionOIDs, byte[] encoded, List<String> extendedKeyUsage, Collection<List<Object>> issuerAlternativeNames, ExPrincipal issuerDN, boolean[] issuerUniqueID, ExX500Principal issuerX500Principal, boolean[] keyUsage, Set<String> nonCriticalExtensionOIDs, ExDate notAfter, ExDate notBefore, ExPublicKey publicKey, BigInteger serialNumber, String signatureAlgorithmName, String signatureAlgorithmOID, byte[] signatureAlgorithmParams, byte[] signature, Collection<List<Object>> subjectAlternativeNames, ExPrincipal subjectDN, boolean[] subjectUniqueID, ExX500Principal subjectX500Principal, byte[] tbsCertificate, String type, int version, boolean hasUnsupportedCriticalExtension, Boolean notYetValidFlag, Boolean expiredFlag) {
        this.basicConstraints = basicConstraints;
        this.criticalExtensionOIDs = criticalExtensionOIDs;
        this.encoded = encoded;
        this.extendedKeyUsage = extendedKeyUsage;
        this.issuerAlternativeNames = issuerAlternativeNames;
        this.issuerDN = issuerDN;
        this.issuerUniqueID = issuerUniqueID;
        this.issuerX500Principal = issuerX500Principal;
        this.keyUsage = keyUsage;
        this.nonCriticalExtensionOIDs = nonCriticalExtensionOIDs;
        this.notAfter = notAfter;
        this.notBefore = notBefore;
        this.publicKey = publicKey;
        this.serialNumber = serialNumber;
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.signatureAlgorithmOID = signatureAlgorithmOID;
        this.signatureAlgorithmParams = signatureAlgorithmParams;
        this.signature = signature;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.subjectDN = subjectDN;
        this.subjectUniqueID = subjectUniqueID;
        this.subjectX500Principal = subjectX500Principal;
        this.tbsCertificate = tbsCertificate;
        this.type = type;
        this.version = version;
        this.hasUnsupportedCriticalExtension = hasUnsupportedCriticalExtension;
        this.notYetValidFlag = notYetValidFlag;
        this.expiredFlag = expiredFlag;
    }

    public static class ExX509CertificateBuilder {
        private int basicConstraints;
        private Set<String> criticalExtensionOIDs;
        private byte[] encoded;
        private List<String> extendedKeyUsage;
        private Collection<List<Object>> issuerAlternativeNames;
        private ExPrincipal issuerDN;
        private boolean[] issuerUniqueID;
        private ExX500Principal issuerX500Principal;
        private boolean[] keyUsage;
        private Set<String> nonCriticalExtensionOIDs;
        private ExDate notAfter;
        private ExDate notBefore;
        private ExPublicKey publicKey;
        private BigInteger serialNumber;
        private String signatureAlgorithmName;
        private String signatureAlgorithmOID;
        private byte[] signatureAlgorithmParams;
        private byte[] signature;
        private Collection<List<Object>> subjectAlternativeNames;
        private ExPrincipal subjectDN;
        private boolean[] subjectUniqueID;
        private ExX500Principal subjectX500Principal;
        private byte[] tbsCertificate;
        private String type;
        private int version;
        private boolean hasUnsupportedCriticalExtension;
        private Boolean notYetValidFlag;
        private Boolean expiredFlag;

        ExX509CertificateBuilder() {
        }

        public ExX509CertificateBuilder basicConstraints(int basicConstraints) {
            this.basicConstraints = basicConstraints;
            return this;
        }

        public ExX509CertificateBuilder criticalExtensionOIDs(Set<String> criticalExtensionOIDs) {
            this.criticalExtensionOIDs = criticalExtensionOIDs;
            return this;
        }

        public ExX509CertificateBuilder encoded(byte[] encoded) {
            this.encoded = encoded;
            return this;
        }

        public ExX509CertificateBuilder extendedKeyUsage(List<String> extendedKeyUsage) {
            this.extendedKeyUsage = extendedKeyUsage;
            return this;
        }

        public ExX509CertificateBuilder issuerAlternativeNames(Collection<List<Object>> issuerAlternativeNames) {
            this.issuerAlternativeNames = issuerAlternativeNames;
            return this;
        }

        public ExX509CertificateBuilder issuerDN(ExPrincipal issuerDN) {
            this.issuerDN = issuerDN;
            return this;
        }

        public ExX509CertificateBuilder issuerUniqueID(boolean[] issuerUniqueID) {
            this.issuerUniqueID = issuerUniqueID;
            return this;
        }

        public ExX509CertificateBuilder issuerX500Principal(ExX500Principal issuerX500Principal) {
            this.issuerX500Principal = issuerX500Principal;
            return this;
        }

        public ExX509CertificateBuilder keyUsage(boolean[] keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public ExX509CertificateBuilder nonCriticalExtensionOIDs(Set<String> nonCriticalExtensionOIDs) {
            this.nonCriticalExtensionOIDs = nonCriticalExtensionOIDs;
            return this;
        }

        public ExX509CertificateBuilder notAfter(ExDate notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public ExX509CertificateBuilder notBefore(ExDate notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public ExX509CertificateBuilder publicKey(ExPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ExX509CertificateBuilder serialNumber(BigInteger serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public ExX509CertificateBuilder signatureAlgorithmName(String signatureAlgorithmName) {
            this.signatureAlgorithmName = signatureAlgorithmName;
            return this;
        }

        public ExX509CertificateBuilder signatureAlgorithmOID(String signatureAlgorithmOID) {
            this.signatureAlgorithmOID = signatureAlgorithmOID;
            return this;
        }

        public ExX509CertificateBuilder signatureAlgorithmParams(byte[] signatureAlgorithmParams) {
            this.signatureAlgorithmParams = signatureAlgorithmParams;
            return this;
        }

        public ExX509CertificateBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public ExX509CertificateBuilder subjectAlternativeNames(Collection<List<Object>> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        public ExX509CertificateBuilder subjectDN(ExPrincipal subjectDN) {
            this.subjectDN = subjectDN;
            return this;
        }

        public ExX509CertificateBuilder subjectUniqueID(boolean[] subjectUniqueID) {
            this.subjectUniqueID = subjectUniqueID;
            return this;
        }

        public ExX509CertificateBuilder subjectX500Principal(ExX500Principal subjectX500Principal) {
            this.subjectX500Principal = subjectX500Principal;
            return this;
        }

        public ExX509CertificateBuilder tbsCertificate(byte[] tbsCertificate) {
            this.tbsCertificate = tbsCertificate;
            return this;
        }

        public ExX509CertificateBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ExX509CertificateBuilder version(int version) {
            this.version = version;
            return this;
        }

        public ExX509CertificateBuilder hasUnsupportedCriticalExtension(boolean hasUnsupportedCriticalExtension) {
            this.hasUnsupportedCriticalExtension = hasUnsupportedCriticalExtension;
            return this;
        }

        public ExX509CertificateBuilder notYetValidFlag(Boolean notYetValidFlag) {
            this.notYetValidFlag = notYetValidFlag;
            return this;
        }

        public ExX509CertificateBuilder expiredFlag(Boolean expiredFlag) {
            this.expiredFlag = expiredFlag;
            return this;
        }

        public ExX509Certificate build() {
            return new ExX509Certificate(this.basicConstraints, this.criticalExtensionOIDs, this.encoded, this.extendedKeyUsage, this.issuerAlternativeNames, this.issuerDN, this.issuerUniqueID, this.issuerX500Principal, this.keyUsage, this.nonCriticalExtensionOIDs, this.notAfter, this.notBefore, this.publicKey, this.serialNumber, this.signatureAlgorithmName, this.signatureAlgorithmOID, this.signatureAlgorithmParams, this.signature, this.subjectAlternativeNames, this.subjectDN, this.subjectUniqueID, this.subjectX500Principal, this.tbsCertificate, this.type, this.version, this.hasUnsupportedCriticalExtension, this.notYetValidFlag, this.expiredFlag);
        }

        public String toString() {
            return "ExX509Certificate.ExX509CertificateBuilder(basicConstraints=" + this.basicConstraints + ", criticalExtensionOIDs=" + this.criticalExtensionOIDs + ", encoded=" + Arrays.toString(this.encoded) + ", extendedKeyUsage=" + this.extendedKeyUsage + ", issuerAlternativeNames=" + this.issuerAlternativeNames + ", issuerDN=" + this.issuerDN + ", issuerUniqueID=" + Arrays.toString(this.issuerUniqueID) + ", issuerX500Principal=" + this.issuerX500Principal + ", keyUsage=" + Arrays.toString(this.keyUsage) + ", nonCriticalExtensionOIDs=" + this.nonCriticalExtensionOIDs + ", notAfter=" + this.notAfter + ", notBefore=" + this.notBefore + ", publicKey=" + this.publicKey + ", serialNumber=" + this.serialNumber + ", signatureAlgorithmName=" + this.signatureAlgorithmName + ", signatureAlgorithmOID=" + this.signatureAlgorithmOID + ", signatureAlgorithmParams=" + Arrays.toString(this.signatureAlgorithmParams) + ", signature=" + Arrays.toString(this.signature) + ", subjectAlternativeNames=" + this.subjectAlternativeNames + ", subjectDN=" + this.subjectDN + ", subjectUniqueID=" + Arrays.toString(this.subjectUniqueID) + ", subjectX500Principal=" + this.subjectX500Principal + ", tbsCertificate=" + Arrays.toString(this.tbsCertificate) + ", type=" + this.type + ", version=" + this.version + ", hasUnsupportedCriticalExtension=" + this.hasUnsupportedCriticalExtension + ", notYetValidFlag=" + this.notYetValidFlag + ", expiredFlag=" + this.expiredFlag + ")";
        }
    }
}

