/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExURL;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExURI
extends ExBase
implements Serializable {
    private String authority;
    private String fragment;
    private String host;
    private String path;
    private int port;
    private String query;
    private String rawAuthority;
    private String rawFragment;
    private String rawPath;
    private String rawQuery;
    private String rawSchemeSpecificPart;
    private String rawUserInfo;
    private String scheme;
    private String schemeSpecificPart;
    private String userInfo;
    private boolean absoluteFlag;
    private boolean opaqueFlag;
    private String toASCIIString;
    private ExURI normalize;
    private ExURI serverAuthority;
    private ExURL url;

    public ExURI(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExURIBuilder builder() {
        return new ExURIBuilder();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRawAuthority() {
        return this.rawAuthority;
    }

    public String getRawFragment() {
        return this.rawFragment;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public String getRawSchemeSpecificPart() {
        return this.rawSchemeSpecificPart;
    }

    public String getRawUserInfo() {
        return this.rawUserInfo;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public boolean isAbsoluteFlag() {
        return this.absoluteFlag;
    }

    public boolean isOpaqueFlag() {
        return this.opaqueFlag;
    }

    public String getToASCIIString() {
        return this.toASCIIString;
    }

    public ExURI getNormalize() {
        return this.normalize;
    }

    public ExURI getServerAuthority() {
        return this.serverAuthority;
    }

    public ExURL getUrl() {
        return this.url;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setRawAuthority(String rawAuthority) {
        this.rawAuthority = rawAuthority;
    }

    public void setRawFragment(String rawFragment) {
        this.rawFragment = rawFragment;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    public void setRawQuery(String rawQuery) {
        this.rawQuery = rawQuery;
    }

    public void setRawSchemeSpecificPart(String rawSchemeSpecificPart) {
        this.rawSchemeSpecificPart = rawSchemeSpecificPart;
    }

    public void setRawUserInfo(String rawUserInfo) {
        this.rawUserInfo = rawUserInfo;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSchemeSpecificPart(String schemeSpecificPart) {
        this.schemeSpecificPart = schemeSpecificPart;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setAbsoluteFlag(boolean absoluteFlag) {
        this.absoluteFlag = absoluteFlag;
    }

    public void setOpaqueFlag(boolean opaqueFlag) {
        this.opaqueFlag = opaqueFlag;
    }

    public void setToASCIIString(String toASCIIString) {
        this.toASCIIString = toASCIIString;
    }

    public void setNormalize(ExURI normalize) {
        this.normalize = normalize;
    }

    public void setServerAuthority(ExURI serverAuthority) {
        this.serverAuthority = serverAuthority;
    }

    public void setUrl(ExURL url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExURI)) {
            return false;
        }
        ExURI other = (ExURI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authority = this.getAuthority();
        String other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
            return false;
        }
        String this$fragment = this.getFragment();
        String other$fragment = other.getFragment();
        if (this$fragment == null ? other$fragment != null : !this$fragment.equals(other$fragment)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$rawAuthority = this.getRawAuthority();
        String other$rawAuthority = other.getRawAuthority();
        if (this$rawAuthority == null ? other$rawAuthority != null : !this$rawAuthority.equals(other$rawAuthority)) {
            return false;
        }
        String this$rawFragment = this.getRawFragment();
        String other$rawFragment = other.getRawFragment();
        if (this$rawFragment == null ? other$rawFragment != null : !this$rawFragment.equals(other$rawFragment)) {
            return false;
        }
        String this$rawPath = this.getRawPath();
        String other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) {
            return false;
        }
        String this$rawQuery = this.getRawQuery();
        String other$rawQuery = other.getRawQuery();
        if (this$rawQuery == null ? other$rawQuery != null : !this$rawQuery.equals(other$rawQuery)) {
            return false;
        }
        String this$rawSchemeSpecificPart = this.getRawSchemeSpecificPart();
        String other$rawSchemeSpecificPart = other.getRawSchemeSpecificPart();
        if (this$rawSchemeSpecificPart == null ? other$rawSchemeSpecificPart != null : !this$rawSchemeSpecificPart.equals(other$rawSchemeSpecificPart)) {
            return false;
        }
        String this$rawUserInfo = this.getRawUserInfo();
        String other$rawUserInfo = other.getRawUserInfo();
        if (this$rawUserInfo == null ? other$rawUserInfo != null : !this$rawUserInfo.equals(other$rawUserInfo)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$schemeSpecificPart = this.getSchemeSpecificPart();
        String other$schemeSpecificPart = other.getSchemeSpecificPart();
        if (this$schemeSpecificPart == null ? other$schemeSpecificPart != null : !this$schemeSpecificPart.equals(other$schemeSpecificPart)) {
            return false;
        }
        String this$userInfo = this.getUserInfo();
        String other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !this$userInfo.equals(other$userInfo)) {
            return false;
        }
        if (this.isAbsoluteFlag() != other.isAbsoluteFlag()) {
            return false;
        }
        if (this.isOpaqueFlag() != other.isOpaqueFlag()) {
            return false;
        }
        String this$toASCIIString = this.getToASCIIString();
        String other$toASCIIString = other.getToASCIIString();
        if (this$toASCIIString == null ? other$toASCIIString != null : !this$toASCIIString.equals(other$toASCIIString)) {
            return false;
        }
        ExURI this$normalize = this.getNormalize();
        ExURI other$normalize = other.getNormalize();
        if (this$normalize == null ? other$normalize != null : !((Object)this$normalize).equals(other$normalize)) {
            return false;
        }
        ExURI this$serverAuthority = this.getServerAuthority();
        ExURI other$serverAuthority = other.getServerAuthority();
        if (this$serverAuthority == null ? other$serverAuthority != null : !((Object)this$serverAuthority).equals(other$serverAuthority)) {
            return false;
        }
        ExURL this$url = this.getUrl();
        ExURL other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExURI;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
        String $fragment = this.getFragment();
        result = result * 59 + ($fragment == null ? 43 : $fragment.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + this.getPort();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $rawAuthority = this.getRawAuthority();
        result = result * 59 + ($rawAuthority == null ? 43 : $rawAuthority.hashCode());
        String $rawFragment = this.getRawFragment();
        result = result * 59 + ($rawFragment == null ? 43 : $rawFragment.hashCode());
        String $rawPath = this.getRawPath();
        result = result * 59 + ($rawPath == null ? 43 : $rawPath.hashCode());
        String $rawQuery = this.getRawQuery();
        result = result * 59 + ($rawQuery == null ? 43 : $rawQuery.hashCode());
        String $rawSchemeSpecificPart = this.getRawSchemeSpecificPart();
        result = result * 59 + ($rawSchemeSpecificPart == null ? 43 : $rawSchemeSpecificPart.hashCode());
        String $rawUserInfo = this.getRawUserInfo();
        result = result * 59 + ($rawUserInfo == null ? 43 : $rawUserInfo.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $schemeSpecificPart = this.getSchemeSpecificPart();
        result = result * 59 + ($schemeSpecificPart == null ? 43 : $schemeSpecificPart.hashCode());
        String $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : $userInfo.hashCode());
        result = result * 59 + (this.isAbsoluteFlag() ? 79 : 97);
        result = result * 59 + (this.isOpaqueFlag() ? 79 : 97);
        String $toASCIIString = this.getToASCIIString();
        result = result * 59 + ($toASCIIString == null ? 43 : $toASCIIString.hashCode());
        ExURI $normalize = this.getNormalize();
        result = result * 59 + ($normalize == null ? 43 : ((Object)$normalize).hashCode());
        ExURI $serverAuthority = this.getServerAuthority();
        result = result * 59 + ($serverAuthority == null ? 43 : ((Object)$serverAuthority).hashCode());
        ExURL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExURI(authority=" + this.getAuthority() + ", fragment=" + this.getFragment() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", query=" + this.getQuery() + ", rawAuthority=" + this.getRawAuthority() + ", rawFragment=" + this.getRawFragment() + ", rawPath=" + this.getRawPath() + ", rawQuery=" + this.getRawQuery() + ", rawSchemeSpecificPart=" + this.getRawSchemeSpecificPart() + ", rawUserInfo=" + this.getRawUserInfo() + ", scheme=" + this.getScheme() + ", schemeSpecificPart=" + this.getSchemeSpecificPart() + ", userInfo=" + this.getUserInfo() + ", absoluteFlag=" + this.isAbsoluteFlag() + ", opaqueFlag=" + this.isOpaqueFlag() + ", toASCIIString=" + this.getToASCIIString() + ", normalize=" + this.getNormalize() + ", serverAuthority=" + this.getServerAuthority() + ", url=" + this.getUrl() + ")";
    }

    public ExURI() {
    }

    public ExURI(String authority, String fragment, String host, String path, int port, String query, String rawAuthority, String rawFragment, String rawPath, String rawQuery, String rawSchemeSpecificPart, String rawUserInfo, String scheme, String schemeSpecificPart, String userInfo, boolean absoluteFlag, boolean opaqueFlag, String toASCIIString, ExURI normalize, ExURI serverAuthority, ExURL url) {
        this.authority = authority;
        this.fragment = fragment;
        this.host = host;
        this.path = path;
        this.port = port;
        this.query = query;
        this.rawAuthority = rawAuthority;
        this.rawFragment = rawFragment;
        this.rawPath = rawPath;
        this.rawQuery = rawQuery;
        this.rawSchemeSpecificPart = rawSchemeSpecificPart;
        this.rawUserInfo = rawUserInfo;
        this.scheme = scheme;
        this.schemeSpecificPart = schemeSpecificPart;
        this.userInfo = userInfo;
        this.absoluteFlag = absoluteFlag;
        this.opaqueFlag = opaqueFlag;
        this.toASCIIString = toASCIIString;
        this.normalize = normalize;
        this.serverAuthority = serverAuthority;
        this.url = url;
    }

    public static class ExURIBuilder {
        private String authority;
        private String fragment;
        private String host;
        private String path;
        private int port;
        private String query;
        private String rawAuthority;
        private String rawFragment;
        private String rawPath;
        private String rawQuery;
        private String rawSchemeSpecificPart;
        private String rawUserInfo;
        private String scheme;
        private String schemeSpecificPart;
        private String userInfo;
        private boolean absoluteFlag;
        private boolean opaqueFlag;
        private String toASCIIString;
        private ExURI normalize;
        private ExURI serverAuthority;
        private ExURL url;

        ExURIBuilder() {
        }

        public ExURIBuilder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public ExURIBuilder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public ExURIBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ExURIBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ExURIBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ExURIBuilder query(String query) {
            this.query = query;
            return this;
        }

        public ExURIBuilder rawAuthority(String rawAuthority) {
            this.rawAuthority = rawAuthority;
            return this;
        }

        public ExURIBuilder rawFragment(String rawFragment) {
            this.rawFragment = rawFragment;
            return this;
        }

        public ExURIBuilder rawPath(String rawPath) {
            this.rawPath = rawPath;
            return this;
        }

        public ExURIBuilder rawQuery(String rawQuery) {
            this.rawQuery = rawQuery;
            return this;
        }

        public ExURIBuilder rawSchemeSpecificPart(String rawSchemeSpecificPart) {
            this.rawSchemeSpecificPart = rawSchemeSpecificPart;
            return this;
        }

        public ExURIBuilder rawUserInfo(String rawUserInfo) {
            this.rawUserInfo = rawUserInfo;
            return this;
        }

        public ExURIBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public ExURIBuilder schemeSpecificPart(String schemeSpecificPart) {
            this.schemeSpecificPart = schemeSpecificPart;
            return this;
        }

        public ExURIBuilder userInfo(String userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public ExURIBuilder absoluteFlag(boolean absoluteFlag) {
            this.absoluteFlag = absoluteFlag;
            return this;
        }

        public ExURIBuilder opaqueFlag(boolean opaqueFlag) {
            this.opaqueFlag = opaqueFlag;
            return this;
        }

        public ExURIBuilder toASCIIString(String toASCIIString) {
            this.toASCIIString = toASCIIString;
            return this;
        }

        public ExURIBuilder normalize(ExURI normalize) {
            this.normalize = normalize;
            return this;
        }

        public ExURIBuilder serverAuthority(ExURI serverAuthority) {
            this.serverAuthority = serverAuthority;
            return this;
        }

        public ExURIBuilder url(ExURL url) {
            this.url = url;
            return this;
        }

        public ExURI build() {
            return new ExURI(this.authority, this.fragment, this.host, this.path, this.port, this.query, this.rawAuthority, this.rawFragment, this.rawPath, this.rawQuery, this.rawSchemeSpecificPart, this.rawUserInfo, this.scheme, this.schemeSpecificPart, this.userInfo, this.absoluteFlag, this.opaqueFlag, this.toASCIIString, this.normalize, this.serverAuthority, this.url);
        }

        public String toString() {
            return "ExURI.ExURIBuilder(authority=" + this.authority + ", fragment=" + this.fragment + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", query=" + this.query + ", rawAuthority=" + this.rawAuthority + ", rawFragment=" + this.rawFragment + ", rawPath=" + this.rawPath + ", rawQuery=" + this.rawQuery + ", rawSchemeSpecificPart=" + this.rawSchemeSpecificPart + ", rawUserInfo=" + this.rawUserInfo + ", scheme=" + this.scheme + ", schemeSpecificPart=" + this.schemeSpecificPart + ", userInfo=" + this.userInfo + ", absoluteFlag=" + this.absoluteFlag + ", opaqueFlag=" + this.opaqueFlag + ", toASCIIString=" + this.toASCIIString + ", normalize=" + this.normalize + ", serverAuthority=" + this.serverAuthority + ", url=" + this.url + ")";
        }
    }
}

