/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExHttpCookie;
import open.source.exchange.model.ExHttpHeaders;
import open.source.exchange.model.ExHttpMethod;
import open.source.exchange.model.ExInetSocketAddress;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExRequestPath;
import open.source.exchange.model.ExSslInfo;
import open.source.exchange.model.ExURI;
import org.springframework.data.mongodb.core.index.Indexed;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExServerHttpRequest
extends ExBase
implements Serializable {
    private String body;
    private ExMultiValueMap<String, ExHttpCookie> cookies;
    private ExHttpHeaders headers;
    @Indexed(background=true)
    private String id;
    private ExHttpMethod method;
    private String methodValue;
    private ExRequestPath path;
    private ExMultiValueMap<String, String> queryParams;
    private ExInetSocketAddress remoteAddress;
    private ExSslInfo sslInfo;
    private ExURI uri;

    public ExServerHttpRequest(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExServerHttpRequestBuilder builder() {
        return new ExServerHttpRequestBuilder();
    }

    public String getBody() {
        return this.body;
    }

    public ExMultiValueMap<String, ExHttpCookie> getCookies() {
        return this.cookies;
    }

    public ExHttpHeaders getHeaders() {
        return this.headers;
    }

    public String getId() {
        return this.id;
    }

    public ExHttpMethod getMethod() {
        return this.method;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public ExRequestPath getPath() {
        return this.path;
    }

    public ExMultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public ExInetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public ExSslInfo getSslInfo() {
        return this.sslInfo;
    }

    public ExURI getUri() {
        return this.uri;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setCookies(ExMultiValueMap<String, ExHttpCookie> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(ExHttpHeaders headers) {
        this.headers = headers;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMethod(ExHttpMethod method) {
        this.method = method;
    }

    public void setMethodValue(String methodValue) {
        this.methodValue = methodValue;
    }

    public void setPath(ExRequestPath path) {
        this.path = path;
    }

    public void setQueryParams(ExMultiValueMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setRemoteAddress(ExInetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setSslInfo(ExSslInfo sslInfo) {
        this.sslInfo = sslInfo;
    }

    public void setUri(ExURI uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExServerHttpRequest)) {
            return false;
        }
        ExServerHttpRequest other = (ExServerHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        ExMultiValueMap<String, ExHttpCookie> this$cookies = this.getCookies();
        ExMultiValueMap<String, ExHttpCookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        ExHttpHeaders this$headers = this.getHeaders();
        ExHttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ExHttpMethod this$method = this.getMethod();
        ExHttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        String this$methodValue = this.getMethodValue();
        String other$methodValue = other.getMethodValue();
        if (this$methodValue == null ? other$methodValue != null : !this$methodValue.equals(other$methodValue)) {
            return false;
        }
        ExRequestPath this$path = this.getPath();
        ExRequestPath other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        ExMultiValueMap<String, String> this$queryParams = this.getQueryParams();
        ExMultiValueMap<String, String> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        ExInetSocketAddress this$remoteAddress = this.getRemoteAddress();
        ExInetSocketAddress other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !((Object)this$remoteAddress).equals(other$remoteAddress)) {
            return false;
        }
        ExSslInfo this$sslInfo = this.getSslInfo();
        ExSslInfo other$sslInfo = other.getSslInfo();
        if (this$sslInfo == null ? other$sslInfo != null : !((Object)this$sslInfo).equals(other$sslInfo)) {
            return false;
        }
        ExURI this$uri = this.getUri();
        ExURI other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExServerHttpRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        ExMultiValueMap<String, ExHttpCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        ExHttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ExHttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        String $methodValue = this.getMethodValue();
        result = result * 59 + ($methodValue == null ? 43 : $methodValue.hashCode());
        ExRequestPath $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        ExMultiValueMap<String, String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        ExInetSocketAddress $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : ((Object)$remoteAddress).hashCode());
        ExSslInfo $sslInfo = this.getSslInfo();
        result = result * 59 + ($sslInfo == null ? 43 : ((Object)$sslInfo).hashCode());
        ExURI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExServerHttpRequest(body=" + this.getBody() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", id=" + this.getId() + ", method=" + this.getMethod() + ", methodValue=" + this.getMethodValue() + ", path=" + this.getPath() + ", queryParams=" + this.getQueryParams() + ", remoteAddress=" + this.getRemoteAddress() + ", sslInfo=" + this.getSslInfo() + ", uri=" + this.getUri() + ")";
    }

    public ExServerHttpRequest() {
    }

    public ExServerHttpRequest(String body, ExMultiValueMap<String, ExHttpCookie> cookies, ExHttpHeaders headers, String id, ExHttpMethod method, String methodValue, ExRequestPath path, ExMultiValueMap<String, String> queryParams, ExInetSocketAddress remoteAddress, ExSslInfo sslInfo, ExURI uri) {
        this.body = body;
        this.cookies = cookies;
        this.headers = headers;
        this.id = id;
        this.method = method;
        this.methodValue = methodValue;
        this.path = path;
        this.queryParams = queryParams;
        this.remoteAddress = remoteAddress;
        this.sslInfo = sslInfo;
        this.uri = uri;
    }

    public static class ExServerHttpRequestBuilder {
        private String body;
        private ExMultiValueMap<String, ExHttpCookie> cookies;
        private ExHttpHeaders headers;
        private String id;
        private ExHttpMethod method;
        private String methodValue;
        private ExRequestPath path;
        private ExMultiValueMap<String, String> queryParams;
        private ExInetSocketAddress remoteAddress;
        private ExSslInfo sslInfo;
        private ExURI uri;

        ExServerHttpRequestBuilder() {
        }

        public ExServerHttpRequestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ExServerHttpRequestBuilder cookies(ExMultiValueMap<String, ExHttpCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public ExServerHttpRequestBuilder headers(ExHttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public ExServerHttpRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ExServerHttpRequestBuilder method(ExHttpMethod method) {
            this.method = method;
            return this;
        }

        public ExServerHttpRequestBuilder methodValue(String methodValue) {
            this.methodValue = methodValue;
            return this;
        }

        public ExServerHttpRequestBuilder path(ExRequestPath path) {
            this.path = path;
            return this;
        }

        public ExServerHttpRequestBuilder queryParams(ExMultiValueMap<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public ExServerHttpRequestBuilder remoteAddress(ExInetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public ExServerHttpRequestBuilder sslInfo(ExSslInfo sslInfo) {
            this.sslInfo = sslInfo;
            return this;
        }

        public ExServerHttpRequestBuilder uri(ExURI uri) {
            this.uri = uri;
            return this;
        }

        public ExServerHttpRequest build() {
            return new ExServerHttpRequest(this.body, this.cookies, this.headers, this.id, this.method, this.methodValue, this.path, this.queryParams, this.remoteAddress, this.sslInfo, this.uri);
        }

        public String toString() {
            return "ExServerHttpRequest.ExServerHttpRequestBuilder(body=" + this.body + ", cookies=" + this.cookies + ", headers=" + this.headers + ", id=" + this.id + ", method=" + this.method + ", methodValue=" + this.methodValue + ", path=" + this.path + ", queryParams=" + this.queryParams + ", remoteAddress=" + this.remoteAddress + ", sslInfo=" + this.sslInfo + ", uri=" + this.uri + ")";
        }
    }
}

