/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import open.source.exchange.model.ExDuration;
import open.source.exchange.model.ExHttpCookie;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExResponseCookie
extends ExHttpCookie
implements Serializable {
    private String domain;
    private ExDuration maxAge;
    private String path;
    private String sameSite;
    private boolean httpOnlyFlag;
    private boolean secureFlag;

    public ExResponseCookie(ExHttpCookie exHttpCookie) {
        super(exHttpCookie);
        if (null != exHttpCookie) {
            this.setName(exHttpCookie.getName());
            this.setValue(exHttpCookie.getValue());
        }
    }

    public static ExResponseCookieBuilder builder() {
        return new ExResponseCookieBuilder();
    }

    public String getDomain() {
        return this.domain;
    }

    public ExDuration getMaxAge() {
        return this.maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public boolean isHttpOnlyFlag() {
        return this.httpOnlyFlag;
    }

    public boolean isSecureFlag() {
        return this.secureFlag;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setMaxAge(ExDuration maxAge) {
        this.maxAge = maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSameSite(String sameSite) {
        this.sameSite = sameSite;
    }

    public void setHttpOnlyFlag(boolean httpOnlyFlag) {
        this.httpOnlyFlag = httpOnlyFlag;
    }

    public void setSecureFlag(boolean secureFlag) {
        this.secureFlag = secureFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExResponseCookie)) {
            return false;
        }
        ExResponseCookie other = (ExResponseCookie)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        ExDuration this$maxAge = this.getMaxAge();
        ExDuration other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$sameSite = this.getSameSite();
        String other$sameSite = other.getSameSite();
        if (this$sameSite == null ? other$sameSite != null : !this$sameSite.equals(other$sameSite)) {
            return false;
        }
        if (this.isHttpOnlyFlag() != other.isHttpOnlyFlag()) {
            return false;
        }
        return this.isSecureFlag() == other.isSecureFlag();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExResponseCookie;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        ExDuration $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $sameSite = this.getSameSite();
        result = result * 59 + ($sameSite == null ? 43 : $sameSite.hashCode());
        result = result * 59 + (this.isHttpOnlyFlag() ? 79 : 97);
        result = result * 59 + (this.isSecureFlag() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "ExResponseCookie(domain=" + this.getDomain() + ", maxAge=" + this.getMaxAge() + ", path=" + this.getPath() + ", sameSite=" + this.getSameSite() + ", httpOnlyFlag=" + this.isHttpOnlyFlag() + ", secureFlag=" + this.isSecureFlag() + ")";
    }

    public ExResponseCookie() {
    }

    public ExResponseCookie(String domain, ExDuration maxAge, String path, String sameSite, boolean httpOnlyFlag, boolean secureFlag) {
        this.domain = domain;
        this.maxAge = maxAge;
        this.path = path;
        this.sameSite = sameSite;
        this.httpOnlyFlag = httpOnlyFlag;
        this.secureFlag = secureFlag;
    }

    public static class ExResponseCookieBuilder {
        private String domain;
        private ExDuration maxAge;
        private String path;
        private String sameSite;
        private boolean httpOnlyFlag;
        private boolean secureFlag;

        ExResponseCookieBuilder() {
        }

        public ExResponseCookieBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ExResponseCookieBuilder maxAge(ExDuration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public ExResponseCookieBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ExResponseCookieBuilder sameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public ExResponseCookieBuilder httpOnlyFlag(boolean httpOnlyFlag) {
            this.httpOnlyFlag = httpOnlyFlag;
            return this;
        }

        public ExResponseCookieBuilder secureFlag(boolean secureFlag) {
            this.secureFlag = secureFlag;
            return this;
        }

        public ExResponseCookie build() {
            return new ExResponseCookie(this.domain, this.maxAge, this.path, this.sameSite, this.httpOnlyFlag, this.secureFlag);
        }

        public String toString() {
            return "ExResponseCookie.ExResponseCookieBuilder(domain=" + this.domain + ", maxAge=" + this.maxAge + ", path=" + this.path + ", sameSite=" + this.sameSite + ", httpOnlyFlag=" + this.httpOnlyFlag + ", secureFlag=" + this.secureFlag + ")";
        }
    }
}

