/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import open.source.exchange.model.ExBase;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExPublicKey
extends ExBase
implements Serializable {
    private String algorithm;
    private byte[] encoded;
    private String format;

    public ExPublicKey(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExPublicKeyBuilder builder() {
        return new ExPublicKeyBuilder();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public String getFormat() {
        return this.format;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setEncoded(byte[] encoded) {
        this.encoded = encoded;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExPublicKey)) {
            return false;
        }
        ExPublicKey other = (ExPublicKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        if (!Arrays.equals(this.getEncoded(), other.getEncoded())) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExPublicKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        result = result * 59 + Arrays.hashCode(this.getEncoded());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExPublicKey(algorithm=" + this.getAlgorithm() + ", encoded=" + Arrays.toString(this.getEncoded()) + ", format=" + this.getFormat() + ")";
    }

    public ExPublicKey() {
    }

    public ExPublicKey(String algorithm, byte[] encoded, String format) {
        this.algorithm = algorithm;
        this.encoded = encoded;
        this.format = format;
    }

    public static class ExPublicKeyBuilder {
        private String algorithm;
        private byte[] encoded;
        private String format;

        ExPublicKeyBuilder() {
        }

        public ExPublicKeyBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public ExPublicKeyBuilder encoded(byte[] encoded) {
            this.encoded = encoded;
            return this;
        }

        public ExPublicKeyBuilder format(String format) {
            this.format = format;
            return this;
        }

        public ExPublicKey build() {
            return new ExPublicKey(this.algorithm, this.encoded, this.format);
        }

        public String toString() {
            return "ExPublicKey.ExPublicKeyBuilder(algorithm=" + this.algorithm + ", encoded=" + Arrays.toString(this.encoded) + ", format=" + this.format + ")";
        }
    }
}

