/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExMediaType
extends ExBase
implements Serializable {
    private ExCharset charset;
    private Map<String, String> parameters;
    private double qualityValue;
    private String type;
    private String subtype;
    private boolean isConcrete;
    private boolean isWildcardType;
    private boolean isWildcardSubtype;
    private ExMediaType removeQualityValue;

    public ExMediaType(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExMediaTypeBuilder builder() {
        return new ExMediaTypeBuilder();
    }

    public ExCharset getCharset() {
        return this.charset;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public double getQualityValue() {
        return this.qualityValue;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isConcrete() {
        return this.isConcrete;
    }

    public boolean isWildcardType() {
        return this.isWildcardType;
    }

    public boolean isWildcardSubtype() {
        return this.isWildcardSubtype;
    }

    public ExMediaType getRemoveQualityValue() {
        return this.removeQualityValue;
    }

    public void setCharset(ExCharset charset) {
        this.charset = charset;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setQualityValue(double qualityValue) {
        this.qualityValue = qualityValue;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void setConcrete(boolean isConcrete) {
        this.isConcrete = isConcrete;
    }

    public void setWildcardType(boolean isWildcardType) {
        this.isWildcardType = isWildcardType;
    }

    public void setWildcardSubtype(boolean isWildcardSubtype) {
        this.isWildcardSubtype = isWildcardSubtype;
    }

    public void setRemoveQualityValue(ExMediaType removeQualityValue) {
        this.removeQualityValue = removeQualityValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExMediaType)) {
            return false;
        }
        ExMediaType other = (ExMediaType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExCharset this$charset = this.getCharset();
        ExCharset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        if (Double.compare(this.getQualityValue(), other.getQualityValue()) != 0) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subtype = this.getSubtype();
        String other$subtype = other.getSubtype();
        if (this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype)) {
            return false;
        }
        if (this.isConcrete() != other.isConcrete()) {
            return false;
        }
        if (this.isWildcardType() != other.isWildcardType()) {
            return false;
        }
        if (this.isWildcardSubtype() != other.isWildcardSubtype()) {
            return false;
        }
        ExMediaType this$removeQualityValue = this.getRemoveQualityValue();
        ExMediaType other$removeQualityValue = other.getRemoveQualityValue();
        return !(this$removeQualityValue == null ? other$removeQualityValue != null : !((Object)this$removeQualityValue).equals(other$removeQualityValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExMediaType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExCharset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        long $qualityValue = Double.doubleToLongBits(this.getQualityValue());
        result = result * 59 + (int)($qualityValue >>> 32 ^ $qualityValue);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subtype = this.getSubtype();
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        result = result * 59 + (this.isConcrete() ? 79 : 97);
        result = result * 59 + (this.isWildcardType() ? 79 : 97);
        result = result * 59 + (this.isWildcardSubtype() ? 79 : 97);
        ExMediaType $removeQualityValue = this.getRemoveQualityValue();
        result = result * 59 + ($removeQualityValue == null ? 43 : ((Object)$removeQualityValue).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExMediaType(charset=" + this.getCharset() + ", parameters=" + this.getParameters() + ", qualityValue=" + this.getQualityValue() + ", type=" + this.getType() + ", subtype=" + this.getSubtype() + ", isConcrete=" + this.isConcrete() + ", isWildcardType=" + this.isWildcardType() + ", isWildcardSubtype=" + this.isWildcardSubtype() + ", removeQualityValue=" + this.getRemoveQualityValue() + ")";
    }

    public ExMediaType() {
    }

    public ExMediaType(ExCharset charset, Map<String, String> parameters, double qualityValue, String type, String subtype, boolean isConcrete, boolean isWildcardType, boolean isWildcardSubtype, ExMediaType removeQualityValue) {
        this.charset = charset;
        this.parameters = parameters;
        this.qualityValue = qualityValue;
        this.type = type;
        this.subtype = subtype;
        this.isConcrete = isConcrete;
        this.isWildcardType = isWildcardType;
        this.isWildcardSubtype = isWildcardSubtype;
        this.removeQualityValue = removeQualityValue;
    }

    public static class ExMediaTypeBuilder {
        private ExCharset charset;
        private Map<String, String> parameters;
        private double qualityValue;
        private String type;
        private String subtype;
        private boolean isConcrete;
        private boolean isWildcardType;
        private boolean isWildcardSubtype;
        private ExMediaType removeQualityValue;

        ExMediaTypeBuilder() {
        }

        public ExMediaTypeBuilder charset(ExCharset charset) {
            this.charset = charset;
            return this;
        }

        public ExMediaTypeBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ExMediaTypeBuilder qualityValue(double qualityValue) {
            this.qualityValue = qualityValue;
            return this;
        }

        public ExMediaTypeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ExMediaTypeBuilder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public ExMediaTypeBuilder isConcrete(boolean isConcrete) {
            this.isConcrete = isConcrete;
            return this;
        }

        public ExMediaTypeBuilder isWildcardType(boolean isWildcardType) {
            this.isWildcardType = isWildcardType;
            return this;
        }

        public ExMediaTypeBuilder isWildcardSubtype(boolean isWildcardSubtype) {
            this.isWildcardSubtype = isWildcardSubtype;
            return this;
        }

        public ExMediaTypeBuilder removeQualityValue(ExMediaType removeQualityValue) {
            this.removeQualityValue = removeQualityValue;
            return this;
        }

        public ExMediaType build() {
            return new ExMediaType(this.charset, this.parameters, this.qualityValue, this.type, this.subtype, this.isConcrete, this.isWildcardType, this.isWildcardSubtype, this.removeQualityValue);
        }

        public String toString() {
            return "ExMediaType.ExMediaTypeBuilder(charset=" + this.charset + ", parameters=" + this.parameters + ", qualityValue=" + this.qualityValue + ", type=" + this.type + ", subtype=" + this.subtype + ", isConcrete=" + this.isConcrete + ", isWildcardType=" + this.isWildcardType + ", isWildcardSubtype=" + this.isWildcardSubtype + ", removeQualityValue=" + this.removeQualityValue + ")";
        }
    }
}

