/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExInetAddress;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExInetSocketAddress
extends ExBase
implements Serializable {
    private ExInetAddress address;
    private String hostName;
    private String hostString;
    private int port;
    private boolean unresolvedFlag;

    public ExInetSocketAddress(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExInetSocketAddressBuilder builder() {
        return new ExInetSocketAddressBuilder();
    }

    public ExInetAddress getAddress() {
        return this.address;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostString() {
        return this.hostString;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUnresolvedFlag() {
        return this.unresolvedFlag;
    }

    public void setAddress(ExInetAddress address) {
        this.address = address;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setHostString(String hostString) {
        this.hostString = hostString;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUnresolvedFlag(boolean unresolvedFlag) {
        this.unresolvedFlag = unresolvedFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExInetSocketAddress)) {
            return false;
        }
        ExInetSocketAddress other = (ExInetSocketAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExInetAddress this$address = this.getAddress();
        ExInetAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$hostString = this.getHostString();
        String other$hostString = other.getHostString();
        if (this$hostString == null ? other$hostString != null : !this$hostString.equals(other$hostString)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return this.isUnresolvedFlag() == other.isUnresolvedFlag();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExInetSocketAddress;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExInetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $hostString = this.getHostString();
        result = result * 59 + ($hostString == null ? 43 : $hostString.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUnresolvedFlag() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "ExInetSocketAddress(address=" + this.getAddress() + ", hostName=" + this.getHostName() + ", hostString=" + this.getHostString() + ", port=" + this.getPort() + ", unresolvedFlag=" + this.isUnresolvedFlag() + ")";
    }

    public ExInetSocketAddress() {
    }

    public ExInetSocketAddress(ExInetAddress address, String hostName, String hostString, int port, boolean unresolvedFlag) {
        this.address = address;
        this.hostName = hostName;
        this.hostString = hostString;
        this.port = port;
        this.unresolvedFlag = unresolvedFlag;
    }

    public static class ExInetSocketAddressBuilder {
        private ExInetAddress address;
        private String hostName;
        private String hostString;
        private int port;
        private boolean unresolvedFlag;

        ExInetSocketAddressBuilder() {
        }

        public ExInetSocketAddressBuilder address(ExInetAddress address) {
            this.address = address;
            return this;
        }

        public ExInetSocketAddressBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public ExInetSocketAddressBuilder hostString(String hostString) {
            this.hostString = hostString;
            return this;
        }

        public ExInetSocketAddressBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ExInetSocketAddressBuilder unresolvedFlag(boolean unresolvedFlag) {
            this.unresolvedFlag = unresolvedFlag;
            return this;
        }

        public ExInetSocketAddress build() {
            return new ExInetSocketAddress(this.address, this.hostName, this.hostString, this.port, this.unresolvedFlag);
        }

        public String toString() {
            return "ExInetSocketAddress.ExInetSocketAddressBuilder(address=" + this.address + ", hostName=" + this.hostName + ", hostString=" + this.hostString + ", port=" + this.port + ", unresolvedFlag=" + this.unresolvedFlag + ")";
        }
    }
}

