/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import open.source.exchange.model.ExBase;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExInetAddress
extends ExBase
implements Serializable {
    private byte[] address;
    private String canonicalHostName;
    private String hostAddress;
    private String hostName;
    private boolean anyLocalAddressFlag;
    private boolean linkLocalAddressFlag;
    private boolean loopbackAddressFlag;
    private boolean multicastGlobalFlag;
    private boolean multicastLinkLocalFlag;
    private boolean multicastNodeLocalFlag;
    private boolean multicastOrgLocalFlag;
    private boolean multicastSiteLocalFlag;
    private boolean multicastAddressFlag;
    private boolean siteLocalAddressFlag;

    public ExInetAddress(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExInetAddressBuilder builder() {
        return new ExInetAddressBuilder();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isAnyLocalAddressFlag() {
        return this.anyLocalAddressFlag;
    }

    public boolean isLinkLocalAddressFlag() {
        return this.linkLocalAddressFlag;
    }

    public boolean isLoopbackAddressFlag() {
        return this.loopbackAddressFlag;
    }

    public boolean isMulticastGlobalFlag() {
        return this.multicastGlobalFlag;
    }

    public boolean isMulticastLinkLocalFlag() {
        return this.multicastLinkLocalFlag;
    }

    public boolean isMulticastNodeLocalFlag() {
        return this.multicastNodeLocalFlag;
    }

    public boolean isMulticastOrgLocalFlag() {
        return this.multicastOrgLocalFlag;
    }

    public boolean isMulticastSiteLocalFlag() {
        return this.multicastSiteLocalFlag;
    }

    public boolean isMulticastAddressFlag() {
        return this.multicastAddressFlag;
    }

    public boolean isSiteLocalAddressFlag() {
        return this.siteLocalAddressFlag;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public void setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setAnyLocalAddressFlag(boolean anyLocalAddressFlag) {
        this.anyLocalAddressFlag = anyLocalAddressFlag;
    }

    public void setLinkLocalAddressFlag(boolean linkLocalAddressFlag) {
        this.linkLocalAddressFlag = linkLocalAddressFlag;
    }

    public void setLoopbackAddressFlag(boolean loopbackAddressFlag) {
        this.loopbackAddressFlag = loopbackAddressFlag;
    }

    public void setMulticastGlobalFlag(boolean multicastGlobalFlag) {
        this.multicastGlobalFlag = multicastGlobalFlag;
    }

    public void setMulticastLinkLocalFlag(boolean multicastLinkLocalFlag) {
        this.multicastLinkLocalFlag = multicastLinkLocalFlag;
    }

    public void setMulticastNodeLocalFlag(boolean multicastNodeLocalFlag) {
        this.multicastNodeLocalFlag = multicastNodeLocalFlag;
    }

    public void setMulticastOrgLocalFlag(boolean multicastOrgLocalFlag) {
        this.multicastOrgLocalFlag = multicastOrgLocalFlag;
    }

    public void setMulticastSiteLocalFlag(boolean multicastSiteLocalFlag) {
        this.multicastSiteLocalFlag = multicastSiteLocalFlag;
    }

    public void setMulticastAddressFlag(boolean multicastAddressFlag) {
        this.multicastAddressFlag = multicastAddressFlag;
    }

    public void setSiteLocalAddressFlag(boolean siteLocalAddressFlag) {
        this.siteLocalAddressFlag = siteLocalAddressFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExInetAddress)) {
            return false;
        }
        ExInetAddress other = (ExInetAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getAddress(), other.getAddress())) {
            return false;
        }
        String this$canonicalHostName = this.getCanonicalHostName();
        String other$canonicalHostName = other.getCanonicalHostName();
        if (this$canonicalHostName == null ? other$canonicalHostName != null : !this$canonicalHostName.equals(other$canonicalHostName)) {
            return false;
        }
        String this$hostAddress = this.getHostAddress();
        String other$hostAddress = other.getHostAddress();
        if (this$hostAddress == null ? other$hostAddress != null : !this$hostAddress.equals(other$hostAddress)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        if (this.isAnyLocalAddressFlag() != other.isAnyLocalAddressFlag()) {
            return false;
        }
        if (this.isLinkLocalAddressFlag() != other.isLinkLocalAddressFlag()) {
            return false;
        }
        if (this.isLoopbackAddressFlag() != other.isLoopbackAddressFlag()) {
            return false;
        }
        if (this.isMulticastGlobalFlag() != other.isMulticastGlobalFlag()) {
            return false;
        }
        if (this.isMulticastLinkLocalFlag() != other.isMulticastLinkLocalFlag()) {
            return false;
        }
        if (this.isMulticastNodeLocalFlag() != other.isMulticastNodeLocalFlag()) {
            return false;
        }
        if (this.isMulticastOrgLocalFlag() != other.isMulticastOrgLocalFlag()) {
            return false;
        }
        if (this.isMulticastSiteLocalFlag() != other.isMulticastSiteLocalFlag()) {
            return false;
        }
        if (this.isMulticastAddressFlag() != other.isMulticastAddressFlag()) {
            return false;
        }
        return this.isSiteLocalAddressFlag() == other.isSiteLocalAddressFlag();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExInetAddress;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getAddress());
        String $canonicalHostName = this.getCanonicalHostName();
        result = result * 59 + ($canonicalHostName == null ? 43 : $canonicalHostName.hashCode());
        String $hostAddress = this.getHostAddress();
        result = result * 59 + ($hostAddress == null ? 43 : $hostAddress.hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        result = result * 59 + (this.isAnyLocalAddressFlag() ? 79 : 97);
        result = result * 59 + (this.isLinkLocalAddressFlag() ? 79 : 97);
        result = result * 59 + (this.isLoopbackAddressFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastGlobalFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastLinkLocalFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastNodeLocalFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastOrgLocalFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastSiteLocalFlag() ? 79 : 97);
        result = result * 59 + (this.isMulticastAddressFlag() ? 79 : 97);
        result = result * 59 + (this.isSiteLocalAddressFlag() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "ExInetAddress(address=" + Arrays.toString(this.getAddress()) + ", canonicalHostName=" + this.getCanonicalHostName() + ", hostAddress=" + this.getHostAddress() + ", hostName=" + this.getHostName() + ", anyLocalAddressFlag=" + this.isAnyLocalAddressFlag() + ", linkLocalAddressFlag=" + this.isLinkLocalAddressFlag() + ", loopbackAddressFlag=" + this.isLoopbackAddressFlag() + ", multicastGlobalFlag=" + this.isMulticastGlobalFlag() + ", multicastLinkLocalFlag=" + this.isMulticastLinkLocalFlag() + ", multicastNodeLocalFlag=" + this.isMulticastNodeLocalFlag() + ", multicastOrgLocalFlag=" + this.isMulticastOrgLocalFlag() + ", multicastSiteLocalFlag=" + this.isMulticastSiteLocalFlag() + ", multicastAddressFlag=" + this.isMulticastAddressFlag() + ", siteLocalAddressFlag=" + this.isSiteLocalAddressFlag() + ")";
    }

    public ExInetAddress() {
    }

    public ExInetAddress(byte[] address, String canonicalHostName, String hostAddress, String hostName, boolean anyLocalAddressFlag, boolean linkLocalAddressFlag, boolean loopbackAddressFlag, boolean multicastGlobalFlag, boolean multicastLinkLocalFlag, boolean multicastNodeLocalFlag, boolean multicastOrgLocalFlag, boolean multicastSiteLocalFlag, boolean multicastAddressFlag, boolean siteLocalAddressFlag) {
        this.address = address;
        this.canonicalHostName = canonicalHostName;
        this.hostAddress = hostAddress;
        this.hostName = hostName;
        this.anyLocalAddressFlag = anyLocalAddressFlag;
        this.linkLocalAddressFlag = linkLocalAddressFlag;
        this.loopbackAddressFlag = loopbackAddressFlag;
        this.multicastGlobalFlag = multicastGlobalFlag;
        this.multicastLinkLocalFlag = multicastLinkLocalFlag;
        this.multicastNodeLocalFlag = multicastNodeLocalFlag;
        this.multicastOrgLocalFlag = multicastOrgLocalFlag;
        this.multicastSiteLocalFlag = multicastSiteLocalFlag;
        this.multicastAddressFlag = multicastAddressFlag;
        this.siteLocalAddressFlag = siteLocalAddressFlag;
    }

    public static class ExInetAddressBuilder {
        private byte[] address;
        private String canonicalHostName;
        private String hostAddress;
        private String hostName;
        private boolean anyLocalAddressFlag;
        private boolean linkLocalAddressFlag;
        private boolean loopbackAddressFlag;
        private boolean multicastGlobalFlag;
        private boolean multicastLinkLocalFlag;
        private boolean multicastNodeLocalFlag;
        private boolean multicastOrgLocalFlag;
        private boolean multicastSiteLocalFlag;
        private boolean multicastAddressFlag;
        private boolean siteLocalAddressFlag;

        ExInetAddressBuilder() {
        }

        public ExInetAddressBuilder address(byte[] address) {
            this.address = address;
            return this;
        }

        public ExInetAddressBuilder canonicalHostName(String canonicalHostName) {
            this.canonicalHostName = canonicalHostName;
            return this;
        }

        public ExInetAddressBuilder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public ExInetAddressBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public ExInetAddressBuilder anyLocalAddressFlag(boolean anyLocalAddressFlag) {
            this.anyLocalAddressFlag = anyLocalAddressFlag;
            return this;
        }

        public ExInetAddressBuilder linkLocalAddressFlag(boolean linkLocalAddressFlag) {
            this.linkLocalAddressFlag = linkLocalAddressFlag;
            return this;
        }

        public ExInetAddressBuilder loopbackAddressFlag(boolean loopbackAddressFlag) {
            this.loopbackAddressFlag = loopbackAddressFlag;
            return this;
        }

        public ExInetAddressBuilder multicastGlobalFlag(boolean multicastGlobalFlag) {
            this.multicastGlobalFlag = multicastGlobalFlag;
            return this;
        }

        public ExInetAddressBuilder multicastLinkLocalFlag(boolean multicastLinkLocalFlag) {
            this.multicastLinkLocalFlag = multicastLinkLocalFlag;
            return this;
        }

        public ExInetAddressBuilder multicastNodeLocalFlag(boolean multicastNodeLocalFlag) {
            this.multicastNodeLocalFlag = multicastNodeLocalFlag;
            return this;
        }

        public ExInetAddressBuilder multicastOrgLocalFlag(boolean multicastOrgLocalFlag) {
            this.multicastOrgLocalFlag = multicastOrgLocalFlag;
            return this;
        }

        public ExInetAddressBuilder multicastSiteLocalFlag(boolean multicastSiteLocalFlag) {
            this.multicastSiteLocalFlag = multicastSiteLocalFlag;
            return this;
        }

        public ExInetAddressBuilder multicastAddressFlag(boolean multicastAddressFlag) {
            this.multicastAddressFlag = multicastAddressFlag;
            return this;
        }

        public ExInetAddressBuilder siteLocalAddressFlag(boolean siteLocalAddressFlag) {
            this.siteLocalAddressFlag = siteLocalAddressFlag;
            return this;
        }

        public ExInetAddress build() {
            return new ExInetAddress(this.address, this.canonicalHostName, this.hostAddress, this.hostName, this.anyLocalAddressFlag, this.linkLocalAddressFlag, this.loopbackAddressFlag, this.multicastGlobalFlag, this.multicastLinkLocalFlag, this.multicastNodeLocalFlag, this.multicastOrgLocalFlag, this.multicastSiteLocalFlag, this.multicastAddressFlag, this.siteLocalAddressFlag);
        }

        public String toString() {
            return "ExInetAddress.ExInetAddressBuilder(address=" + Arrays.toString(this.address) + ", canonicalHostName=" + this.canonicalHostName + ", hostAddress=" + this.hostAddress + ", hostName=" + this.hostName + ", anyLocalAddressFlag=" + this.anyLocalAddressFlag + ", linkLocalAddressFlag=" + this.linkLocalAddressFlag + ", loopbackAddressFlag=" + this.loopbackAddressFlag + ", multicastGlobalFlag=" + this.multicastGlobalFlag + ", multicastLinkLocalFlag=" + this.multicastLinkLocalFlag + ", multicastNodeLocalFlag=" + this.multicastNodeLocalFlag + ", multicastOrgLocalFlag=" + this.multicastOrgLocalFlag + ", multicastSiteLocalFlag=" + this.multicastSiteLocalFlag + ", multicastAddressFlag=" + this.multicastAddressFlag + ", siteLocalAddressFlag=" + this.siteLocalAddressFlag + ")";
        }
    }
}

