/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExCharset;
import open.source.exchange.model.ExContentDisposition;
import open.source.exchange.model.ExHttpMethod;
import open.source.exchange.model.ExInetSocketAddress;
import open.source.exchange.model.ExLocale;
import open.source.exchange.model.ExLocaleLanguageRange;
import open.source.exchange.model.ExMediaType;
import open.source.exchange.model.ExMultiValueMap;
import open.source.exchange.model.ExURI;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExHttpHeaders
extends ExMultiValueMap<String, String>
implements Serializable {
    private List<ExMediaType> accept;
    private List<ExCharset> acceptCharset;
    private List<ExLocaleLanguageRange> acceptLanguage;
    private List<ExLocale> acceptLanguageAsLocales;
    private boolean accessControlAllowCredentials;
    private List<String> accessControlAllowHeaders;
    private List<ExHttpMethod> accessControlAllowMethods;
    private String accessControlAllowOrigin;
    private List<String> accessControlExposeHeaders;
    private long accessControlMaxAge;
    private List<String> accessControlRequestHeaders;
    private ExHttpMethod accessControlRequestMethod;
    private Set<ExHttpMethod> allow;
    private String cacheControl;
    private List<String> connection;
    private ExContentDisposition contentDisposition;
    private ExLocale contentLanguage;
    private long contentLength;
    private ExMediaType contentType;
    private long date;
    private String eTag;
    private long expires;
    private ExInetSocketAddress host;
    private List<String> ifMatch;
    private long ifModifiedSince;
    private List<String> ifNoneMatch;
    private long ifUnmodifiedSince;
    private long lastModified;
    private ExURI location;
    private String origin;
    private String pragma;
    private List<ExBase> range;
    private String upgrade;
    private List<String> vary;

    public ExHttpHeaders(ExMultiValueMap<String, String> exMultiValueMap) {
        super(exMultiValueMap);
        if (null != exMultiValueMap) {
            this.setSize(exMultiValueMap.getSize());
            this.setEmpty(exMultiValueMap.isEmpty());
            this.setMapVsList(exMultiValueMap.getMapVsList());
        }
    }

    public static ExHttpHeadersBuilder builder() {
        return new ExHttpHeadersBuilder();
    }

    public List<ExMediaType> getAccept() {
        return this.accept;
    }

    public List<ExCharset> getAcceptCharset() {
        return this.acceptCharset;
    }

    public List<ExLocaleLanguageRange> getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public List<ExLocale> getAcceptLanguageAsLocales() {
        return this.acceptLanguageAsLocales;
    }

    public boolean isAccessControlAllowCredentials() {
        return this.accessControlAllowCredentials;
    }

    public List<String> getAccessControlAllowHeaders() {
        return this.accessControlAllowHeaders;
    }

    public List<ExHttpMethod> getAccessControlAllowMethods() {
        return this.accessControlAllowMethods;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public List<String> getAccessControlExposeHeaders() {
        return this.accessControlExposeHeaders;
    }

    public long getAccessControlMaxAge() {
        return this.accessControlMaxAge;
    }

    public List<String> getAccessControlRequestHeaders() {
        return this.accessControlRequestHeaders;
    }

    public ExHttpMethod getAccessControlRequestMethod() {
        return this.accessControlRequestMethod;
    }

    public Set<ExHttpMethod> getAllow() {
        return this.allow;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public List<String> getConnection() {
        return this.connection;
    }

    public ExContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public ExLocale getContentLanguage() {
        return this.contentLanguage;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public ExMediaType getContentType() {
        return this.contentType;
    }

    public long getDate() {
        return this.date;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getExpires() {
        return this.expires;
    }

    public ExInetSocketAddress getHost() {
        return this.host;
    }

    public List<String> getIfMatch() {
        return this.ifMatch;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public List<String> getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public long getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ExURI getLocation() {
        return this.location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getPragma() {
        return this.pragma;
    }

    public List<ExBase> getRange() {
        return this.range;
    }

    public String getUpgrade() {
        return this.upgrade;
    }

    public List<String> getVary() {
        return this.vary;
    }

    public void setAccept(List<ExMediaType> accept) {
        this.accept = accept;
    }

    public void setAcceptCharset(List<ExCharset> acceptCharset) {
        this.acceptCharset = acceptCharset;
    }

    public void setAcceptLanguage(List<ExLocaleLanguageRange> acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public void setAcceptLanguageAsLocales(List<ExLocale> acceptLanguageAsLocales) {
        this.acceptLanguageAsLocales = acceptLanguageAsLocales;
    }

    public void setAccessControlAllowCredentials(boolean accessControlAllowCredentials) {
        this.accessControlAllowCredentials = accessControlAllowCredentials;
    }

    public void setAccessControlAllowHeaders(List<String> accessControlAllowHeaders) {
        this.accessControlAllowHeaders = accessControlAllowHeaders;
    }

    public void setAccessControlAllowMethods(List<ExHttpMethod> accessControlAllowMethods) {
        this.accessControlAllowMethods = accessControlAllowMethods;
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    public void setAccessControlExposeHeaders(List<String> accessControlExposeHeaders) {
        this.accessControlExposeHeaders = accessControlExposeHeaders;
    }

    public void setAccessControlMaxAge(long accessControlMaxAge) {
        this.accessControlMaxAge = accessControlMaxAge;
    }

    public void setAccessControlRequestHeaders(List<String> accessControlRequestHeaders) {
        this.accessControlRequestHeaders = accessControlRequestHeaders;
    }

    public void setAccessControlRequestMethod(ExHttpMethod accessControlRequestMethod) {
        this.accessControlRequestMethod = accessControlRequestMethod;
    }

    public void setAllow(Set<ExHttpMethod> allow) {
        this.allow = allow;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public void setConnection(List<String> connection) {
        this.connection = connection;
    }

    public void setContentDisposition(ExContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public void setContentLanguage(ExLocale contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(ExMediaType contentType) {
        this.contentType = contentType;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public void setHost(ExInetSocketAddress host) {
        this.host = host;
    }

    public void setIfMatch(List<String> ifMatch) {
        this.ifMatch = ifMatch;
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
    }

    public void setIfNoneMatch(List<String> ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public void setIfUnmodifiedSince(long ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setLocation(ExURI location) {
        this.location = location;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setPragma(String pragma) {
        this.pragma = pragma;
    }

    public void setRange(List<ExBase> range) {
        this.range = range;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade = upgrade;
    }

    public void setVary(List<String> vary) {
        this.vary = vary;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExHttpHeaders)) {
            return false;
        }
        ExHttpHeaders other = (ExHttpHeaders)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ExMediaType> this$accept = this.getAccept();
        List<ExMediaType> other$accept = other.getAccept();
        if (this$accept == null ? other$accept != null : !((Object)this$accept).equals(other$accept)) {
            return false;
        }
        List<ExCharset> this$acceptCharset = this.getAcceptCharset();
        List<ExCharset> other$acceptCharset = other.getAcceptCharset();
        if (this$acceptCharset == null ? other$acceptCharset != null : !((Object)this$acceptCharset).equals(other$acceptCharset)) {
            return false;
        }
        List<ExLocaleLanguageRange> this$acceptLanguage = this.getAcceptLanguage();
        List<ExLocaleLanguageRange> other$acceptLanguage = other.getAcceptLanguage();
        if (this$acceptLanguage == null ? other$acceptLanguage != null : !((Object)this$acceptLanguage).equals(other$acceptLanguage)) {
            return false;
        }
        List<ExLocale> this$acceptLanguageAsLocales = this.getAcceptLanguageAsLocales();
        List<ExLocale> other$acceptLanguageAsLocales = other.getAcceptLanguageAsLocales();
        if (this$acceptLanguageAsLocales == null ? other$acceptLanguageAsLocales != null : !((Object)this$acceptLanguageAsLocales).equals(other$acceptLanguageAsLocales)) {
            return false;
        }
        if (this.isAccessControlAllowCredentials() != other.isAccessControlAllowCredentials()) {
            return false;
        }
        List<String> this$accessControlAllowHeaders = this.getAccessControlAllowHeaders();
        List<String> other$accessControlAllowHeaders = other.getAccessControlAllowHeaders();
        if (this$accessControlAllowHeaders == null ? other$accessControlAllowHeaders != null : !((Object)this$accessControlAllowHeaders).equals(other$accessControlAllowHeaders)) {
            return false;
        }
        List<ExHttpMethod> this$accessControlAllowMethods = this.getAccessControlAllowMethods();
        List<ExHttpMethod> other$accessControlAllowMethods = other.getAccessControlAllowMethods();
        if (this$accessControlAllowMethods == null ? other$accessControlAllowMethods != null : !((Object)this$accessControlAllowMethods).equals(other$accessControlAllowMethods)) {
            return false;
        }
        String this$accessControlAllowOrigin = this.getAccessControlAllowOrigin();
        String other$accessControlAllowOrigin = other.getAccessControlAllowOrigin();
        if (this$accessControlAllowOrigin == null ? other$accessControlAllowOrigin != null : !this$accessControlAllowOrigin.equals(other$accessControlAllowOrigin)) {
            return false;
        }
        List<String> this$accessControlExposeHeaders = this.getAccessControlExposeHeaders();
        List<String> other$accessControlExposeHeaders = other.getAccessControlExposeHeaders();
        if (this$accessControlExposeHeaders == null ? other$accessControlExposeHeaders != null : !((Object)this$accessControlExposeHeaders).equals(other$accessControlExposeHeaders)) {
            return false;
        }
        if (this.getAccessControlMaxAge() != other.getAccessControlMaxAge()) {
            return false;
        }
        List<String> this$accessControlRequestHeaders = this.getAccessControlRequestHeaders();
        List<String> other$accessControlRequestHeaders = other.getAccessControlRequestHeaders();
        if (this$accessControlRequestHeaders == null ? other$accessControlRequestHeaders != null : !((Object)this$accessControlRequestHeaders).equals(other$accessControlRequestHeaders)) {
            return false;
        }
        ExHttpMethod this$accessControlRequestMethod = this.getAccessControlRequestMethod();
        ExHttpMethod other$accessControlRequestMethod = other.getAccessControlRequestMethod();
        if (this$accessControlRequestMethod == null ? other$accessControlRequestMethod != null : !((Object)this$accessControlRequestMethod).equals(other$accessControlRequestMethod)) {
            return false;
        }
        Set<ExHttpMethod> this$allow = this.getAllow();
        Set<ExHttpMethod> other$allow = other.getAllow();
        if (this$allow == null ? other$allow != null : !((Object)this$allow).equals(other$allow)) {
            return false;
        }
        String this$cacheControl = this.getCacheControl();
        String other$cacheControl = other.getCacheControl();
        if (this$cacheControl == null ? other$cacheControl != null : !this$cacheControl.equals(other$cacheControl)) {
            return false;
        }
        List<String> this$connection = this.getConnection();
        List<String> other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        ExContentDisposition this$contentDisposition = this.getContentDisposition();
        ExContentDisposition other$contentDisposition = other.getContentDisposition();
        if (this$contentDisposition == null ? other$contentDisposition != null : !((Object)this$contentDisposition).equals(other$contentDisposition)) {
            return false;
        }
        ExLocale this$contentLanguage = this.getContentLanguage();
        ExLocale other$contentLanguage = other.getContentLanguage();
        if (this$contentLanguage == null ? other$contentLanguage != null : !((Object)this$contentLanguage).equals(other$contentLanguage)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        ExMediaType this$contentType = this.getContentType();
        ExMediaType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        if (this.getDate() != other.getDate()) {
            return false;
        }
        String this$eTag = this.getETag();
        String other$eTag = other.getETag();
        if (this$eTag == null ? other$eTag != null : !this$eTag.equals(other$eTag)) {
            return false;
        }
        if (this.getExpires() != other.getExpires()) {
            return false;
        }
        ExInetSocketAddress this$host = this.getHost();
        ExInetSocketAddress other$host = other.getHost();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        List<String> this$ifMatch = this.getIfMatch();
        List<String> other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !((Object)this$ifMatch).equals(other$ifMatch)) {
            return false;
        }
        if (this.getIfModifiedSince() != other.getIfModifiedSince()) {
            return false;
        }
        List<String> this$ifNoneMatch = this.getIfNoneMatch();
        List<String> other$ifNoneMatch = other.getIfNoneMatch();
        if (this$ifNoneMatch == null ? other$ifNoneMatch != null : !((Object)this$ifNoneMatch).equals(other$ifNoneMatch)) {
            return false;
        }
        if (this.getIfUnmodifiedSince() != other.getIfUnmodifiedSince()) {
            return false;
        }
        if (this.getLastModified() != other.getLastModified()) {
            return false;
        }
        ExURI this$location = this.getLocation();
        ExURI other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$pragma = this.getPragma();
        String other$pragma = other.getPragma();
        if (this$pragma == null ? other$pragma != null : !this$pragma.equals(other$pragma)) {
            return false;
        }
        List<ExBase> this$range = this.getRange();
        List<ExBase> other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        String this$upgrade = this.getUpgrade();
        String other$upgrade = other.getUpgrade();
        if (this$upgrade == null ? other$upgrade != null : !this$upgrade.equals(other$upgrade)) {
            return false;
        }
        List<String> this$vary = this.getVary();
        List<String> other$vary = other.getVary();
        return !(this$vary == null ? other$vary != null : !((Object)this$vary).equals(other$vary));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExHttpHeaders;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ExMediaType> $accept = this.getAccept();
        result = result * 59 + ($accept == null ? 43 : ((Object)$accept).hashCode());
        List<ExCharset> $acceptCharset = this.getAcceptCharset();
        result = result * 59 + ($acceptCharset == null ? 43 : ((Object)$acceptCharset).hashCode());
        List<ExLocaleLanguageRange> $acceptLanguage = this.getAcceptLanguage();
        result = result * 59 + ($acceptLanguage == null ? 43 : ((Object)$acceptLanguage).hashCode());
        List<ExLocale> $acceptLanguageAsLocales = this.getAcceptLanguageAsLocales();
        result = result * 59 + ($acceptLanguageAsLocales == null ? 43 : ((Object)$acceptLanguageAsLocales).hashCode());
        result = result * 59 + (this.isAccessControlAllowCredentials() ? 79 : 97);
        List<String> $accessControlAllowHeaders = this.getAccessControlAllowHeaders();
        result = result * 59 + ($accessControlAllowHeaders == null ? 43 : ((Object)$accessControlAllowHeaders).hashCode());
        List<ExHttpMethod> $accessControlAllowMethods = this.getAccessControlAllowMethods();
        result = result * 59 + ($accessControlAllowMethods == null ? 43 : ((Object)$accessControlAllowMethods).hashCode());
        String $accessControlAllowOrigin = this.getAccessControlAllowOrigin();
        result = result * 59 + ($accessControlAllowOrigin == null ? 43 : $accessControlAllowOrigin.hashCode());
        List<String> $accessControlExposeHeaders = this.getAccessControlExposeHeaders();
        result = result * 59 + ($accessControlExposeHeaders == null ? 43 : ((Object)$accessControlExposeHeaders).hashCode());
        long $accessControlMaxAge = this.getAccessControlMaxAge();
        result = result * 59 + (int)($accessControlMaxAge >>> 32 ^ $accessControlMaxAge);
        List<String> $accessControlRequestHeaders = this.getAccessControlRequestHeaders();
        result = result * 59 + ($accessControlRequestHeaders == null ? 43 : ((Object)$accessControlRequestHeaders).hashCode());
        ExHttpMethod $accessControlRequestMethod = this.getAccessControlRequestMethod();
        result = result * 59 + ($accessControlRequestMethod == null ? 43 : ((Object)$accessControlRequestMethod).hashCode());
        Set<ExHttpMethod> $allow = this.getAllow();
        result = result * 59 + ($allow == null ? 43 : ((Object)$allow).hashCode());
        String $cacheControl = this.getCacheControl();
        result = result * 59 + ($cacheControl == null ? 43 : $cacheControl.hashCode());
        List<String> $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        ExContentDisposition $contentDisposition = this.getContentDisposition();
        result = result * 59 + ($contentDisposition == null ? 43 : ((Object)$contentDisposition).hashCode());
        ExLocale $contentLanguage = this.getContentLanguage();
        result = result * 59 + ($contentLanguage == null ? 43 : ((Object)$contentLanguage).hashCode());
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        ExMediaType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        String $eTag = this.getETag();
        result = result * 59 + ($eTag == null ? 43 : $eTag.hashCode());
        long $expires = this.getExpires();
        result = result * 59 + (int)($expires >>> 32 ^ $expires);
        ExInetSocketAddress $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        List<String> $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : ((Object)$ifMatch).hashCode());
        long $ifModifiedSince = this.getIfModifiedSince();
        result = result * 59 + (int)($ifModifiedSince >>> 32 ^ $ifModifiedSince);
        List<String> $ifNoneMatch = this.getIfNoneMatch();
        result = result * 59 + ($ifNoneMatch == null ? 43 : ((Object)$ifNoneMatch).hashCode());
        long $ifUnmodifiedSince = this.getIfUnmodifiedSince();
        result = result * 59 + (int)($ifUnmodifiedSince >>> 32 ^ $ifUnmodifiedSince);
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        ExURI $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $pragma = this.getPragma();
        result = result * 59 + ($pragma == null ? 43 : $pragma.hashCode());
        List<ExBase> $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        String $upgrade = this.getUpgrade();
        result = result * 59 + ($upgrade == null ? 43 : $upgrade.hashCode());
        List<String> $vary = this.getVary();
        result = result * 59 + ($vary == null ? 43 : ((Object)$vary).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExHttpHeaders(accept=" + this.getAccept() + ", acceptCharset=" + this.getAcceptCharset() + ", acceptLanguage=" + this.getAcceptLanguage() + ", acceptLanguageAsLocales=" + this.getAcceptLanguageAsLocales() + ", accessControlAllowCredentials=" + this.isAccessControlAllowCredentials() + ", accessControlAllowHeaders=" + this.getAccessControlAllowHeaders() + ", accessControlAllowMethods=" + this.getAccessControlAllowMethods() + ", accessControlAllowOrigin=" + this.getAccessControlAllowOrigin() + ", accessControlExposeHeaders=" + this.getAccessControlExposeHeaders() + ", accessControlMaxAge=" + this.getAccessControlMaxAge() + ", accessControlRequestHeaders=" + this.getAccessControlRequestHeaders() + ", accessControlRequestMethod=" + this.getAccessControlRequestMethod() + ", allow=" + this.getAllow() + ", cacheControl=" + this.getCacheControl() + ", connection=" + this.getConnection() + ", contentDisposition=" + this.getContentDisposition() + ", contentLanguage=" + this.getContentLanguage() + ", contentLength=" + this.getContentLength() + ", contentType=" + this.getContentType() + ", date=" + this.getDate() + ", eTag=" + this.getETag() + ", expires=" + this.getExpires() + ", host=" + this.getHost() + ", ifMatch=" + this.getIfMatch() + ", ifModifiedSince=" + this.getIfModifiedSince() + ", ifNoneMatch=" + this.getIfNoneMatch() + ", ifUnmodifiedSince=" + this.getIfUnmodifiedSince() + ", lastModified=" + this.getLastModified() + ", location=" + this.getLocation() + ", origin=" + this.getOrigin() + ", pragma=" + this.getPragma() + ", range=" + this.getRange() + ", upgrade=" + this.getUpgrade() + ", vary=" + this.getVary() + ")";
    }

    public ExHttpHeaders() {
    }

    public ExHttpHeaders(List<ExMediaType> accept, List<ExCharset> acceptCharset, List<ExLocaleLanguageRange> acceptLanguage, List<ExLocale> acceptLanguageAsLocales, boolean accessControlAllowCredentials, List<String> accessControlAllowHeaders, List<ExHttpMethod> accessControlAllowMethods, String accessControlAllowOrigin, List<String> accessControlExposeHeaders, long accessControlMaxAge, List<String> accessControlRequestHeaders, ExHttpMethod accessControlRequestMethod, Set<ExHttpMethod> allow, String cacheControl, List<String> connection, ExContentDisposition contentDisposition, ExLocale contentLanguage, long contentLength, ExMediaType contentType, long date, String eTag, long expires, ExInetSocketAddress host, List<String> ifMatch, long ifModifiedSince, List<String> ifNoneMatch, long ifUnmodifiedSince, long lastModified, ExURI location, String origin, String pragma, List<ExBase> range, String upgrade, List<String> vary) {
        this.accept = accept;
        this.acceptCharset = acceptCharset;
        this.acceptLanguage = acceptLanguage;
        this.acceptLanguageAsLocales = acceptLanguageAsLocales;
        this.accessControlAllowCredentials = accessControlAllowCredentials;
        this.accessControlAllowHeaders = accessControlAllowHeaders;
        this.accessControlAllowMethods = accessControlAllowMethods;
        this.accessControlAllowOrigin = accessControlAllowOrigin;
        this.accessControlExposeHeaders = accessControlExposeHeaders;
        this.accessControlMaxAge = accessControlMaxAge;
        this.accessControlRequestHeaders = accessControlRequestHeaders;
        this.accessControlRequestMethod = accessControlRequestMethod;
        this.allow = allow;
        this.cacheControl = cacheControl;
        this.connection = connection;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.date = date;
        this.eTag = eTag;
        this.expires = expires;
        this.host = host;
        this.ifMatch = ifMatch;
        this.ifModifiedSince = ifModifiedSince;
        this.ifNoneMatch = ifNoneMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.lastModified = lastModified;
        this.location = location;
        this.origin = origin;
        this.pragma = pragma;
        this.range = range;
        this.upgrade = upgrade;
        this.vary = vary;
    }

    public static class ExHttpHeadersBuilder {
        private List<ExMediaType> accept;
        private List<ExCharset> acceptCharset;
        private List<ExLocaleLanguageRange> acceptLanguage;
        private List<ExLocale> acceptLanguageAsLocales;
        private boolean accessControlAllowCredentials;
        private List<String> accessControlAllowHeaders;
        private List<ExHttpMethod> accessControlAllowMethods;
        private String accessControlAllowOrigin;
        private List<String> accessControlExposeHeaders;
        private long accessControlMaxAge;
        private List<String> accessControlRequestHeaders;
        private ExHttpMethod accessControlRequestMethod;
        private Set<ExHttpMethod> allow;
        private String cacheControl;
        private List<String> connection;
        private ExContentDisposition contentDisposition;
        private ExLocale contentLanguage;
        private long contentLength;
        private ExMediaType contentType;
        private long date;
        private String eTag;
        private long expires;
        private ExInetSocketAddress host;
        private List<String> ifMatch;
        private long ifModifiedSince;
        private List<String> ifNoneMatch;
        private long ifUnmodifiedSince;
        private long lastModified;
        private ExURI location;
        private String origin;
        private String pragma;
        private List<ExBase> range;
        private String upgrade;
        private List<String> vary;

        ExHttpHeadersBuilder() {
        }

        public ExHttpHeadersBuilder accept(List<ExMediaType> accept) {
            this.accept = accept;
            return this;
        }

        public ExHttpHeadersBuilder acceptCharset(List<ExCharset> acceptCharset) {
            this.acceptCharset = acceptCharset;
            return this;
        }

        public ExHttpHeadersBuilder acceptLanguage(List<ExLocaleLanguageRange> acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public ExHttpHeadersBuilder acceptLanguageAsLocales(List<ExLocale> acceptLanguageAsLocales) {
            this.acceptLanguageAsLocales = acceptLanguageAsLocales;
            return this;
        }

        public ExHttpHeadersBuilder accessControlAllowCredentials(boolean accessControlAllowCredentials) {
            this.accessControlAllowCredentials = accessControlAllowCredentials;
            return this;
        }

        public ExHttpHeadersBuilder accessControlAllowHeaders(List<String> accessControlAllowHeaders) {
            this.accessControlAllowHeaders = accessControlAllowHeaders;
            return this;
        }

        public ExHttpHeadersBuilder accessControlAllowMethods(List<ExHttpMethod> accessControlAllowMethods) {
            this.accessControlAllowMethods = accessControlAllowMethods;
            return this;
        }

        public ExHttpHeadersBuilder accessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
            return this;
        }

        public ExHttpHeadersBuilder accessControlExposeHeaders(List<String> accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
            return this;
        }

        public ExHttpHeadersBuilder accessControlMaxAge(long accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
            return this;
        }

        public ExHttpHeadersBuilder accessControlRequestHeaders(List<String> accessControlRequestHeaders) {
            this.accessControlRequestHeaders = accessControlRequestHeaders;
            return this;
        }

        public ExHttpHeadersBuilder accessControlRequestMethod(ExHttpMethod accessControlRequestMethod) {
            this.accessControlRequestMethod = accessControlRequestMethod;
            return this;
        }

        public ExHttpHeadersBuilder allow(Set<ExHttpMethod> allow) {
            this.allow = allow;
            return this;
        }

        public ExHttpHeadersBuilder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public ExHttpHeadersBuilder connection(List<String> connection) {
            this.connection = connection;
            return this;
        }

        public ExHttpHeadersBuilder contentDisposition(ExContentDisposition contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public ExHttpHeadersBuilder contentLanguage(ExLocale contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public ExHttpHeadersBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public ExHttpHeadersBuilder contentType(ExMediaType contentType) {
            this.contentType = contentType;
            return this;
        }

        public ExHttpHeadersBuilder date(long date) {
            this.date = date;
            return this;
        }

        public ExHttpHeadersBuilder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public ExHttpHeadersBuilder expires(long expires) {
            this.expires = expires;
            return this;
        }

        public ExHttpHeadersBuilder host(ExInetSocketAddress host) {
            this.host = host;
            return this;
        }

        public ExHttpHeadersBuilder ifMatch(List<String> ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public ExHttpHeadersBuilder ifModifiedSince(long ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public ExHttpHeadersBuilder ifNoneMatch(List<String> ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public ExHttpHeadersBuilder ifUnmodifiedSince(long ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public ExHttpHeadersBuilder lastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public ExHttpHeadersBuilder location(ExURI location) {
            this.location = location;
            return this;
        }

        public ExHttpHeadersBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public ExHttpHeadersBuilder pragma(String pragma) {
            this.pragma = pragma;
            return this;
        }

        public ExHttpHeadersBuilder range(List<ExBase> range) {
            this.range = range;
            return this;
        }

        public ExHttpHeadersBuilder upgrade(String upgrade) {
            this.upgrade = upgrade;
            return this;
        }

        public ExHttpHeadersBuilder vary(List<String> vary) {
            this.vary = vary;
            return this;
        }

        public ExHttpHeaders build() {
            return new ExHttpHeaders(this.accept, this.acceptCharset, this.acceptLanguage, this.acceptLanguageAsLocales, this.accessControlAllowCredentials, this.accessControlAllowHeaders, this.accessControlAllowMethods, this.accessControlAllowOrigin, this.accessControlExposeHeaders, this.accessControlMaxAge, this.accessControlRequestHeaders, this.accessControlRequestMethod, this.allow, this.cacheControl, this.connection, this.contentDisposition, this.contentLanguage, this.contentLength, this.contentType, this.date, this.eTag, this.expires, this.host, this.ifMatch, this.ifModifiedSince, this.ifNoneMatch, this.ifUnmodifiedSince, this.lastModified, this.location, this.origin, this.pragma, this.range, this.upgrade, this.vary);
        }

        public String toString() {
            return "ExHttpHeaders.ExHttpHeadersBuilder(accept=" + this.accept + ", acceptCharset=" + this.acceptCharset + ", acceptLanguage=" + this.acceptLanguage + ", acceptLanguageAsLocales=" + this.acceptLanguageAsLocales + ", accessControlAllowCredentials=" + this.accessControlAllowCredentials + ", accessControlAllowHeaders=" + this.accessControlAllowHeaders + ", accessControlAllowMethods=" + this.accessControlAllowMethods + ", accessControlAllowOrigin=" + this.accessControlAllowOrigin + ", accessControlExposeHeaders=" + this.accessControlExposeHeaders + ", accessControlMaxAge=" + this.accessControlMaxAge + ", accessControlRequestHeaders=" + this.accessControlRequestHeaders + ", accessControlRequestMethod=" + this.accessControlRequestMethod + ", allow=" + this.allow + ", cacheControl=" + this.cacheControl + ", connection=" + this.connection + ", contentDisposition=" + this.contentDisposition + ", contentLanguage=" + this.contentLanguage + ", contentLength=" + this.contentLength + ", contentType=" + this.contentType + ", date=" + this.date + ", eTag=" + this.eTag + ", expires=" + this.expires + ", host=" + this.host + ", ifMatch=" + this.ifMatch + ", ifModifiedSince=" + this.ifModifiedSince + ", ifNoneMatch=" + this.ifNoneMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", lastModified=" + this.lastModified + ", location=" + this.location + ", origin=" + this.origin + ", pragma=" + this.pragma + ", range=" + this.range + ", upgrade=" + this.upgrade + ", vary=" + this.vary + ")";
        }
    }
}

