/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import open.source.exchange.model.ExBase;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExEnvironment
extends ExBase
implements Serializable {
    private String[] activeProfiles;
    private String[] defaultProfiles;

    public ExEnvironment(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExEnvironmentBuilder builder() {
        return new ExEnvironmentBuilder();
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public String[] getDefaultProfiles() {
        return this.defaultProfiles;
    }

    public void setActiveProfiles(String[] activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setDefaultProfiles(String[] defaultProfiles) {
        this.defaultProfiles = defaultProfiles;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExEnvironment)) {
            return false;
        }
        ExEnvironment other = (ExEnvironment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getActiveProfiles(), other.getActiveProfiles())) {
            return false;
        }
        return Arrays.deepEquals(this.getDefaultProfiles(), other.getDefaultProfiles());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExEnvironment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getActiveProfiles());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultProfiles());
        return result;
    }

    @Override
    public String toString() {
        return "ExEnvironment(activeProfiles=" + Arrays.deepToString(this.getActiveProfiles()) + ", defaultProfiles=" + Arrays.deepToString(this.getDefaultProfiles()) + ")";
    }

    public ExEnvironment() {
    }

    public ExEnvironment(String[] activeProfiles, String[] defaultProfiles) {
        this.activeProfiles = activeProfiles;
        this.defaultProfiles = defaultProfiles;
    }

    public static class ExEnvironmentBuilder {
        private String[] activeProfiles;
        private String[] defaultProfiles;

        ExEnvironmentBuilder() {
        }

        public ExEnvironmentBuilder activeProfiles(String[] activeProfiles) {
            this.activeProfiles = activeProfiles;
            return this;
        }

        public ExEnvironmentBuilder defaultProfiles(String[] defaultProfiles) {
            this.defaultProfiles = defaultProfiles;
            return this;
        }

        public ExEnvironment build() {
            return new ExEnvironment(this.activeProfiles, this.defaultProfiles);
        }

        public String toString() {
            return "ExEnvironment.ExEnvironmentBuilder(activeProfiles=" + Arrays.deepToString(this.activeProfiles) + ", defaultProfiles=" + Arrays.deepToString(this.defaultProfiles) + ")";
        }
    }
}

