/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.interceptor;

import java.util.Map;
import java.util.TreeMap;
import open.source.exchange.enumeration.TimeEvent;
import open.source.exchange.enumeration.TimeUnit;
import open.source.exchange.model.Time;
import open.source.exchange.service.InformationExchangeService;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Component
public class ReactiveApiInterceptor
implements WebFilter {
    private static final Logger log = LogManager.getLogger(ReactiveApiInterceptor.class);
    @Autowired
    private InformationExchangeService informationExchangeService;

    private void pendingParsers() {
    }

    private String identifier(String id, long startTime) {
        return id + "-" + startTime;
    }

    private Map<TimeEvent, Time<Long>> buildEvents(long startTimestamp, long endTimestamp, long totalTime) {
        Time<Long> begin = new Time<Long>(startTimestamp, TimeUnit.MilliSecond);
        Time<Long> end = new Time<Long>(endTimestamp, TimeUnit.MilliSecond);
        Time<Long> frame = new Time<Long>(totalTime, TimeUnit.NanoSecond);
        TreeMap<TimeEvent, Time<Long>> events = new TreeMap<TimeEvent, Time<Long>>();
        events.put(TimeEvent.Begin, begin);
        events.put(TimeEvent.End, end);
        events.put(TimeEvent.Frame, frame);
        return events;
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        String requestId = serverWebExchange.getRequest().getId();
        MDC.put((String)"requestId", (String)requestId);
        long startTimestamp = System.currentTimeMillis();
        long nanoFrameStart = System.nanoTime();
        log.info("request interceptor -> (requestId) {} (startTimestamp) {} (nanosFrameStart) {}", (Object)requestId, (Object)startTimestamp, (Object)nanoFrameStart);
        String identifier = this.identifier(requestId, startTimestamp);
        MDC.put((String)"identifier", (String)identifier);
        this.informationExchangeService.onEntry(startTimestamp, serverWebExchange, identifier);
        return webFilterChain.filter(serverWebExchange).doFinally(signalType -> {
            long endTimestamp = System.currentTimeMillis();
            long nanoFrameEnd = System.nanoTime();
            long totalTime = nanoFrameEnd - nanoFrameStart;
            log.info("response interceptor -> (requestId) {} (endTimestamp) {} (nanoFrameEnd) {} (signalType) {} (totalTime) {} nano seconds", (Object)requestId, (Object)endTimestamp, (Object)nanoFrameEnd, signalType, (Object)totalTime);
            Map<TimeEvent, Time<Long>> events = this.buildEvents(startTimestamp, endTimestamp, totalTime);
            this.informationExchangeService.onExit((SignalType)signalType, serverWebExchange, identifier, events);
        });
    }
}

