/*
 * Decompiled with CFR 0.152.
 */
package open.source.exchange.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import open.source.exchange.model.ExBase;
import open.source.exchange.model.ExEnvironment;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Document(value="applicationcontext")
public class ExApplicationContext
extends ExBase
implements Serializable {
    @Id
    private String documentId;
    private String applicationName;
    private int beanDefinitionCount;
    private String[] beanDefinitionNames;
    private String displayName;
    private ExEnvironment environment;
    private String id;
    @Indexed(background=true)
    private long startupDate;
    private ExApplicationContext parent;

    public ExApplicationContext(ExBase exBase) {
        if (null != exBase) {
            this.setClazz(exBase.getClazz());
            this.setHashCode(exBase.getHashCode());
            this.setToString(exBase.getToString());
        }
    }

    public static ExApplicationContextBuilder builder() {
        return new ExApplicationContextBuilder();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionCount;
    }

    public String[] getBeanDefinitionNames() {
        return this.beanDefinitionNames;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ExEnvironment getEnvironment() {
        return this.environment;
    }

    public String getId() {
        return this.id;
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public ExApplicationContext getParent() {
        return this.parent;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setBeanDefinitionCount(int beanDefinitionCount) {
        this.beanDefinitionCount = beanDefinitionCount;
    }

    public void setBeanDefinitionNames(String[] beanDefinitionNames) {
        this.beanDefinitionNames = beanDefinitionNames;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEnvironment(ExEnvironment environment) {
        this.environment = environment;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStartupDate(long startupDate) {
        this.startupDate = startupDate;
    }

    public void setParent(ExApplicationContext parent) {
        this.parent = parent;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExApplicationContext)) {
            return false;
        }
        ExApplicationContext other = (ExApplicationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        if (this.getBeanDefinitionCount() != other.getBeanDefinitionCount()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBeanDefinitionNames(), other.getBeanDefinitionNames())) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ExEnvironment this$environment = this.getEnvironment();
        ExEnvironment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getStartupDate() != other.getStartupDate()) {
            return false;
        }
        ExApplicationContext this$parent = this.getParent();
        ExApplicationContext other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExApplicationContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        result = result * 59 + this.getBeanDefinitionCount();
        result = result * 59 + Arrays.deepHashCode(this.getBeanDefinitionNames());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ExEnvironment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $startupDate = this.getStartupDate();
        result = result * 59 + (int)($startupDate >>> 32 ^ $startupDate);
        ExApplicationContext $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExApplicationContext(documentId=" + this.getDocumentId() + ", applicationName=" + this.getApplicationName() + ", beanDefinitionCount=" + this.getBeanDefinitionCount() + ", beanDefinitionNames=" + Arrays.deepToString(this.getBeanDefinitionNames()) + ", displayName=" + this.getDisplayName() + ", environment=" + this.getEnvironment() + ", id=" + this.getId() + ", startupDate=" + this.getStartupDate() + ", parent=" + this.getParent() + ")";
    }

    public ExApplicationContext() {
    }

    public ExApplicationContext(String documentId, String applicationName, int beanDefinitionCount, String[] beanDefinitionNames, String displayName, ExEnvironment environment, String id, long startupDate, ExApplicationContext parent) {
        this.documentId = documentId;
        this.applicationName = applicationName;
        this.beanDefinitionCount = beanDefinitionCount;
        this.beanDefinitionNames = beanDefinitionNames;
        this.displayName = displayName;
        this.environment = environment;
        this.id = id;
        this.startupDate = startupDate;
        this.parent = parent;
    }

    public static class ExApplicationContextBuilder {
        private String documentId;
        private String applicationName;
        private int beanDefinitionCount;
        private String[] beanDefinitionNames;
        private String displayName;
        private ExEnvironment environment;
        private String id;
        private long startupDate;
        private ExApplicationContext parent;

        ExApplicationContextBuilder() {
        }

        public ExApplicationContextBuilder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public ExApplicationContextBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public ExApplicationContextBuilder beanDefinitionCount(int beanDefinitionCount) {
            this.beanDefinitionCount = beanDefinitionCount;
            return this;
        }

        public ExApplicationContextBuilder beanDefinitionNames(String[] beanDefinitionNames) {
            this.beanDefinitionNames = beanDefinitionNames;
            return this;
        }

        public ExApplicationContextBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ExApplicationContextBuilder environment(ExEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public ExApplicationContextBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ExApplicationContextBuilder startupDate(long startupDate) {
            this.startupDate = startupDate;
            return this;
        }

        public ExApplicationContextBuilder parent(ExApplicationContext parent) {
            this.parent = parent;
            return this;
        }

        public ExApplicationContext build() {
            return new ExApplicationContext(this.documentId, this.applicationName, this.beanDefinitionCount, this.beanDefinitionNames, this.displayName, this.environment, this.id, this.startupDate, this.parent);
        }

        public String toString() {
            return "ExApplicationContext.ExApplicationContextBuilder(documentId=" + this.documentId + ", applicationName=" + this.applicationName + ", beanDefinitionCount=" + this.beanDefinitionCount + ", beanDefinitionNames=" + Arrays.deepToString(this.beanDefinitionNames) + ", displayName=" + this.displayName + ", environment=" + this.environment + ", id=" + this.id + ", startupDate=" + this.startupDate + ", parent=" + this.parent + ")";
        }
    }
}

