/*
 * Decompiled with CFR 0.152.
 */
package org.emergentorder.onnx;

import org.emergentorder.onnx.Float16;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class Float16$ {
    public static final Float16$ MODULE$;
    private final short NaN;
    private final short NegativeInfinity;
    private final short MinValue;
    private final short MinusOne;
    private final short MaxNegativeNormal;
    private final short MaxNegative;
    private final short NegativeZero;
    private final short Zero;
    private final short MinPositive;
    private final short MinPositiveNormal;
    private final short One;
    private final short MaxValue;
    private final short PositiveInfinity;

    static {
        new Float16$();
    }

    public short NaN() {
        return this.NaN;
    }

    public short NegativeInfinity() {
        return this.NegativeInfinity;
    }

    public short MinValue() {
        return this.MinValue;
    }

    public short MinusOne() {
        return this.MinusOne;
    }

    public short MaxNegativeNormal() {
        return this.MaxNegativeNormal;
    }

    public short MaxNegative() {
        return this.MaxNegative;
    }

    public short NegativeZero() {
        return this.NegativeZero;
    }

    public short Zero() {
        return this.Zero;
    }

    public short MinPositive() {
        return this.MinPositive;
    }

    public short MinPositiveNormal() {
        return this.MinPositiveNormal;
    }

    public short One() {
        return this.One;
    }

    public short MaxValue() {
        return this.MaxValue;
    }

    public short PositiveInfinity() {
        return this.PositiveInfinity;
    }

    public short fromFloat(float n) {
        short s;
        if (Float.isNaN(n)) {
            s = this.NaN();
        } else if (n == Float.POSITIVE_INFINITY) {
            s = this.PositiveInfinity();
        } else if (n == Float.NEGATIVE_INFINITY) {
            s = this.NegativeInfinity();
        } else if (Float.compare(n, -0.0f) == 0) {
            s = this.NegativeZero();
        } else if (n == 0.0f) {
            s = this.Zero();
        } else if (n < 0.0f) {
            s = this.unary_$minus$extension(this.fromFloat(-n));
        } else if (1.0f <= n && n < 2.0f) {
            s = this.createFinite$1(0, n);
        } else {
            float x;
            int e;
            if (n < 1.0f) {
                for (x = n; x < 1.0f && e > -14; x *= 2.0f, --e) {
                }
            } else {
                for (e = 0; x >= 2.0f && e < 15; x *= 0.5f, ++e) {
                }
            }
            s = this.createFinite$1(e, x);
        }
        return s;
    }

    public final boolean isNaN$extension(short $this) {
        return ($this & Short.MAX_VALUE) > 31744;
    }

    public final boolean nonNaN$extension(short $this) {
        return ($this & Short.MAX_VALUE) <= 31744;
    }

    public final boolean isZero$extension(short $this) {
        return ($this & Short.MAX_VALUE) == 0;
    }

    public final boolean nonZero$extension(short $this) {
        return ($this & Short.MAX_VALUE) != 0;
    }

    public final boolean isPositiveZero$extension(short $this) {
        return $this == Short.MIN_VALUE;
    }

    public final boolean isNegativeZero$extension(short $this) {
        return $this == 0;
    }

    public final boolean isInfinite$extension(short $this) {
        return ($this & Short.MAX_VALUE) == 31744;
    }

    public final boolean isPositiveInfinity$extension(short $this) {
        return $this == 31744;
    }

    public final boolean isNegativeInfinity$extension(short $this) {
        return $this == 64512;
    }

    public final boolean isFinite$extension(short $this) {
        return ($this & 0x7C00) != 31744;
    }

    public final float signum$extension(short $this) {
        return $this == Short.MIN_VALUE ? 0.0f : ($this == 0 ? -0.0f : (($this & Short.MAX_VALUE) > 31744 ? Float.NaN : (float)($this >>> 14 & 2) - 1.0f));
    }

    public final short unary_$minus$extension(short $this) {
        return (short)($this ^ 0x8000);
    }

    public final short $plus$extension(short $this, short rhs) {
        return this.fromFloat(this.toFloat$extension($this) + this.toFloat$extension(rhs));
    }

    public final short $minus$extension(short $this, short rhs) {
        return this.fromFloat(this.toFloat$extension($this) - this.toFloat$extension(rhs));
    }

    public final short $times$extension(short $this, short rhs) {
        return this.fromFloat(this.toFloat$extension($this) * this.toFloat$extension(rhs));
    }

    public final short $div$extension(short $this, short rhs) {
        return this.fromFloat(this.toFloat$extension($this) / this.toFloat$extension(rhs));
    }

    public final short $times$times$extension(short $this, int rhs) {
        return this.fromFloat((float)package$.MODULE$.pow((double)this.toFloat$extension($this), (double)rhs));
    }

    public final boolean $less$extension(short $this, short rhs) {
        if ($this == rhs || this.isNaN$extension($this) || this.isNaN$extension(rhs)) {
            return false;
        }
        if (this.isZero$extension($this) && this.isZero$extension(rhs)) {
            return false;
        }
        int ls = $this >>> 15 & 1;
        int rs = rhs >>> 15 & 1;
        if (ls < rs) {
            return true;
        }
        if (ls > rs) {
            return false;
        }
        int le = $this >>> 10 & 0x1F;
        int re = rhs >>> 10 & 0x1F;
        if (le < re) {
            return ls == 1;
        }
        if (le > re) {
            return ls == 0;
        }
        int lm = $this & 0x3FF;
        int rm = rhs & 0x3FF;
        return ls == 1 ? lm < rm : rm < lm;
    }

    public final boolean $less$eq$extension(short $this, short rhs) {
        if (this.isNaN$extension($this) || this.isNaN$extension(rhs)) {
            return false;
        }
        if (this.isZero$extension($this) && this.isZero$extension(rhs)) {
            return true;
        }
        int ls = $this >>> 15 & 1;
        int rs = rhs >>> 15 & 1;
        if (ls < rs) {
            return true;
        }
        if (ls > rs) {
            return false;
        }
        int le = $this >>> 10 & 0x1F;
        int re = rhs >>> 10 & 0x1F;
        if (le < re) {
            return ls == 1;
        }
        if (le > re) {
            return ls == 0;
        }
        int lm = $this & 0x3FF;
        int rm = rhs & 0x3FF;
        return ls == 1 ? lm <= rm : rm <= lm;
    }

    public final boolean $greater$extension(short $this, short rhs) {
        return !this.isNaN$extension($this) && !this.isNaN$extension(rhs) && !this.$less$eq$extension($this, rhs);
    }

    public final boolean $greater$eq$extension(short $this, short rhs) {
        return !this.isNaN$extension($this) && !this.isNaN$extension(rhs) && !this.$less$extension($this, rhs);
    }

    public final boolean $eq$eq$extension(short $this, short rhs) {
        return this.isNaN$extension($this) || this.isNaN$extension(rhs) ? false : (this.isZero$extension($this) && this.isZero$extension(rhs) ? true : $this == rhs);
    }

    public final float toFloat$extension(short $this) {
        int s = $this >>> 14 & 2;
        int e = $this >>> 10 & 0x1F;
        int m = $this & 0x3FF;
        return e == 0 ? (m != 0 ? ((float)s - 1.0f) * (float)package$.MODULE$.pow(2.0, -14.0) * ((float)m / 1024.0f) : (s == 0 ? -0.0f : 0.0f)) : (e != 31 ? ((float)s - 1.0f) * (float)package$.MODULE$.pow(2.0, (double)(e - 15)) * (1.0f + (float)m / 1024.0f) : (($this & 0x3FF) != 0 ? Float.NaN : ($this < 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY)));
    }

    public final String toString$extension(short $this) {
        return ((Object)BoxesRunTime.boxToFloat((float)this.toFloat$extension($this))).toString();
    }

    public final int hashCode$extension(short $this) {
        return ((Object)BoxesRunTime.boxToShort((short)$this)).hashCode();
    }

    public final boolean equals$extension(short $this, Object x$1) {
        short s;
        Object object = x$1;
        boolean bl = object instanceof Float16;
        return bl && $this == (s = ((Float16)x$1).raw());
    }

    private final short createNormal$1(int e, int m) {
        return (short)(e + 15 << 10 | m | 0x8000);
    }

    private final short createFinite$1(int e, float x) {
        int m = package$.MODULE$.round((x - 1.0f) * (float)1024);
        return e == -14 && m == 0 ? this.MinPositiveNormal() : (e == -14 ? (m == 0 ? this.Zero() : (x >= 1.0f ? this.createNormal$1(e, m) : (short)(0x8000 | package$.MODULE$.round(x * (float)1024)))) : (e == 15 ? (m < 1024 ? this.createNormal$1(e, m) : this.PositiveInfinity()) : this.createNormal$1(e, m)));
    }

    private Float16$() {
        MODULE$ = this;
        this.NaN = (short)31745;
        this.NegativeInfinity = (short)31744;
        this.MinValue = (short)31743;
        this.MinusOne = (short)15360;
        this.MaxNegativeNormal = (short)1024;
        this.MaxNegative = (short)1;
        this.NegativeZero = (short)0;
        this.Zero = (short)32768;
        this.MinPositive = (short)32769;
        this.MinPositiveNormal = (short)33792;
        this.One = (short)48128;
        this.MaxValue = (short)64511;
        this.PositiveInfinity = (short)64512;
    }
}

