package com.github.tonywills.droidbase.utils;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;

public class Utils {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public static Drawable getDefaultRippleForDrawable(Drawable content) {
        return new RippleDrawable(getPressedColorSelector(Color.WHITE), content, null);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public static Drawable getPressedColorRippleDrawable(int normalColor, int pressedColor) {
        return new RippleDrawable(getPressedColorSelector(pressedColor), getColorDrawableFromColor(normalColor), null);
    }

    public static ColorStateList getPressedColorSelector(int pressedColor) {
        return new ColorStateList(
                new int[][]{
                        new int[]{}
                }, new int[]{
                pressedColor
        }
        );
    }

    public static ColorDrawable getColorDrawableFromColor(int color) {
        return new ColorDrawable(color);

    }

    public static int blendColors(int from, int to, float ratio) {
        final float inverseRatio = 1f - ratio;

        final float r = Color.red(to) * ratio + Color.red(from) * inverseRatio;
        final float g = Color.green(to) * ratio + Color.green(from) * inverseRatio;
        final float b = Color.blue(to) * ratio + Color.blue(from) * inverseRatio;

        return Color.rgb((int) r, (int) g, (int) b);
    }

    public static void animateColour(final int fromColour, final int toColour, int duration,
                                     final ColourAnimationListener listener) {
        ValueAnimator anim = ValueAnimator.ofFloat(0, 1);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                float position = animation.getAnimatedFraction();
                int blended = blendColors(fromColour, toColour, position);
                listener.colourAnimationProgressedTo(blended);
            }
        });
        anim.setDuration(duration).start();
    }

    public interface ColourAnimationListener {
        void colourAnimationProgressedTo(int blended);
    }
}
