/*
 * Decompiled with CFR 0.152.
 */
package org.say.xhttp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.say.xhttp.HttpResponse;
import org.say.xhttp.RandomString;
import org.say.xhttp.Request;
import org.say.xhttp.Response;

public class HttpRequest
implements Request {
    private String urlStr;
    private Proxy proxy;
    private SSLSocketFactory sslsf;
    private HostnameVerifier hv;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Boolean followRedirects;
    private String character;
    private String responseCharacter;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String method = "GET";
    private String boundary;
    private static final String LOGO = "xhttp";
    private List<Object> data = new ArrayList<Object>();

    public HttpRequest() {
        this.userAgent(LOGO);
    }

    @Override
    public Request url(String url) {
        this.urlStr = url;
        return this;
    }

    @Override
    public Request proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public Request sslSocketFactory(SSLSocketFactory sslsf) {
        this.sslsf = sslsf;
        return this;
    }

    @Override
    public Request hostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
        return this;
    }

    @Override
    public Request connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public Request readTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    @Override
    public Request followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public Request character(String character) {
        this.character = character;
        return this;
    }

    @Override
    public Map<String, String> header() {
        return this.requestHeaders;
    }

    @Override
    public Request header(String name, String value) {
        this.requestHeaders.put(name, value);
        return this;
    }

    @Override
    public Request userAgent(String userAgent) {
        this.requestHeaders.put("User-Agent", userAgent);
        return this;
    }

    @Override
    public Request contentType(String contentType) {
        this.requestHeaders.put("Content-Type", contentType);
        return this;
    }

    @Override
    public Request cookie(String cookie) {
        this.requestHeaders.put("cookie", cookie);
        return this;
    }

    @Override
    public Request data(byte[] data) {
        this.data.add(data);
        return this;
    }

    @Override
    public Request data(String data) {
        this.data.add(data);
        return this;
    }

    @Override
    public Request data(String name, String value) {
        HashMap<String, String> m = new HashMap<String, String>(1);
        m.put(name, value);
        this.data.add(m);
        return this;
    }

    @Override
    public Request data(String name, File data) {
        HashMap<String, File> m = new HashMap<String, File>(1);
        m.put(name, data);
        this.data.add(m);
        if (this.requestHeaders.get("Content-Type") == null) {
            this.boundary = new RandomString().next(16);
            this.contentType("multipart/form-data; boundary=----xhttp_" + this.boundary);
        }
        return this;
    }

    @Override
    public Request method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public Response get() {
        this.method = "GET";
        return this.execute();
    }

    @Override
    public Response post() {
        this.method = "POST";
        return this.execute();
    }

    @Override
    public Response execute() {
        try {
            URLConnection urlConn;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.data != null && this.data.size() > 0) {
                for (Object obj : this.data) {
                    if (obj instanceof Map) {
                        Map m = (Map)obj;
                        for (String k : m.keySet()) {
                            String cd;
                            Object o = m.get(k);
                            if (o instanceof File) {
                                File f = (File)o;
                                if (this.boundary == null) continue;
                                baos.write(this.boundary.getBytes());
                                baos.write("\r\n".getBytes());
                                cd = "Content-Disposition: form-data; name=\"" + k + "\"; filename=\"" + f.getName() + "\"";
                                baos.write(this.character != null ? cd.getBytes(this.character) : cd.getBytes());
                                baos.write("\r\n".getBytes());
                                baos.write(("Content-Type: " + new MimetypesFileTypeMap().getContentType(f)).getBytes());
                                baos.write("\r\n\r\n".getBytes());
                                byte[] b = new byte[4096];
                                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(f));
                                Throwable throwable = null;
                                try {
                                    int n;
                                    while ((n = bin.read(b)) != -1) {
                                        baos.write(b, 0, n);
                                    }
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (bin == null) continue;
                                    if (throwable != null) {
                                        try {
                                            bin.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    bin.close();
                                    continue;
                                }
                            }
                            if (!(o instanceof String)) continue;
                            String v = (String)o;
                            if ("POST".equals(this.method.toUpperCase())) {
                                if (this.boundary != null) {
                                    baos.write(this.boundary.getBytes());
                                    baos.write("\r\n".getBytes());
                                    cd = "Content-Disposition: form-data; name=\"" + k + "\"";
                                    baos.write(this.character != null ? cd.getBytes(this.character) : cd.getBytes());
                                    baos.write("\r\n\r\n".getBytes());
                                    baos.write(v.getBytes());
                                    continue;
                                }
                                if (baos.size() > 0) {
                                    baos.write(38);
                                }
                                String kv = k + "=" + v;
                                baos.write(this.character != null ? kv.getBytes(this.character) : kv.getBytes());
                                continue;
                            }
                            if (!"GET".equals(this.method.toUpperCase())) continue;
                            this.urlStr = this.urlStr + (!this.urlStr.contains("?") ? (char)'?' : '&');
                            this.urlStr = this.urlStr + (this.character != null ? URLEncoder.encode(k, this.character) : k) + "=" + (this.character != null ? URLEncoder.encode(v, this.character) : v);
                        }
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        byte[] bs = (byte[])obj;
                        if ("POST".equals(this.method.toUpperCase())) {
                            baos.write(bs);
                            continue;
                        }
                        if (!"GET".equals(this.method.toUpperCase())) continue;
                        String v = this.character != null ? new String(bs, this.character) : new String(bs);
                        this.urlStr = this.urlStr + (this.urlStr.contains("?") ? (char)'&' : '?') + (String)(this.character != null ? URLEncoder.encode(v, this.character) : v);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    String v = (String)obj;
                    if ("POST".equals(this.method.toUpperCase())) {
                        baos.write(this.character != null ? v.getBytes(this.character) : v.getBytes());
                        continue;
                    }
                    if (!"GET".equals(this.method.toUpperCase())) continue;
                    this.urlStr = this.urlStr + (this.urlStr.contains("?") ? (char)'&' : '?') + (this.character != null ? URLEncoder.encode(v, this.character) : v);
                }
            }
            if (this.boundary != null) {
                baos.write((this.boundary + "--").getBytes());
            }
            URL url = new URL(this.urlStr);
            URLConnection uRLConnection = urlConn = this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
            if (urlConn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)urlConn;
                if (this.sslsf != null) {
                    httpsConn.setSSLSocketFactory(this.sslsf);
                }
                if (this.hv != null) {
                    httpsConn.setHostnameVerifier(this.hv);
                }
            }
            HttpURLConnection httpUrl = (HttpURLConnection)urlConn;
            if (this.connectTimeout != null) {
                httpUrl.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                httpUrl.setReadTimeout(this.readTimeout);
            }
            if (this.followRedirects != null) {
                httpUrl.setInstanceFollowRedirects(this.followRedirects);
            }
            httpUrl.setRequestMethod(this.method);
            for (String k : this.requestHeaders.keySet()) {
                httpUrl.setRequestProperty(k, this.requestHeaders.get(k));
            }
            if ("POST".equals(this.method.toUpperCase()) && baos.size() > 0) {
                httpUrl.setDoOutput(true);
                try (OutputStream out = httpUrl.getOutputStream();){
                    out.write(baos.toByteArray());
                    out.flush();
                }
            }
            return new HttpResponse(httpUrl).character(this.responseCharacter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Request responseCharacter(String character) {
        this.responseCharacter = character;
        return this;
    }
}

