/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort.std;

import com.fasterxml.sort.DataWriter;
import com.fasterxml.sort.DataWriterFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RawTextLineWriter
extends DataWriter<byte[]> {
    protected static final byte[] STD_LINEFEED_CR = new byte[]{13};
    protected static final byte[] STD_LINEFEED_LF = new byte[]{10};
    protected static final byte[] STD_LINEFEED_CRLF = new byte[]{13, 10};
    protected static final byte[] DEFAULT_LINEFEED = STD_LINEFEED_LF;
    protected final OutputStream _out;
    protected final byte[] _lf;
    protected boolean _closed = false;

    public RawTextLineWriter(OutputStream out) {
        this(out, DEFAULT_LINEFEED);
    }

    public RawTextLineWriter(OutputStream out, byte[] linefeed) {
        this._out = out;
        this._lf = linefeed;
    }

    public static Factory factory() {
        return new Factory();
    }

    public static Factory factory(byte[] linefeed) {
        return new Factory(linefeed);
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._out.close();
        }
    }

    @Override
    public void writeEntry(byte[] item) throws IOException {
        if (this._closed) {
            throw new IOException("Can not write using closed DataWriter");
        }
        this._out.write(item);
        if (this._lf != null) {
            this._out.write(this._lf);
        }
    }

    public static class Factory
    extends DataWriterFactory<byte[]> {
        protected final byte[] _linefeed;
        protected final boolean _addBuffering;

        public Factory() {
            this(DEFAULT_LINEFEED);
        }

        public Factory(byte[] linefeed) {
            this(linefeed, true);
        }

        public Factory(byte[] linefeed, boolean addBuffering) {
            this._linefeed = linefeed;
            this._addBuffering = addBuffering;
        }

        @Override
        public DataWriter<byte[]> constructWriter(OutputStream out) {
            if (this._addBuffering && !(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            return new RawTextLineWriter(out, this._linefeed);
        }
    }
}

