/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.DataReaderFactory;
import com.fasterxml.sort.DataWriter;
import com.fasterxml.sort.DataWriterFactory;
import com.fasterxml.sort.Merger;
import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.SortingState;
import com.fasterxml.sort.util.SegmentedBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Sorter<T>
implements SortingState {
    private static final long ENTRY_SLOT_SIZE = 8L;
    protected final SortConfig _config;
    protected final DataReaderFactory<T> _readerFactory;
    protected final DataWriterFactory<T> _writerFactory;
    protected final Comparator<T> _comparator;
    protected SortingState.Phase _phase;
    protected int _presortFileCount;
    protected int _sortRoundCount;
    protected int _currentSortRound;
    protected final AtomicBoolean _cancelRequest = new AtomicBoolean(false);
    protected Exception _cancelForException;

    public Sorter(SortConfig config, DataReaderFactory<T> readerFactory, DataWriterFactory<T> writerFactory, Comparator<T> comparator) {
        this._config = config;
        this._readerFactory = readerFactory;
        this._writerFactory = writerFactory;
        this._comparator = comparator;
        this._phase = null;
    }

    @Override
    public void cancel() {
        this._cancelForException = null;
        this._cancelRequest.set(true);
    }

    @Override
    public void cancel(RuntimeException e) {
        this._cancelForException = e;
        this._cancelRequest.set(true);
    }

    @Override
    public void cancel(IOException e) {
        this._cancelForException = e;
        this._cancelRequest.set(true);
    }

    @Override
    public SortingState.Phase getPhase() {
        return this._phase;
    }

    @Override
    public int getNumberOfSortRounds() {
        return this._sortRoundCount;
    }

    @Override
    public int getNumberOfPreSortFiles() {
        return this._presortFileCount;
    }

    @Override
    public int getSortRound() {
        return this._currentSortRound;
    }

    @Override
    public boolean isCompleted() {
        return this._phase == SortingState.Phase.COMPLETE;
    }

    @Override
    public boolean isPreSorting() {
        return this._phase == SortingState.Phase.PRE_SORTING;
    }

    @Override
    public boolean isSorting() {
        return this._phase == SortingState.Phase.SORTING;
    }

    public void sort(InputStream source, OutputStream destination) throws IOException {
        this.sort(this._readerFactory.constructReader(source), this._writerFactory.constructWriter(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sort(DataReader<T> inputReader, DataWriter<T> resultWriter) throws IOException {
        this._phase = SortingState.Phase.PRE_SORTING;
        SegmentedBuffer buffer = new SegmentedBuffer();
        boolean inputClosed = false;
        boolean resultClosed = false;
        this._presortFileCount = 0;
        this._sortRoundCount = -1;
        this._currentSortRound = -1;
        try {
            Object[] items = this._readMax(inputReader, buffer, this._config.getMaxMemoryUsage(), null);
            if (this._checkForCancel()) {
                boolean bl = false;
                return bl;
            }
            Arrays.sort(items, this._rawComparator());
            T next = inputReader.readNext();
            if (next == null) {
                inputClosed = true;
                inputReader.close();
                this._phase = SortingState.Phase.SORTING;
                this._writeAll(resultWriter, items);
            } else {
                List<File> presorted = this.presort(inputReader, buffer, items, next);
                inputClosed = true;
                inputReader.close();
                this._phase = SortingState.Phase.SORTING;
                if (this._checkForCancel(presorted)) {
                    boolean bl = false;
                    return bl;
                }
                this.merge(presorted, resultWriter);
            }
            resultClosed = true;
            resultWriter.close();
            if (this._checkForCancel()) {
                boolean bl = false;
                return bl;
            }
            this._phase = SortingState.Phase.COMPLETE;
            return false;
        }
        finally {
            if (!inputClosed) {
                try {
                    inputReader.close();
                }
                catch (IOException e) {}
            }
            if (!resultClosed) {
                try {
                    resultWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Object[] _readMax(DataReader<T> inputReader, SegmentedBuffer buffer, long memoryToUse, T firstItem) throws IOException {
        T value;
        long minMemoryNeeded;
        int ptr = 0;
        Object[] segment = buffer.resetAndStart();
        int segmentLength = segment.length;
        if (firstItem != null) {
            segment[ptr++] = firstItem;
            long firstSize = 8L + (long)inputReader.estimateSizeInBytes(firstItem);
            minMemoryNeeded = Math.max(firstSize, 256L);
        } else {
            minMemoryNeeded = 256L;
        }
        memoryToUse -= 8L * (long)segmentLength;
        while ((value = inputReader.readNext()) != null) {
            long size = inputReader.estimateSizeInBytes(value);
            if (size > minMemoryNeeded) {
                minMemoryNeeded = size;
            }
            if (ptr >= segmentLength) {
                segment = buffer.appendCompletedChunk(segment);
                segmentLength = segment.length;
                memoryToUse -= 8L * (long)segmentLength;
                ptr = 0;
            }
            segment[ptr++] = value;
            if ((memoryToUse -= size) >= minMemoryNeeded) continue;
            break;
        }
        return buffer.completeAndClearBuffer(segment, ptr);
    }

    protected List<File> presort(DataReader<T> inputReader, SegmentedBuffer buffer, Object[] firstSortedBatch, T nextValue) throws IOException {
        ArrayList<File> presorted = new ArrayList<File>();
        presorted.add(this._writePresorted(firstSortedBatch));
        do {
            Object[] items = this._readMax(inputReader, buffer, this._config.getMaxMemoryUsage(), nextValue);
            Arrays.sort(items, this._rawComparator());
            presorted.add(this._writePresorted(items));
        } while ((nextValue = inputReader.readNext()) != null);
        return presorted;
    }

    protected File _writePresorted(Object[] items) throws IOException {
        File tmp = this._config.getTempFileProvider().provide();
        DataWriter<Object> writer = this._writerFactory.constructWriter(new FileOutputStream(tmp));
        ++this._presortFileCount;
        for (Object item : items) {
            writer.writeEntry(item);
        }
        writer.close();
        return tmp;
    }

    protected void merge(List<File> presorted, DataWriter<T> resultWriter) throws IOException {
        int mergeFactor = this._config.getMergeFactor();
        this._sortRoundCount = Sorter._calculateRoundCount(presorted.size(), mergeFactor);
        this._currentSortRound = 0;
        List<File> inputs = presorted;
        while (inputs.size() > mergeFactor) {
            ArrayList<File> outputs = new ArrayList<File>(1 + (inputs.size() + mergeFactor - 1) / mergeFactor);
            int end = inputs.size();
            for (int offset = 0; offset < end; offset += mergeFactor) {
                int localEnd = Math.min(offset + mergeFactor, end);
                outputs.add(this._merge(inputs.subList(offset, localEnd)));
            }
            ++this._currentSortRound;
            inputs = outputs;
        }
        this._merge(inputs, resultWriter);
    }

    protected void _writeAll(DataWriter<T> resultWriter, Object[] items) throws IOException {
        DataWriter<Object> writer = resultWriter;
        for (Object item : items) {
            writer.writeEntry(item);
        }
    }

    protected File _merge(List<File> inputs) throws IOException {
        File resultFile = this._config.getTempFileProvider().provide();
        this._merge(inputs, this._writerFactory.constructWriter(new FileOutputStream(resultFile)));
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _merge(List<File> inputs, DataWriter<T> writer) throws IOException {
        ArrayList readers = new ArrayList(inputs.size());
        try {
            T value;
            for (File mergedInput : inputs) {
                readers.add(this._readerFactory.constructReader(new FileInputStream(mergedInput)));
            }
            DataReader<T> merger = Merger.mergedReader(this._comparator, readers);
            while ((value = merger.readNext()) != null) {
                writer.writeEntry(value);
            }
            writer.close();
        }
        finally {
            for (File input : inputs) {
                input.delete();
            }
        }
    }

    protected static int _calculateRoundCount(int files, int mergeFactor) {
        int count = 1;
        while (files > mergeFactor) {
            ++count;
            files = (files + mergeFactor - 1) / mergeFactor;
        }
        return count;
    }

    protected boolean _checkForCancel() throws IOException {
        return this._checkForCancel(null);
    }

    protected boolean _checkForCancel(Collection<File> tmpFilesToDelete) throws IOException {
        if (!this._cancelRequest.get()) {
            return false;
        }
        if (tmpFilesToDelete != null) {
            for (File f : tmpFilesToDelete) {
                f.delete();
            }
        }
        if (this._cancelForException != null) {
            if (this._cancelForException instanceof RuntimeException) {
                throw (RuntimeException)this._cancelForException;
            }
            throw (IOException)this._cancelForException;
        }
        return true;
    }

    protected Comparator<Object> _rawComparator() {
        return this._comparator;
    }
}

