/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort;

import com.fasterxml.sort.DataReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Merger<T>
extends DataReader<T> {
    protected final Comparator<T> _comparator;

    public Merger(Comparator<T> cmp) {
        this._comparator = cmp;
    }

    public static <T> DataReader<T> mergedReader(Comparator<T> cmp, List<DataReader<T>> inputs) throws IOException {
        int i;
        switch (inputs.size()) {
            case 0: {
                throw new IllegalArgumentException("Can not pass empty DataReader array");
            }
            case 1: {
                return inputs.get(0);
            }
            case 2: {
                return new PairwiseMerger<T>(cmp, inputs.get(0), inputs.get(1));
            }
        }
        ArrayList<DataReader<T>> readers = new ArrayList<DataReader<T>>(1 + (inputs.size() >> 1));
        int end = inputs.size() - 1;
        for (i = 0; i < end; i += 2) {
            readers.add(new PairwiseMerger<T>(cmp, inputs.get(i), inputs.get(i + 1)));
        }
        if (i < inputs.size()) {
            readers.add(inputs.get(i));
        }
        return Merger.mergedReader(cmp, readers);
    }

    protected static class PairwiseMerger<T>
    extends Merger<T> {
        protected final DataReader<T> _reader1;
        protected final DataReader<T> _reader2;
        protected T _data1;
        protected T _data2;

        public PairwiseMerger(Comparator<T> comparator, DataReader<T> reader1, DataReader<T> reader2) throws IOException {
            super(comparator);
            this._reader1 = reader1;
            this._data1 = reader1.readNext();
            this._reader2 = reader2;
            this._data2 = reader2.readNext();
        }

        @Override
        public T readNext() throws IOException {
            T result;
            if (this._data1 == null) {
                if (this._data2 == null) {
                    return null;
                }
                T result2 = this._data2;
                this._data2 = this._reader2.readNext();
                return result2;
            }
            if (this._data2 == null) {
                T result3 = this._data1;
                this._data1 = this._reader1.readNext();
                return result3;
            }
            if (this._comparator.compare(this._data1, this._data2) <= 0) {
                result = this._data1;
                this._data1 = this._reader1.readNext();
            } else {
                result = this._data2;
                this._data2 = this._reader2.readNext();
            }
            return result;
        }

        @Override
        public int estimateSizeInBytes(T item) {
            return this._reader1.estimateSizeInBytes(item);
        }

        @Override
        public void close() throws IOException {
            this._reader1.close();
            this._reader2.close();
        }
    }
}

