/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvReader;
import com.fasterxml.jackson.dataformat.csv.impl.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CsvParser
extends ParserMinimalBase {
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected static final int STATE_DOC_START = 0;
    protected static final int STATE_RECORD_START = 1;
    protected static final int STATE_NEXT_ENTRY = 2;
    protected static final int STATE_NAMED_VALUE = 3;
    protected static final int STATE_UNNAMED_VALUE = 4;
    protected static final int STATE_DOC_END = 5;
    protected ObjectCodec _objectCodec;
    protected int _csvFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected int _columnCount = 0;
    protected JsonReadContext _parsingContext;
    protected String _currentName;
    protected String _currentValue;
    protected int _columnIndex;
    protected int _state = 0;
    protected byte[] _binaryValue;
    protected final CsvReader _reader;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;

    public CsvParser(IOContext ctxt, BufferRecycler br, int parserFeatures, int csvFeatures, ObjectCodec codec, Reader reader) {
        super(parserFeatures);
        this._objectCodec = codec;
        this._textBuffer = new TextBuffer(br);
        DupDetector dups = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(parserFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._csvFeatures = csvFeatures;
        this._parsingContext = JsonReadContext.createRootContext((DupDetector)dups);
        this._reader = new CsvReader(this, ctxt, reader, this._schema, this._textBuffer, this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE), this.isEnabled(Feature.TRIM_SPACES));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            this._schema = (CsvSchema)schema;
        } else if (schema == null) {
            schema = EMPTY_SCHEMA;
        } else {
            super.setSchema(schema);
        }
        this._columnCount = this._schema.size();
        this._reader.setSchema(this._schema);
    }

    public int releaseBuffered(Writer out) throws IOException {
        return this._reader.releaseBuffered(out);
    }

    public boolean isClosed() {
        return this._reader.isClosed();
    }

    public void close() throws IOException {
        this._reader.close();
    }

    public JsonParser enable(Feature f) {
        this._csvFeatures |= f.getMask();
        return this;
    }

    public JsonParser disable(Feature f) {
        this._csvFeatures &= ~f.getMask();
        return this;
    }

    public JsonParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(Feature f) {
        return (this._csvFeatures & f.getMask()) != 0;
    }

    public CsvSchema getSchema() {
        return this._schema;
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this._reader.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._reader.getCurrentLocation();
    }

    public Object getInputSource() {
        return this._reader.getInputSource();
    }

    public String getCurrentName() throws IOException, JsonParseException {
        return this._currentName;
    }

    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                this._currToken = this._handleStartDoc();
                return this._currToken;
            }
            case 1: {
                this._currToken = this._handleRecordStart();
                return this._currToken;
            }
            case 2: {
                this._currToken = this._handleNextEntry();
                return this._currToken;
            }
            case 3: {
                this._currToken = this._handleNamedValue();
                return this._currToken;
            }
            case 4: {
                this._currToken = this._handleUnnamedValue();
                return this._currToken;
            }
            case 5: {
                this._reader.close();
                if (this._parsingContext.inRoot()) {
                    return null;
                }
                boolean inArray = this._parsingContext.inArray();
                this._parsingContext = this._parsingContext.getParent();
                return inArray ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
            }
        }
        throw new IllegalStateException();
    }

    protected JsonToken _handleStartDoc() throws IOException, JsonParseException {
        if (this._schema.useHeader()) {
            this._readHeaderLine();
        }
        if (this._schema.skipFirstDataRow()) {
            this._reader.skipLine();
        }
        if (!this._reader.hasMoreInput()) {
            this._state = 5;
            if (this.isEnabled(Feature.WRAP_AS_ARRAY)) {
                this._parsingContext = this._reader.childArrayContext(this._parsingContext);
                return JsonToken.START_ARRAY;
            }
            return null;
        }
        if (this.isEnabled(Feature.WRAP_AS_ARRAY)) {
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            this._state = 1;
            return JsonToken.START_ARRAY;
        }
        return this._handleRecordStart();
    }

    protected JsonToken _handleRecordStart() throws IOException, JsonParseException {
        this._columnIndex = 0;
        if (this._columnCount == 0) {
            this._state = 4;
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            return JsonToken.START_ARRAY;
        }
        this._parsingContext = this._reader.childObjectContext(this._parsingContext);
        this._state = 2;
        return JsonToken.START_OBJECT;
    }

    protected JsonToken _handleNextEntry() throws IOException, JsonParseException {
        String next = this._reader.nextString();
        if (next == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 5 : 1;
            return JsonToken.END_OBJECT;
        }
        this._state = 3;
        this._currentValue = next;
        if (this._columnIndex >= this._columnCount) {
            this._currentName = null;
            if (this._columnIndex == this._columnCount && (next = next.trim()).length() == 0) {
                return this._handleNextEntry();
            }
            this._reportError("Too many entries: expected at most " + this._columnCount + " (value #" + this._columnCount + " (" + next.length() + " chars) \"" + next + "\")");
        }
        this._currentName = this._schema.column(this._columnIndex).getName();
        return JsonToken.FIELD_NAME;
    }

    protected JsonToken _handleNamedValue() throws IOException, JsonParseException {
        this._state = 2;
        ++this._columnIndex;
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleUnnamedValue() throws IOException, JsonParseException {
        String next = this._reader.nextString();
        if (next == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 5 : 1;
            return JsonToken.END_ARRAY;
        }
        this._currentValue = next;
        ++this._columnIndex;
        return JsonToken.VALUE_STRING;
    }

    protected void _readHeaderLine() throws IOException, JsonParseException {
        String name;
        if (this._schema.size() > 0) {
            while (this._reader.nextString() != null) {
            }
            return;
        }
        CsvSchema.Builder builder = this._schema.rebuild().clearColumns();
        while ((name = this._reader.nextString()) != null) {
            CsvSchema.Column prev = this._schema.column(name = name.trim());
            if (prev != null) {
                builder.addColumn(name, prev.getType());
                continue;
            }
            builder.addColumn(name);
        }
        CsvSchema newSchema = builder.build();
        int size = newSchema.size();
        if (size < 2) {
            String first;
            String string = first = size == 0 ? "" : newSchema.column(0).getName().trim();
            if (first.length() == 0) {
                this._reportError("Empty header line: can not bind data");
            }
        }
        this.setSchema(builder.build());
    }

    public boolean hasTextCharacters() {
        return this._textBuffer.hasTextAsCharacters();
    }

    public String getText() throws IOException, JsonParseException {
        return this._currentValue;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this._textBuffer.contentsAsArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this._textBuffer.size();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws IOException, JsonParseException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + this._currToken + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this._currentValue, builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        return this._reader.getNumberType();
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return this._reader.getNumberValue();
    }

    public int getIntValue() throws IOException, JsonParseException {
        return this._reader.getIntValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this._reader.getLongValue();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this._reader.getBigIntegerValue();
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return this._reader.getFloatValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this._reader.getDoubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return this._reader.getDecimalValue();
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF(": expected closing quote character");
    }

    public void _reportCsvError(String msg) throws JsonParseException {
        super._reportError(msg);
    }

    public void _reportUnexpectedCsvChar(int ch, String msg) throws JsonParseException {
        super._reportUnexpectedChar(ch, msg);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    public static enum Feature {
        TRIM_SPACES(false),
        WRAP_AS_ARRAY(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

