/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Reader;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Writer;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class CsvFactory
extends JsonFactory {
    private static final long serialVersionUID = -4036356829870939719L;
    public static final String FORMAT_NAME_CSV = "CSV";
    static final int DEFAULT_CSV_PARSER_FEATURE_FLAGS = CsvParser.Feature.collectDefaults();
    static final int DEFAULT_CSV_GENERATOR_FEATURE_FLAGS = CsvGenerator.Feature.collectDefaults();
    protected static final char[] DEFAULT_LF = new char[]{'\n'};
    protected int _csvParserFeatures = DEFAULT_CSV_PARSER_FEATURE_FLAGS;
    protected int _csvGeneratorFeatures = DEFAULT_CSV_GENERATOR_FEATURE_FLAGS;
    protected char _cfgColumnSeparator = (char)44;
    protected char _cfgQuoteCharacter = (char)34;
    protected char[] _cfgLineSeparator = DEFAULT_LF;

    public CsvFactory() {
        this(null);
    }

    public CsvFactory(ObjectCodec oc) {
        super(oc);
    }

    protected CsvFactory(CsvFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._csvParserFeatures = src._csvParserFeatures;
        this._csvGeneratorFeatures = src._csvGeneratorFeatures;
        this._cfgColumnSeparator = src._cfgColumnSeparator;
        this._cfgQuoteCharacter = src._cfgQuoteCharacter;
        this._cfgLineSeparator = src._cfgLineSeparator;
    }

    public CsvFactory copy() {
        this._checkInvalidCopy(CsvFactory.class);
        return new CsvFactory(this, null);
    }

    protected Object readResolve() {
        return new CsvFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_CSV;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public final CsvFactory configure(CsvParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CsvFactory enable(CsvParser.Feature f) {
        this._csvParserFeatures |= f.getMask();
        return this;
    }

    public CsvFactory disable(CsvParser.Feature f) {
        this._csvParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CsvParser.Feature f) {
        return (this._csvParserFeatures & f.getMask()) != 0;
    }

    public final CsvFactory configure(CsvGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CsvFactory enable(CsvGenerator.Feature f) {
        this._csvGeneratorFeatures |= f.getMask();
        return this;
    }

    public CsvFactory disable(CsvGenerator.Feature f) {
        this._csvGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CsvGenerator.Feature f) {
        return (this._csvGeneratorFeatures & f.getMask()) != 0;
    }

    public CsvParser createParser(File f) throws IOException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    public CsvParser createParser(URL url) throws IOException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public CsvParser createParser(InputStream in) throws IOException {
        return this._createParser(in, this._createContext(in, false));
    }

    public CsvParser createParser(Reader r) throws IOException {
        return this._createParser(r, this._createContext(r, false));
    }

    public CsvParser createParser(String doc) throws IOException {
        return this._createParser(new StringReader(doc), this._createContext(doc, true));
    }

    public CsvParser createParser(byte[] data) throws IOException {
        return this._createParser(data, 0, data.length, this._createContext(data, true));
    }

    public CsvParser createParser(byte[] data, int offset, int len) throws IOException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    public CsvParser createParser(char[] data) throws IOException {
        return this._createParser(data, 0, data.length, this._createContext(data, true), false);
    }

    public CsvParser createParser(char[] data, int offset, int len) throws IOException {
        return this._createParser(data, offset, len, this._createContext(data, true), false);
    }

    public CsvGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(ctxt, this._createWriter(out, JsonEncoding.UTF8, ctxt));
    }

    public CsvGenerator createGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out, JsonEncoding.UTF8);
    }

    public CsvGenerator createGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(out, ctxt);
    }

    public CsvGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        OutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(ctxt, this._createWriter(out, JsonEncoding.UTF8, ctxt));
    }

    protected CsvParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, this._createReader(in, null, ctxt));
    }

    protected CsvParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, r);
    }

    protected CsvParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, this._createReader(data, offset, len, null, ctxt));
    }

    protected CsvParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, new CharArrayReader(data, offset, len));
    }

    protected CsvGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return this._createGenerator(ctxt, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(ctxt, out);
        }
        return new OutputStreamWriter(out, enc.getJavaName());
    }

    protected CsvGenerator _createGenerator(IOContext ctxt, Writer out) throws IOException {
        int feats = this._csvGeneratorFeatures;
        CsvGenerator gen = new CsvGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out, this._cfgColumnSeparator, this._cfgQuoteCharacter, this._cfgLineSeparator);
        return gen;
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null || enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(ctxt, in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data, int offset, int len, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(null, data, offset, len);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

