/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.impl.BufferedValue;
import com.fasterxml.jackson.dataformat.csv.impl.NumberOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public final class CsvWriter {
    protected static final int SHORT_WRITE = 32;
    protected static final int MAX_QUOTE_CHECK = 20;
    protected final BufferedValue[] NO_BUFFERED = new BufferedValue[0];
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();
    protected final IOContext _ioContext;
    protected final Writer _out;
    protected final char _cfgColumnSeparator;
    protected final char _cfgQuoteCharacter;
    protected final char[] _cfgLineSeparator;
    protected final int _cfgLineSeparatorLength;
    protected final int _cfgMinSafeChar;
    protected int _nextColumnToWrite = 0;
    protected BufferedValue[] _buffered = this.NO_BUFFERED;
    protected int _lastBuffered = -1;
    protected char[] _outputBuffer;
    protected boolean _bufferRecyclable;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _charsWritten;

    public CsvWriter(IOContext iOContext, Writer writer, char c, char c2, char[] cArray) {
        this._ioContext = iOContext;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._bufferRecyclable = true;
        this._outputEnd = this._outputBuffer.length;
        this._out = writer;
        this._cfgColumnSeparator = c;
        this._cfgQuoteCharacter = c2;
        this._cfgLineSeparator = cArray;
        this._cfgLineSeparatorLength = cArray.length;
        int n = Math.max(this._cfgColumnSeparator, this._cfgQuoteCharacter);
        for (int i = 0; i < this._cfgLineSeparatorLength; ++i) {
            n = Math.max(n, this._cfgLineSeparator[i]);
        }
        this._cfgMinSafeChar = n + 1;
    }

    public Object getOutputTarget() {
        return this._out;
    }

    public int nextColumnIndex() {
        return this._nextColumnToWrite;
    }

    public void write(int n, String string) throws IOException {
        if (n == this._nextColumnToWrite) {
            this.appendValue(string);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(n, BufferedValue.buffered(string));
    }

    public void write(int n, char[] cArray, int n2, int n3) throws IOException {
        this.write(n, new String(cArray, n2, n3));
    }

    public void write(int n, int n2) throws IOException {
        if (n == this._nextColumnToWrite) {
            this.appendValue(n2);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(n, BufferedValue.buffered(n2));
    }

    public void write(int n, long l) throws IOException {
        if (n == this._nextColumnToWrite) {
            this.appendValue(l);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(n, BufferedValue.buffered(l));
    }

    public void write(int n, double d) throws IOException {
        if (n == this._nextColumnToWrite) {
            this.appendValue(d);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(n, BufferedValue.buffered(d));
    }

    public void write(int n, boolean bl) throws IOException {
        if (n == this._nextColumnToWrite) {
            this.appendValue(bl);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(n, BufferedValue.buffered(bl));
    }

    public void writeColumnName(String string) throws IOException {
        this.appendValue(string);
        ++this._nextColumnToWrite;
    }

    public void endRow() throws IOException {
        if (this._lastBuffered >= 0) {
            int n = this._lastBuffered;
            this._lastBuffered = -1;
            for (int i = this._nextColumnToWrite; i <= n; ++i) {
                BufferedValue bufferedValue = this._buffered[i];
                if (bufferedValue == null) {
                    this.appendColumnSeparator();
                    continue;
                }
                this._buffered[i] = null;
                bufferedValue.write(this);
            }
        } else if (this._nextColumnToWrite <= 0) {
            return;
        }
        this._nextColumnToWrite = 0;
        if (this._outputTail + this._cfgLineSeparatorLength > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(this._cfgLineSeparator, 0, this._outputBuffer, this._outputTail, this._cfgLineSeparatorLength);
        this._outputTail += this._cfgLineSeparatorLength;
    }

    protected void appendValue(String string) throws IOException {
        int n;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (this._mayNeedQuotes(string, n = string.length())) {
            this._writeQuoted(string);
        } else {
            this.writeRaw(string);
        }
    }

    protected void appendValue(int n) throws IOException {
        if (this._outputTail + 12 > this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(long l) throws IOException {
        if (this._outputTail + 22 > this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(double d) throws IOException {
        String string = NumberOutput.toString(d);
        int n = string.length();
        if (this._outputTail + n >= this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this.writeRaw(string);
    }

    protected void appendValue(boolean bl) throws IOException {
        char[] cArray = bl ? TRUE_CHARS : FALSE_CHARS;
        int n = cArray.length;
        if (this._outputTail + n >= this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
        this._outputTail += n;
    }

    protected void appendColumnSeparator() throws IOException {
        if (this._nextColumnToWrite > 0) {
            if (this._outputTail >= this._outputTail) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
    }

    public void _writeQuoted(String string) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char c = this._cfgQuoteCharacter;
        this._outputBuffer[this._outputTail++] = c;
        int n = string.length();
        if (this._outputTail + n + n >= this._outputEnd) {
            this._writeLongQuoted(string);
            return;
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharacter;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c2;
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private final void _writeLongQuoted(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = string.charAt(i)) == this._cfgQuoteCharacter) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharacter;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._cfgQuoteCharacter;
    }

    public void writeRaw(String string) throws IOException {
        int n = string.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
        } else {
            this.writeRawLong(string);
        }
    }

    public void writeRaw(String string, int n, int n2) throws IOException {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string.substring(n, n + n2));
        }
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._out.write(cArray, n, n2);
    }

    public void writeRaw(char c) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String string) throws IOException {
        int n;
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n = string.length() - n3; n > this._outputEnd; n -= n2) {
            n2 = this._outputEnd;
            string.getChars(n4, n4 + n2, this._outputBuffer, 0);
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        string.getChars(n4, n4 + n, this._outputBuffer, 0);
        this._outputTail = n;
    }

    public void flush(boolean bl) throws IOException {
        this._flushBuffer();
        if (bl) {
            this._out.flush();
        }
    }

    public void close(boolean bl) throws IOException {
        this._flushBuffer();
        if (bl) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    protected final boolean _mayNeedQuotes(String string, int n) {
        if (n > 20) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) >= this._cfgMinSafeChar) continue;
            return true;
        }
        return false;
    }

    protected void _buffer(int n, BufferedValue bufferedValue) {
        this._lastBuffered = Math.max(this._lastBuffered, n);
        if (n >= this._buffered.length) {
            this._buffered = Arrays.copyOf(this._buffered, n + 4);
        }
        this._buffered[n] = bufferedValue;
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._charsWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    public void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }
}

