/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.LRUMap;

public class CsvMapper
extends ObjectMapper {
    protected final LRUMap<JavaType, CsvSchema> _untypedSchemas = new LRUMap(8, 32);
    protected final LRUMap<JavaType, CsvSchema> _typedSchemas = new LRUMap(8, 32);

    public CsvMapper() {
        this(new CsvFactory());
    }

    public CsvMapper(CsvFactory f) {
        super((JsonFactory)f);
    }

    public CsvMapper configure(CsvGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper configure(CsvParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper enable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper enable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper disable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    public CsvMapper disable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    public final CsvFactory getFactory() {
        return (CsvFactory)this._jsonFactory;
    }

    @Deprecated
    public final CsvFactory getJsonFactory() {
        return this.getCsvFactory();
    }

    @Deprecated
    public final CsvFactory getCsvFactory() {
        return (CsvFactory)this._jsonFactory;
    }

    public CsvSchema schemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false);
    }

    public CsvSchema typedSchemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true);
    }

    public ObjectReader reader(FormatSchema schema) {
        if (schema != null && !(schema instanceof CsvSchema)) {
            throw new IllegalArgumentException("Schema to set must be of type CsvSchema");
        }
        return super.reader(schema);
    }

    public ObjectWriter writer(FormatSchema schema) {
        if (schema != null && !(schema instanceof CsvSchema)) {
            throw new IllegalArgumentException("Schema to set must be of type CsvSchema");
        }
        return super.writer(schema);
    }

    public ObjectReader readerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.reader(type).with((FormatSchema)this.schemaFor(type));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.reader(type).with((FormatSchema)this.typedSchemaFor(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<JavaType, CsvSchema> schemas, boolean typed) {
        LRUMap<JavaType, CsvSchema> lRUMap = schemas;
        synchronized (lRUMap) {
            CsvSchema s = (CsvSchema)schemas.get(pojoType);
            if (s != null) {
                return s;
            }
        }
        BeanDescription beanDesc = this.getSerializationConfig().introspect(pojoType);
        CsvSchema.Builder builder = CsvSchema.builder();
        for (BeanPropertyDefinition prop : beanDesc.findProperties()) {
            if (!prop.couldSerialize()) continue;
            if (typed) {
                builder.addColumn(prop.getName(), this._determineType(prop.getAccessor().getRawType()));
                continue;
            }
            builder.addColumn(prop.getName());
        }
        CsvSchema result = builder.build();
        LRUMap<JavaType, CsvSchema> lRUMap2 = schemas;
        synchronized (lRUMap2) {
            schemas.put(pojoType, result);
        }
        return result;
    }

    protected CsvSchema.ColumnType _determineType(Class<?> propType) {
        if (propType == String.class || propType == Character.TYPE || propType == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (propType.isPrimitive() || Number.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }
}

