/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.embedded;

import com.datastax.spark.connector.embedded.EmbeddedIO;
import com.datastax.spark.connector.embedded.EmbeddedIO$;
import com.datastax.spark.connector.embedded.EmbeddedIO$$anonfun$copyTextFileWithVariableSubstitution$1$;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.UUID;
import org.apache.commons.lang3.SystemUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public abstract class EmbeddedIO$class {
    private static Class[] reflParams$Cache1 = new Class[0];
    private static volatile SoftReference reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static Object closeAfterUse(EmbeddedIO $this, Object closeable, Function1 code) {
        Object qual1;
        Object object;
        try {
            object = code.apply(closeable);
            qual1 = closeable;
        }
        catch (Throwable throwable) {
            Object qual12 = closeable;
            try {
                EmbeddedIO$class.reflMethod$Method1(qual12.getClass()).invoke(qual12, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        try {
            EmbeddedIO$class.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return object;
    }

    public static void copyTextFileWithVariableSubstitution(EmbeddedIO $this, InputStream source, OutputStream target, Function1 map) {
        Regex regex = new StringOps(Predef$.MODULE$.augmentString("\\$\\{([a-zA-Z0-9_]+)\\}")).r();
        $this.closeAfterUse(new PrintWriter(target), new Serializable($this, regex, source, map){
            public static final long serialVersionUID = 0L;
            public final Regex regex$1;
            private final InputStream source$1;
            public final Function1 map$1;

            public final void apply(PrintWriter writer) {
                BufferedSource input = Source$.MODULE$.fromInputStream(this.source$1, "UTF-8");
                input.getLines().foreach((Function1)new Serializable(this, writer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EmbeddedIO$.anonfun.copyTextFileWithVariableSubstitution.1 $outer;
                    private final PrintWriter writer$1;

                    public final void apply(String line) {
                        String substituted = this.$outer.regex$1.replaceAllIn((CharSequence)line, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ EmbeddedIO$$anonfun$copyTextFileWithVariableSubstitution$1$.anonfun.apply.2 $outer;

                            public final String apply(Regex.Match m) {
                                return (String)this.$outer.com$datastax$spark$connector$embedded$EmbeddedIO$$anonfun$$anonfun$$$outer().map$1.apply((Object)m.group(1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.writer$1.println(substituted);
                    }

                    public /* synthetic */ EmbeddedIO$.anonfun.copyTextFileWithVariableSubstitution.1 com$datastax$spark$connector$embedded$EmbeddedIO$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writer$1 = writer$1;
                    }
                });
            }
            {
                this.regex$1 = regex$1;
                this.source$1 = source$1;
                this.map$1 = map$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static File createTempDir(EmbeddedIO $this) {
        void var1_1;
        File dir = $this.mkdir(new File(Files.createTempDir(), new StringBuilder().append((Object)"spark-tmp-").append((Object)UUID.randomUUID().toString()).toString()));
        $this.registerShutdownDeleteDir(dir);
        Runtime.getRuntime().addShutdownHook(new Thread($this, dir){
            private final /* synthetic */ EmbeddedIO $outer;
            private final File dir$1;

            public void run() {
                if (!this.$outer.hasRootAsShutdownDeleteDir(this.dir$1)) {
                    this.$outer.deleteRecursively(this.dir$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
                super(new StringBuilder().append((Object)"delete Spark temp dir ").append((Object)dir$1).toString());
            }
        });
        return var1_1;
    }

    public static File mkdir(EmbeddedIO $this, File dir) {
        if (dir.mkdir()) {
            return dir;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})));
    }

    public static boolean waitForPortOpen(EmbeddedIO $this, InetAddress host, int port, long timeout, Function0 stopIf) {
        long startTime = System.currentTimeMillis();
        Iterator portProbe = package$.MODULE$.Iterator().continually((Function0)new Serializable($this, host, port, stopIf){
            public static final long serialVersionUID = 0L;
            public final InetAddress host$1;
            public final int port$1;
            public final Function0 stopIf$1;

            public final Try<BoxedUnit> apply() {
                return Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EmbeddedIO$.anonfun.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Thread.sleep(100L);
                        if (this.$outer.stopIf$1.apply$mcZ$sp()) {
                            throw new RuntimeException();
                        }
                        Socket socket = new Socket(this.$outer.host$1, this.$outer.port$1);
                        socket.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.stopIf$1 = stopIf$1;
            }
        });
        return ((Try)portProbe.dropWhile((Function1)new Serializable($this, startTime, timeout){
            public static final long serialVersionUID = 0L;
            private final long startTime$1;
            private final long timeout$1;

            public final boolean apply(Try<BoxedUnit> p) {
                return p.isFailure() && System.currentTimeMillis() - this.startTime$1 < this.timeout$1;
            }
            {
                this.startTime$1 = startTime$1;
                this.timeout$1 = timeout$1;
            }
        }).next()).isSuccess();
    }

    public static Function0 waitForPortOpen$default$4(EmbeddedIO $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        };
    }

    public static void registerShutdownDeleteDir(EmbeddedIO $this, File file) {
        HashSet<String> hashSet = $this.shutdownDeletePaths();
        synchronized (hashSet) {
            $this.shutdownDeletePaths().$plus$eq((Object)file.getAbsolutePath());
            return;
        }
    }

    public static boolean hasRootAsShutdownDeleteDir(EmbeddedIO $this, File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = $this.shutdownDeletePaths();
        synchronized (hashSet) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)$this.shutdownDeletePaths().exists((Function1)new Serializable($this, absolutePath){
                public static final long serialVersionUID = 0L;
                private final String absolutePath$1;

                public final boolean apply(String path) {
                    return !this.absolutePath$1.equals(path) && this.absolutePath$1.startsWith(path);
                }
                {
                    this.absolutePath$1 = absolutePath$1;
                }
            }));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public static void deleteRecursively(EmbeddedIO $this, File file) {
        if (file != null) {
            if (file.isDirectory() && !$this.isSymlink(file)) {
                $this.listFilesSafely(file).foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EmbeddedIO $outer;

                    public final void apply(File child) {
                        this.$outer.deleteRecursively(child);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (!file.delete() && file.exists()) {
                throw new IOException(new StringBuilder().append((Object)"Failed to delete: ").append((Object)file.getAbsolutePath()).toString());
            }
        }
    }

    public static boolean isSymlink(EmbeddedIO $this, File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        File fcd = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fcd.getCanonicalFile().equals(fcd.getAbsoluteFile());
    }

    public static Seq listFilesSafely(EmbeddedIO $this, File file) {
        File[] files = file.listFiles();
        if (files == null) {
            throw new IOException(new StringBuilder().append((Object)"Failed to list files for dir: ").append((Object)file).toString());
        }
        return Predef$.MODULE$.wrapRefArray((Object[])files);
    }

    public static void $init$(EmbeddedIO $this) {
        $this.com$datastax$spark$connector$embedded$EmbeddedIO$_setter_$shutdownDeletePaths_$eq(new HashSet());
    }
}

