/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.embedded;

import com.datastax.spark.connector.embedded.DynamicCassandraPorts;
import com.datastax.spark.connector.embedded.DynamicCassandraPorts$;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DynamicCassandraPorts$
implements Serializable {
    public static final DynamicCassandraPorts$ MODULE$;
    private final int MaxInstances;
    private final int RPC_OFFSET;
    private final int JMX_OFFSET;
    private final int SSL_STORAGE_OFFSET;
    private final int STORAGE_OFFSET;
    private Path basePath;
    private Range basePorts;
    private volatile byte bitmap$0;

    static {
        new DynamicCassandraPorts$();
    }

    private Path basePath$lzycompute() {
        DynamicCassandraPorts$ dynamicCassandraPorts$ = this;
        synchronized (dynamicCassandraPorts$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.basePath = Paths.get((String)package$.MODULE$.props().apply((Object)"baseDir"), "target", "ports");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.basePath;
        }
    }

    private Range basePorts$lzycompute() {
        DynamicCassandraPorts$ dynamicCassandraPorts$ = this;
        synchronized (dynamicCassandraPorts$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.basePorts = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10000), 20000).by(50);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.basePorts;
        }
    }

    public int MaxInstances() {
        return this.MaxInstances;
    }

    public int RPC_OFFSET() {
        return this.RPC_OFFSET;
    }

    public int JMX_OFFSET() {
        return this.JMX_OFFSET;
    }

    public int SSL_STORAGE_OFFSET() {
        return this.SSL_STORAGE_OFFSET;
    }

    public int STORAGE_OFFSET() {
        return this.STORAGE_OFFSET;
    }

    private Path basePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.basePath$lzycompute() : this.basePath;
    }

    private Range basePorts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.basePorts$lzycompute() : this.basePorts;
    }

    public Path com$datastax$spark$connector$embedded$DynamicCassandraPorts$$portLockFile(int port) {
        return this.basePath().resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"port_", ".lock"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
    }

    public DynamicCassandraPorts apply() {
        return new DynamicCassandraPorts(this.chooseBasePort());
    }

    public boolean areAllPortsAvailable(String host, Seq<Object> ports) {
        return ((ParIterableLike)ports.par()).forall((Function1)new Serializable(host){
            public static final long serialVersionUID = 0L;
            public final String host$1;

            public final boolean apply(int port) {
                return this.apply$mcZI$sp(port);
            }

            public boolean apply$mcZI$sp(int port) {
                boolean bl;
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, port){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.areAllPortsAvailable.1 $outer;
                    private final int port$1;

                    public final Socket apply() {
                        return new Socket(this.$outer.host$1, this.port$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.port$1 = port$1;
                    }
                });
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Socket socket = (Socket)success.value();
                    socket.close();
                    bl = false;
                } else {
                    Failure failure;
                    Throwable ex;
                    bl = try_ instanceof Failure && (ex = (failure = (Failure)try_).exception()) instanceof ConnectException;
                }
                return bl;
            }
            {
                this.host$1 = host$1;
            }
        });
    }

    public int chooseBasePort() {
        while (true) {
            Files.createDirectories(this.basePath(), new FileAttribute[0]);
            Option foundPort = this.basePorts().find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int basePort) {
                    return this.apply$mcZI$sp(basePort);
                }

                public boolean apply$mcZI$sp(int basePort) {
                    Try try_;
                    Failure failure;
                    boolean bl;
                    block8: {
                        boolean bl2;
                        block7: {
                            block6: {
                                boolean bl3;
                                Path filePath;
                                Path file = DynamicCassandraPorts$.MODULE$.com$datastax$spark$connector$embedded$DynamicCassandraPorts$$portLockFile(basePort);
                                bl = false;
                                failure = null;
                                try_ = Try$.MODULE$.apply((Function0)new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final Path file$1;

                                    public final Path apply() {
                                        return Files.createFile(this.file$1, new FileAttribute[0]);
                                    }
                                    {
                                        this.file$1 = file$1;
                                    }
                                });
                                if (!(try_ instanceof Success)) break block6;
                                Success success = (Success)try_;
                                Path path = filePath = (Path)success.value();
                                Path path2 = file;
                                Predef$.MODULE$.require(!(path != null ? !((Object)path).equals(path2) : path2 != null));
                                if (DynamicCassandraPorts$.MODULE$.areAllPortsAvailable("127.0.0.1", (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(basePort), basePort + 100))) {
                                    bl3 = true;
                                } else {
                                    DynamicCassandraPorts$.MODULE$.releaseBasePort(basePort);
                                    bl3 = false;
                                }
                                bl2 = bl3;
                                break block7;
                            }
                            if (!(try_ instanceof Failure)) break block8;
                            bl = true;
                            failure = (Failure)try_;
                            Throwable ex = failure.exception();
                            if (!(ex instanceof FileAlreadyExistsException)) break block8;
                            bl2 = false;
                        }
                        return bl2;
                    }
                    if (bl) {
                        Throwable ex = failure.exception();
                        throw ex;
                    }
                    throw new MatchError((Object)try_);
                }
            });
            if (foundPort.isDefined()) {
                return BoxesRunTime.unboxToInt((Object)foundPort.get());
            }
            Thread.sleep(1000L);
        }
    }

    public void releaseBasePort(int basePort) {
        Path file = this.com$datastax$spark$connector$embedded$DynamicCassandraPorts$$portLockFile(basePort);
        Files.deleteIfExists(file);
    }

    public DynamicCassandraPorts apply(int basePort) {
        return new DynamicCassandraPorts(basePort);
    }

    public Option<Object> unapply(DynamicCassandraPorts x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)x$0.basePort()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamicCassandraPorts$() {
        MODULE$ = this;
        this.MaxInstances = 5;
        this.RPC_OFFSET = 0;
        this.JMX_OFFSET = this.MaxInstances();
        this.SSL_STORAGE_OFFSET = this.MaxInstances() * 2;
        this.STORAGE_OFFSET = this.MaxInstances() * 3;
    }
}

