/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.embedded;

import com.datastax.spark.connector.embedded.Assertions$class;
import com.datastax.spark.connector.embedded.CassandraRunner$;
import com.datastax.spark.connector.embedded.Embedded;
import com.datastax.spark.connector.embedded.EmbeddedIO$class;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.cassandra.io.util.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!B\u0001\u0003\u0001\u0011a!aD\"bgN\fg\u000e\u001a:b%Vtg.\u001a:\u000b\u0005\r!\u0011\u0001C3nE\u0016$G-\u001a3\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\tAQ)\u001c2fI\u0012,G\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001b\u00039\u0019wN\u001c4jOR+W\u000e\u001d7bi\u0016\u001c\u0001!F\u0001\u001c!\tarD\u0004\u0002\u000f;%\u0011adD\u0001\u0007!J,G-\u001a4\n\u0005\u0001\n#AB*ue&twM\u0003\u0002\u001f\u001f!A1\u0005\u0001B\u0001B\u0003%1$A\bd_:4\u0017n\u001a+f[Bd\u0017\r^3!\u0011!)\u0003A!A!\u0002\u00131\u0013!\u00029s_B\u001c\b\u0003\u0002\u000f(7mI!\u0001K\u0011\u0003\u00075\u000b\u0007\u000fC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003C\u0001\u000b\u0001\u0011\u0015A\u0012\u00061\u0001\u001c\u0011\u0015)\u0013\u00061\u0001'\u0011\u001d\u0001\u0004A1A\u0005\u0002E\nq\u0001^3na\u0012K'/F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0002j_*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u00111\u0015\u000e\\3\t\rm\u0002\u0001\u0015!\u00033\u0003!!X-\u001c9ESJ\u0004\u0003bB\u001f\u0001\u0005\u0004%\t!M\u0001\bo>\u00148\u000eR5s\u0011\u0019y\u0004\u0001)A\u0005e\u0005Aqo\u001c:l\t&\u0014\b\u0005C\u0004B\u0001\t\u0007I\u0011A\u0019\u0002\u000f\u0011\fG/\u0019#je\"11\t\u0001Q\u0001\nI\n\u0001\u0002Z1uC\u0012K'\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u00012\u00031\u0019w.\\7ji2{w\rR5s\u0011\u00199\u0005\u0001)A\u0005e\u0005i1m\\7nSRdun\u001a#je\u0002Bq!\u0013\u0001C\u0002\u0013\u0005\u0011'A\u0005dC\u000eDWm\u001d#je\"11\n\u0001Q\u0001\nI\n!bY1dQ\u0016\u001cH)\u001b:!\u0011\u001di\u0005A1A\u0005\u0002E\nqaY8oM\u0012K'\u000f\u0003\u0004P\u0001\u0001\u0006IAM\u0001\tG>tg\rR5sA!9\u0011\u000b\u0001b\u0001\n\u0003\t\u0014\u0001C2p]\u001a4\u0015\u000e\\3\t\rM\u0003\u0001\u0015!\u00033\u0003%\u0019wN\u001c4GS2,\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u0002\u0015A\u0014x\u000e]3si&,7/F\u0001X!\u0011AVL\u00180\u000e\u0003eS!AW.\u0002\u0013%lW.\u001e;bE2,'B\u0001/\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Qe\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u001c\u0002\t1\fgnZ\u0005\u0003A\u0001Da\u0001\u001a\u0001!\u0002\u00139\u0016a\u00039s_B,'\u000f^5fg\u0002BqA\u001a\u0001C\u0002\u0013%q-A\u0005dY\u0006\u001c8\u000fU1uQV\ta\f\u0003\u0004j\u0001\u0001\u0006IAX\u0001\u000bG2\f7o\u001d)bi\"\u0004\u0003bB6\u0001\u0005\u0004%IaZ\u0001\bU\u00064\u0018MQ5o\u0011\u0019i\u0007\u0001)A\u0005=\u0006A!.\u0019<b\u0005&t\u0007\u0005C\u0004p\u0001\t\u0007I\u0011B4\u0002+\r\f7o]1oIJ\f7i\u001c8g!J|\u0007/\u001a:us\"1\u0011\u000f\u0001Q\u0001\ny\u000bacY1tg\u0006tGM]1D_:4\u0007K]8qKJ$\u0018\u0010\t\u0005\bg\u0002\u0011\r\u0011\"\u0003h\u0003m\u0019X\u000f]3skN,'oU3ukB$U\r\\1z!J|\u0007/\u001a:us\"1Q\u000f\u0001Q\u0001\ny\u000bAd];qKJ,8/\u001a:TKR,\b\u000fR3mCf\u0004&o\u001c9feRL\b\u0005C\u0004x\u0001\t\u0007I\u0011\u0002=\u0002\u000f)l\u0007\u0010U8siV\t\u0011\u0010\u0005\u0002\u000fu&\u00111p\u0004\u0002\u0004\u0003:L\bBB?\u0001A\u0003%\u00110\u0001\u0005k[b\u0004vN\u001d;!\u0011\u001dy\bA1A\u0005\ni\tqB[7y!>\u0014H\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003\u001c\u0003AQW\u000e\u001f)peR\u0004&o\u001c9feRL\b\u0005\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u001b\u0003\r\u001a\u0018N_3FgRLW.\u0019;fgV\u0003H-\u0019;f\u0013:$XM\u001d<bYB\u0013x\u000e]3sifDq!a\u0003\u0001A\u0003%1$\u0001\u0013tSj,Wi\u001d;j[\u0006$Xm]+qI\u0006$X-\u00138uKJ4\u0018\r\u001c)s_B,'\u000f^=!\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\"A\u0005kC6l\u0017iZ3oiV\u0011\u00111\u0003\t\u0005\u001d\u0005Ua,C\u0002\u0002\u0018=\u0011aa\u00149uS>t\u0007\u0002CA\u000e\u0001\u0001\u0006I!a\u0005\u0002\u0015)\fW.\\!hK:$\b\u0005\u0003\u0005\u0002 \u0001\u0011\r\u0011\"\u0003h\u0003EQ\u0017-\\7BO\u0016tG\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0003G\u0001\u0001\u0015!\u0003_\u0003IQ\u0017-\\7BO\u0016tG\u000f\u0015:pa\u0016\u0014H/\u001f\u0011\t\u0011\u0005\u001d\u0002A1A\u0005\n\u001d\f!cY1tg\u0006tGM]1NC&t7\t\\1tg\"9\u00111\u0006\u0001!\u0002\u0013q\u0016aE2bgN\fg\u000e\u001a:b\u001b\u0006Lgn\u00117bgN\u0004\u0003\"CA\u0018\u0001\t\u0007I\u0011BA\u0019\u0003\u001d\u0001(o\\2fgN,\"!a\r\u0011\u0007}\u000b)$C\u0002\u00028\u0001\u0014q\u0001\u0015:pG\u0016\u001c8\u000f\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001a\u0003!\u0001(o\\2fgN\u0004\u0003\"CA \u0001\t\u0007I\u0011AA!\u0003)q\u0017\r^5wKB{'\u000f^\u000b\u0003\u0003\u0007\u00022ADA#\u0013\r\t9e\u0004\u0002\u0004\u0013:$\b\u0002CA&\u0001\u0001\u0006I!a\u0011\u0002\u00179\fG/\u001b<f!>\u0014H\u000f\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003\u001d!Wm\u001d;s_f$\"!a\u0015\u0011\u00079\t)&C\u0002\u0002X=\u0011A!\u00168ji\u001e9\u00111\f\u0002\t\u0002\u0005u\u0013aD\"bgN\fg\u000e\u001a:b%Vtg.\u001a:\u0011\u0007Q\tyF\u0002\u0004\u0002\u0005!\u0005\u0011\u0011M\n\u0006\u0003?j\u00111\r\t\u0004\u001d\u0005\u0015\u0014bAA4\u001f\ta1+\u001a:jC2L'0\u00192mK\"9!&a\u0018\u0005\u0002\u0005-DCAA/\u0011)\ty'a\u0018C\u0002\u0013\u0005\u0011\u0011I\u0001%'&TX-R:uS6\fG/Z:Va\u0012\fG/Z%oi\u0016\u0014h/\u00197J]N+7m\u001c8eg\"I\u00111OA0A\u0003%\u00111I\u0001&'&TX-R:uS6\fG/Z:Va\u0012\fG/Z%oi\u0016\u0014h/\u00197J]N+7m\u001c8eg\u0002B!\"a\u001e\u0002`\t\u0007I\u0011AA!\u00039!UMZ1vYRTU\u000e\u001f)peRD\u0011\"a\u001f\u0002`\u0001\u0006I!a\u0011\u0002\u001f\u0011+g-Y;mi*k\u0007\u0010U8si\u0002B!\"a \u0002`\u0005\u0005I\u0011BAA\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0005cA0\u0002\u0006&\u0019\u0011q\u00111\u0003\r=\u0013'.Z2u\u0001")
public class CassandraRunner
implements Embedded {
    private final String configTemplate;
    private final File tempDir;
    private final File workDir;
    private final File dataDir;
    private final File commitLogDir;
    private final File cachesDir;
    private final File confDir;
    private final File confFile;
    private final Map<String, String> com$datastax$spark$connector$embedded$CassandraRunner$$properties;
    private final String classPath;
    private final String javaBin;
    private final String cassandraConfProperty;
    private final String superuserSetupDelayProperty;
    private final Object jmxPort;
    private final String jmxPortProperty;
    private final String sizeEstimatesUpdateIntervalProperty;
    private final Option<String> jammAgent;
    private final String jammAgentProperty;
    private final String cassandraMainClass;
    private final Process process;
    private final int nativePort;
    private Duration com$datastax$spark$connector$embedded$Assertions$$end;
    private final HashSet<String> shutdownDeletePaths;

    public static int DefaultJmxPort() {
        return CassandraRunner$.MODULE$.DefaultJmxPort();
    }

    public static int SizeEstimatesUpdateIntervalInSeconds() {
        return CassandraRunner$.MODULE$.SizeEstimatesUpdateIntervalInSeconds();
    }

    @Override
    public Duration com$datastax$spark$connector$embedded$Assertions$$end() {
        return this.com$datastax$spark$connector$embedded$Assertions$$end;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$embedded$Assertions$$end_$eq(Duration x$1) {
        this.com$datastax$spark$connector$embedded$Assertions$$end = x$1;
    }

    @Override
    public FiniteDuration now() {
        return Assertions$class.now(this);
    }

    @Override
    public FiniteDuration remainingOrDefault() {
        return Assertions$class.remainingOrDefault(this);
    }

    @Override
    public FiniteDuration remainingOr(FiniteDuration duration) {
        return Assertions$class.remainingOr(this, duration);
    }

    @Override
    public void awaitCond(Function0<Object> p, Duration max, Duration interval, String message) {
        Assertions$class.awaitCond(this, p, max, interval, message);
    }

    @Override
    public Duration awaitCond$default$2() {
        return Assertions$class.awaitCond$default$2(this);
    }

    @Override
    public Duration awaitCond$default$3() {
        return Assertions$class.awaitCond$default$3(this);
    }

    @Override
    public String awaitCond$default$4() {
        return Assertions$class.awaitCond$default$4(this);
    }

    @Override
    public HashSet<String> shutdownDeletePaths() {
        return this.shutdownDeletePaths;
    }

    @Override
    public void com$datastax$spark$connector$embedded$EmbeddedIO$_setter_$shutdownDeletePaths_$eq(HashSet x$1) {
        this.shutdownDeletePaths = x$1;
    }

    @Override
    public <T, C> T closeAfterUse(C closeable, Function1<C, T> code) {
        return (T)EmbeddedIO$class.closeAfterUse(this, closeable, code);
    }

    @Override
    public void copyTextFileWithVariableSubstitution(InputStream source, OutputStream target, Function1<String, String> map) {
        EmbeddedIO$class.copyTextFileWithVariableSubstitution(this, source, target, map);
    }

    @Override
    public File createTempDir() {
        return EmbeddedIO$class.createTempDir(this);
    }

    @Override
    public File mkdir(File dir) {
        return EmbeddedIO$class.mkdir(this, dir);
    }

    @Override
    public boolean waitForPortOpen(InetAddress host, int port, long timeout) {
        return EmbeddedIO$class.waitForPortOpen(this, host, port, timeout);
    }

    @Override
    public void registerShutdownDeleteDir(File file) {
        EmbeddedIO$class.registerShutdownDeleteDir(this, file);
    }

    @Override
    public boolean hasRootAsShutdownDeleteDir(File file) {
        return EmbeddedIO$class.hasRootAsShutdownDeleteDir(this, file);
    }

    @Override
    public void deleteRecursively(File file) {
        EmbeddedIO$class.deleteRecursively(this, file);
    }

    @Override
    public boolean isSymlink(File file) {
        return EmbeddedIO$class.isSymlink(this, file);
    }

    @Override
    public Seq<File> listFilesSafely(File file) {
        return EmbeddedIO$class.listFilesSafely(this, file);
    }

    public String configTemplate() {
        return this.configTemplate;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public File workDir() {
        return this.workDir;
    }

    public File dataDir() {
        return this.dataDir;
    }

    public File commitLogDir() {
        return this.commitLogDir;
    }

    public File cachesDir() {
        return this.cachesDir;
    }

    public File confDir() {
        return this.confDir;
    }

    public File confFile() {
        return this.confFile;
    }

    public Map<String, String> com$datastax$spark$connector$embedded$CassandraRunner$$properties() {
        return this.com$datastax$spark$connector$embedded$CassandraRunner$$properties;
    }

    private String classPath() {
        return this.classPath;
    }

    private String javaBin() {
        return this.javaBin;
    }

    private String cassandraConfProperty() {
        return this.cassandraConfProperty;
    }

    private String superuserSetupDelayProperty() {
        return this.superuserSetupDelayProperty;
    }

    private Object jmxPort() {
        return this.jmxPort;
    }

    private String jmxPortProperty() {
        return this.jmxPortProperty;
    }

    private String sizeEstimatesUpdateIntervalProperty() {
        return this.sizeEstimatesUpdateIntervalProperty;
    }

    private Option<String> jammAgent() {
        return this.jammAgent;
    }

    private String jammAgentProperty() {
        return this.jammAgentProperty;
    }

    private String cassandraMainClass() {
        return this.cassandraMainClass;
    }

    private Process process() {
        return this.process;
    }

    public int nativePort() {
        return this.nativePort;
    }

    public void destroy() {
        this.process().destroy();
        this.process().waitFor();
        FileUtils.deleteRecursive((File)this.tempDir());
        this.tempDir().delete();
    }

    public CassandraRunner(String configTemplate, Map<String, String> props) {
        this.configTemplate = configTemplate;
        EmbeddedIO$class.$init$(this);
        Assertions$class.$init$(this);
        this.tempDir = this.mkdir(new File(Files.createTempDir(), "cassandra-driver-spark"));
        this.workDir = this.mkdir(new File(this.tempDir(), "cassandra"));
        this.dataDir = this.mkdir(new File(this.workDir(), "data"));
        this.commitLogDir = this.mkdir(new File(this.workDir(), "commitlog"));
        this.cachesDir = this.mkdir(new File(this.workDir(), "saved_caches"));
        this.confDir = this.mkdir(new File(this.tempDir(), "conf"));
        this.confFile = new File(this.confDir(), "cassandra.yaml");
        this.com$datastax$spark$connector$embedded$CassandraRunner$$properties = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"cassandra_dir"), (Object)this.workDir().toString())}))).$plus$plus(props);
        this.closeAfterUse((Object)ClassLoader.getSystemResourceAsStream(configTemplate), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraRunner $outer;

            public final void apply(InputStream input) {
                this.$outer.closeAfterUse(new FileOutputStream(this.$outer.confFile()), new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final InputStream input$1;

                    public final void apply(FileOutputStream output) {
                        this.$outer.com$datastax$spark$connector$embedded$CassandraRunner$$anonfun$$$outer().copyTextFileWithVariableSubstitution(this.input$1, output, (Function1<String, String>)this.$outer.com$datastax$spark$connector$embedded$CassandraRunner$$anonfun$$$outer().com$datastax$spark$connector$embedded$CassandraRunner$$properties());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.input$1 = input$1;
                    }
                });
            }

            public /* synthetic */ CassandraRunner com$datastax$spark$connector$embedded$CassandraRunner$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.classPath = System.getProperty("java.class.path");
        this.javaBin = new StringBuilder().append((Object)System.getProperty("java.home")).append((Object)"/bin/java").toString();
        this.cassandraConfProperty = new StringBuilder().append((Object)"-Dcassandra.config=file:").append((Object)this.confFile().toString()).toString();
        this.superuserSetupDelayProperty = "-Dcassandra.superuser_setup_delay_ms=0";
        this.jmxPort = props.getOrElse((Object)"jmx_port", (Function0)new $anonfun$1(this));
        this.jmxPortProperty = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Dcassandra.jmx.local.port=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jmxPort()}));
        this.sizeEstimatesUpdateIntervalProperty = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Dcassandra.size_recorder_interval=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CassandraRunner$.MODULE$.SizeEstimatesUpdateIntervalInSeconds())}));
        this.jammAgent = Predef$.MODULE$.refArrayOps((Object[])this.classPath().split(File.pathSeparator)).find((Function1)new $anonfun$4(this));
        this.jammAgentProperty = (String)this.jammAgent().map((Function1)new $anonfun$5(this)).getOrElse((Function0)new $anonfun$6(this));
        this.cassandraMainClass = "org.apache.cassandra.service.CassandraDaemon";
        this.process = new ProcessBuilder(new String[0]).command(this.javaBin(), "-Xms2G", "-Xmx2G", "-Xmn384M", "-XX:+UseConcMarkSweepGC", this.sizeEstimatesUpdateIntervalProperty(), this.cassandraConfProperty(), this.jammAgentProperty(), this.superuserSetupDelayProperty(), this.jmxPortProperty(), "-cp", this.classPath(), this.cassandraMainClass(), "-f").inheritIO().start();
        this.nativePort = new StringOps(Predef$.MODULE$.augmentString((String)props.get((Object)"native_transport_port").get())).toInt();
        if (this.waitForPortOpen(InetAddress.getByName((String)props.get((Object)"rpc_address").get()), this.nativePort(), 100000L)) {
            return;
        }
        throw new IOException("Failed to start Cassandra.");
    }
}

