/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.demo.streaming;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.util.Timeout;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.demo.streaming.NodeGuardian$;
import com.datastax.spark.connector.demo.streaming.Reporter;
import com.datastax.spark.connector.demo.streaming.Sender;
import com.datastax.spark.connector.demo.streaming.SparkCassandraSettings;
import com.datastax.spark.connector.demo.streaming.Streamer;
import com.datastax.spark.connector.demo.streaming.StreamingEvent;
import com.datastax.spark.connector.demo.streaming.StreamingEvent$Completed$;
import com.datastax.spark.connector.demo.streaming.StreamingEvent$Report$;
import com.datastax.spark.connector.embedded.Assertions;
import com.datastax.spark.connector.mapper.ColumnMapper;
import com.datastax.spark.connector.mapper.ColumnMapper$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.RowWriterFactory$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001=\u0011ABT8eK\u001e+\u0018M\u001d3jC:T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003\u0011!W-\\8\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001\u0001C\u0006\u0010%!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0006C\u000e$xN\u001d\u0006\u00027\u0005!\u0011m[6b\u0013\ti\u0002DA\u0003BGR|'\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u0005AQ-\u001c2fI\u0012,G-\u0003\u0002$A\tQ\u0011i]:feRLwN\\:\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0011\u0001B;uS2L!!\u000b\u0014\u0003\u000f1{wmZ5oO\"A1\u0006\u0001B\u0001B\u0003%A&A\u0002tg\u000e\u0004\"!\f\u001b\u000e\u00039R!aA\u0018\u000b\u0005%\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!\u000e\u0018\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0011M,G\u000f^5oON\u0004\"!\u000f\u001e\u000e\u0003\tI!a\u000f\u0002\u0003-M\u0003\u0018M]6DCN\u001c\u0018M\u001c3sCN+G\u000f^5oOND\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004\"a\u0010\"\u000f\u0005E\u0001\u0015BA!\u0013\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u0013\u0002\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\u0002\t\u0011\fG/\u0019\t\u0004\u00116sT\"A%\u000b\u0005)[\u0015!C5n[V$\u0018M\u00197f\u0015\ta%#\u0001\u0006d_2dWm\u0019;j_:L!AT%\u0003\u0007M+G\u000fC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0004=S:LGO\u0010\u000b\u0006%N#VK\u0016\t\u0003s\u0001AQaK(A\u00021BQaN(A\u0002aBQ!P(A\u0002yBQAR(A\u0002\u001dCq\u0001\u0017\u0001C\u0002\u0013\r\u0011,A\u0004uS6,w.\u001e;\u0016\u0003i\u0003\"aW/\u000e\u0003qS!a\n\u000e\n\u0005yc&a\u0002+j[\u0016|W\u000f\u001e\u0005\u0007A\u0002\u0001\u000b\u0011\u0002.\u0002\u0011QLW.Z8vi\u0002BqA\u0019\u0001C\u0002\u0013%1-A\u0005bGR|'OT1nKV\tA\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006!A.\u00198h\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u00114\t\r1\u0004\u0001\u0015!\u0003e\u0003)\t7\r^8s\u001d\u0006lW\r\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003\r\u0019\u0018m]\u000b\u0002aB\u0011q#]\u0005\u0003eb\u00111\"Q2u_J\u001c\u0016p\u001d;f[\"1A\u000f\u0001Q\u0001\nA\fAa]1tA!9a\u000f\u0001b\u0001\n\u00139\u0018\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003a\u0004\"aF=\n\u0005iD\"\u0001C!di>\u0014(+\u001a4\t\rq\u0004\u0001\u0015!\u0003y\u0003%\u0011X\r]8si\u0016\u0014\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011B@\u0002\rM$(/Z1n+\t\t\t\u0001E\u0003\u0002\u0004\u0005%a(\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0018\u0002\u000f\u0011\u001cHO]3b[&!\u00111BA\u0003\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\u0004tiJ,\u0017-\u001c\u0011\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u00059!/Z2fSZ,WCAA\f!\u0011\tI\"a\b\u000f\u0007]\tY\"C\u0002\u0002\u001ea\tQ!Q2u_JLA!!\t\u0002$\t9!+Z2fSZ,'bAA\u000f1!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0012\u0001C:ikR$wn\u001e8\u0015\u0005\u0005-\u0002cA\t\u0002.%\u0019\u0011q\u0006\n\u0003\tUs\u0017\u000e\u001e")
public class NodeGuardian
implements Actor,
Assertions,
Logging {
    public final StreamingContext com$datastax$spark$connector$demo$streaming$NodeGuardian$$ssc;
    public final String com$datastax$spark$connector$demo$streaming$NodeGuardian$$tableName;
    public final Set<String> com$datastax$spark$connector$demo$streaming$NodeGuardian$$data;
    private final Timeout timeout;
    private final String actorName;
    private final ActorSystem sas;
    private final ActorRef com$datastax$spark$connector$demo$streaming$NodeGuardian$$reporter;
    private final ReceiverInputDStream<String> stream;
    private transient Logger com$datastax$spark$connector$util$Logging$$log_;
    private Duration com$datastax$spark$connector$embedded$Assertions$$end;
    private final ActorContext context;
    private final ActorRef self;

    public Logger com$datastax$spark$connector$util$Logging$$log_() {
        return this.com$datastax$spark$connector$util$Logging$$log_;
    }

    public void com$datastax$spark$connector$util$Logging$$log__$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ClassLoader getSparkClassLoader() {
        return Logging.class.getSparkClassLoader((Logging)this);
    }

    public Duration com$datastax$spark$connector$embedded$Assertions$$end() {
        return this.com$datastax$spark$connector$embedded$Assertions$$end;
    }

    public void com$datastax$spark$connector$embedded$Assertions$$end_$eq(Duration x$1) {
        this.com$datastax$spark$connector$embedded$Assertions$$end = x$1;
    }

    public FiniteDuration now() {
        return Assertions.class.now((Assertions)this);
    }

    public FiniteDuration remainingOrDefault() {
        return Assertions.class.remainingOrDefault((Assertions)this);
    }

    public FiniteDuration remainingOr(FiniteDuration duration) {
        return Assertions.class.remainingOr((Assertions)this, (FiniteDuration)duration);
    }

    public void awaitCond(Function0<Object> p, Duration max, Duration interval, String message) {
        Assertions.class.awaitCond((Assertions)this, p, (Duration)max, (Duration)interval, (String)message);
    }

    public Duration awaitCond$default$2() {
        return Assertions.class.awaitCond$default$2((Assertions)this);
    }

    public Duration awaitCond$default$3() {
        return Assertions.class.awaitCond$default$3((Assertions)this);
    }

    public String awaitCond$default$4() {
        return Assertions.class.awaitCond$default$4((Assertions)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.class.preStart((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.class.postStop((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public Timeout timeout() {
        return this.timeout;
    }

    private String actorName() {
        return this.actorName;
    }

    private ActorSystem sas() {
        return this.sas;
    }

    public ActorRef com$datastax$spark$connector$demo$streaming$NodeGuardian$$reporter() {
        return this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$reporter;
    }

    private ReceiverInputDStream<String> stream() {
        return this.stream;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeGuardian $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingEvent.ReceiverStarted) {
                    StreamingEvent.ReceiverStarted receiverStarted = (StreamingEvent.ReceiverStarted)A1;
                    ActorRef receiver = receiverStarted.ref();
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Streaming actor located: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receiver})));
                    this.$outer.context().watch(receiver);
                    this.$outer.context().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this, receiver){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$receive$1 $outer;
                        private final ActorRef receiver$1;

                        public final Sender apply() {
                            return new Sender((String[])this.$outer.com$datastax$spark$connector$demo$streaming$NodeGuardian$$anonfun$$$outer().com$datastax$spark$connector$demo$streaming$NodeGuardian$$data.toArray(ClassTag$.MODULE$.apply(String.class)), this.receiver$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.receiver$1 = receiver$1;
                        }
                    }, ClassTag$.MODULE$.apply(Sender.class)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Terminated) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Streaming actor work completed and shutdown. Starting validation."})).s((Seq)Nil$.MODULE$));
                    package$.MODULE$.actorRef2Scala(this.$outer.com$datastax$spark$connector$demo$streaming$NodeGuardian$$reporter()).$bang((Object)StreamingEvent$Report$.MODULE$, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    StreamingEvent$Completed$ streamingEvent$Completed$ = StreamingEvent$Completed$.MODULE$;
                    A1 A12 = A1;
                    if (!(streamingEvent$Completed$ != null ? !streamingEvent$Completed$.equals(A12) : A12 != null)) {
                        this.$outer.shutdown();
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl;
                Object object = x1;
                if (object instanceof StreamingEvent.ReceiverStarted) {
                    bl = true;
                } else if (object instanceof Terminated) {
                    bl = true;
                } else {
                    StreamingEvent$Completed$ streamingEvent$Completed$ = StreamingEvent$Completed$.MODULE$;
                    Object object2 = object;
                    bl = !(streamingEvent$Completed$ != null ? !streamingEvent$Completed$.equals(object2) : object2 != null);
                }
                return bl;
            }

            public /* synthetic */ NodeGuardian com$datastax$spark$connector$demo$streaming$NodeGuardian$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void shutdown() {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assertions successful, shutting down."})).s((Seq)Nil$.MODULE$));
        this.context().system().eventStream().unsubscribe(this.self());
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping the demo app actor system and '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$ssc})));
        this.context().system().shutdown();
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$ssc.stop(true, false);
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$ssc.awaitTermination();
    }

    public NodeGuardian(StreamingContext ssc, SparkCassandraSettings settings, String tableName, Set<String> data) {
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$ssc = ssc;
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$tableName = tableName;
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$data = data;
        Actor.class.$init$((Actor)this);
        Assertions.class.$init$((Assertions)this);
        Logging.class.$init$((Logging)this);
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
        this.actorName = "stream";
        this.sas = SparkEnv$.MODULE$.get().actorSystem();
        this.sas().eventStream().subscribe(this.self(), StreamingEvent.ReceiverStarted.class);
        this.com$datastax$spark$connector$demo$streaming$NodeGuardian$$reporter = this.context().actorOf(Props$.MODULE$.apply((Function0)new $anonfun$5(this), ClassTag$.MODULE$.apply(Reporter.class)), "reporter");
        this.stream = ssc.actorStream(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(Streamer.class)), this.actorName(), StorageLevel$.MODULE$.MEMORY_AND_DISK(), ssc.actorStream$default$4(), ClassTag$.MODULE$.apply(String.class));
        com.datastax.spark.connector.streaming.package$.MODULE$.toDStreamFunctions(StreamingContext$.MODULE$.toPairDStreamFunctions(this.stream().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<String> apply(String x$1) {
                return Predef$.MODULE$.wrapRefArray((Object[])x$1.split("\\s+"));
            }
        }, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String x) {
                return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$2, int x$3) {
                return this.apply$mcIII$sp(x$2, x$3);
            }

            public int apply$mcIII$sp(int x$2, int x$3) {
                return x$2 + x$3;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class)).saveToCassandra("streaming_test", "words", new SomeColumns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "count"})), 1, RowWriterFactory$.MODULE$.defaultRowWriterFactory(ClassTag$.MODULE$.apply(Tuple2.class), (ColumnMapper)ColumnMapper$.MODULE$.tuple2ColumnMapper()));
        ssc.start();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming context started."})).s((Seq)Nil$.MODULE$));
    }
}

