/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.demo;

import com.datastax.spark.connector.CassandraJavaUtil;
import com.datastax.spark.connector.CassandraRow;
import com.datastax.spark.connector.demo.DemoApp;
import com.datastax.spark.connector.demo.DemoApp$;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class JavaApiDemo
implements Serializable {
    public JavaApiDemo() {
        DemoApp demoApp = DemoApp$.MODULE$.apply();
        JavaSparkContext javaSparkContext = new JavaSparkContext(demoApp.sc());
        List<Person> list = Arrays.asList(Person.newInstance(1, "John", new Date()), Person.newInstance(2, "Anna", new Date()), Person.newInstance(3, "Andrew", new Date()));
        JavaRDD javaRDD = javaSparkContext.parallelize(list);
        CassandraJavaUtil.javaFunctions((JavaRDD)javaRDD, Person.class).saveToCassandra("test", "people");
        JavaRDD javaRDD2 = CassandraJavaUtil.javaFunctions((JavaSparkContext)javaSparkContext).cassandraTable("test", "people").map((Function)new Function<CassandraRow, String>(){

            public String call(CassandraRow cassandraRow) throws Exception {
                return cassandraRow.toString();
            }
        });
        System.out.println("Data as CassandraRows: \n" + StringUtils.join((CharSequence)"\n", (Iterable)javaRDD2.toArray()));
        JavaRDD javaRDD3 = CassandraJavaUtil.javaFunctions((JavaSparkContext)javaSparkContext).cassandraTable("test", "people", Person.class).map((Function)new Function<Person, String>(){

            public String call(Person person) throws Exception {
                return person.toString();
            }
        });
        System.out.println("Data as Person beans: \n" + StringUtils.join((CharSequence)"\n", (Iterable)javaRDD3.toArray()));
        JavaRDD javaRDD4 = CassandraJavaUtil.javaFunctions((JavaSparkContext)javaSparkContext).cassandraTable("test", "people", Person.class).where("name=?", new Object[]{"Anna"}).map((Function)new Function<Person, String>(){

            public String call(Person person) throws Exception {
                return person.toString();
            }
        });
        System.out.println("Data filtered by the where clause (name='Anna'): \n" + StringUtils.join((CharSequence)"\n", (Iterable)javaRDD4.toArray()));
        JavaRDD javaRDD5 = CassandraJavaUtil.javaFunctions((JavaSparkContext)javaSparkContext).cassandraTable("test", "people").select(new String[]{"id"}).map((Function)new Function<CassandraRow, String>(){

            public String call(CassandraRow cassandraRow) throws Exception {
                return cassandraRow.toString();
            }
        });
        System.out.println("Data with only 'id' column fetched: \n" + StringUtils.join((CharSequence)"\n", (Iterable)javaRDD5.toArray()));
        javaSparkContext.stop();
    }

    public static void main(String[] stringArray) {
        new JavaApiDemo();
    }

    public static class Person
    implements Serializable {
        private Integer id;
        private String name;
        private Date birthDate;

        public static Person newInstance(Integer n, String string, Date date) {
            Person person = new Person();
            person.setId(n);
            person.setName(string);
            person.setBirthDate(date);
            return person;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n) {
            this.id = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Date getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(Date date) {
            this.birthDate = date;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("birthDate", (Object)this.birthDate).toString();
        }
    }
}

