/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.test;

import com.datastax.oss.quarkus.test.SkipIfNotAmd64;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class CheckAmd64Condition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional optional = AnnotationUtils.findAnnotation((Optional)context.getElement(), SkipIfNotAmd64.class);
        return optional.map(ann -> {
            String archStr = System.getProperty("os.arch");
            return archStr.equals("amd64") ? ConditionEvaluationResult.enabled((String)"amd64 architecture found") : ConditionEvaluationResult.disabled((String)String.format("{} architecture found, skipping test", archStr));
        }).orElse(ConditionEvaluationResult.enabled((String)"No annotation, not checking platform"));
    }
}

