/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.test;

import com.datastax.driver.core.Host;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.wait.CassandraQueryWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.google.common.base.Splitter;
import org.testcontainers.utility.DockerImageName;

public class CassandraTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String QUARKUS_CASSANDRA_CONTAINER_IMAGE_KEY = "quarkus.cassandra.test.container.image";
    public static final String QUARKUS_CASSANDRA_CONTAINER_ENV_KEY = "quarkus.cassandra.test.container.env-vars";
    public static final String QUARKUS_CASSANDRA_CONTAINER_CMD_KEY = "quarkus.cassandra.test.container.cmd";
    public static final String QUARKUS_CASSANDRA_CONTAINER_JVM_OPTS_KEY = "quarkus.cassandra.test.container.jvm-opts";
    public static final String QUARKUS_CASSANDRA_CONTAINER_STARTUP_TIMEOUT_KEY = "quarkus.cassandra.test.container.startup-timeout";
    private static final String QUARKUS_CASSANDRA_CONTAINER_IMAGE_DEFAULT = "cassandra:latest";
    private static final String QUARKUS_CASSANDRA_CONTAINER_ENV_DEFAULT = "CASSANDRA_SNITCH = PropertyFileSnitch, HEAP_NEWSIZE = 128M, MAX_HEAP_SIZE = 1024M, DS_LICENSE = accept";
    private static final String QUARKUS_CASSANDRA_CONTAINER_JVM_OPTS_DEFAULT = "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.num_tokens=1 -Dcassandra.initial_token=0";
    private static final String QUARKUS_CASSANDRA_CONTACT_POINTS = "quarkus.cassandra.contact-points";
    private static final String QUARKUS_CASSANDRA_LOCAL_DATACENTER = "quarkus.cassandra.local-datacenter";
    private static final Splitter.MapSplitter ENV_ENTRIES_SPLITTER = Splitter.on((String)",").trimResults().withKeyValueSeparator(Splitter.on((String)"=").trimResults());
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTestResource.class);
    private volatile CassandraContainer<?> cassandraContainer;

    public void init(Map<String, String> initArgs) {
        String image = initArgs.getOrDefault(QUARKUS_CASSANDRA_CONTAINER_IMAGE_KEY, QUARKUS_CASSANDRA_CONTAINER_IMAGE_DEFAULT);
        DockerImageName dockerImage = DockerImageName.parse((String)image).asCompatibleSubstituteFor("cassandra");
        String envString = initArgs.getOrDefault(QUARKUS_CASSANDRA_CONTAINER_ENV_KEY, QUARKUS_CASSANDRA_CONTAINER_ENV_DEFAULT);
        HashMap<String, String> env = new HashMap<String, String>(ENV_ENTRIES_SPLITTER.split((CharSequence)envString));
        String jvmOptionsString = initArgs.getOrDefault(QUARKUS_CASSANDRA_CONTAINER_JVM_OPTS_KEY, QUARKUS_CASSANDRA_CONTAINER_JVM_OPTS_DEFAULT);
        env.put("JVM_OPTS", jvmOptionsString);
        this.cassandraContainer = (CassandraContainer)new CassandraContainer(dockerImage).withEnv(env);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("init_script.cql");
        if (resource != null) {
            this.cassandraContainer.withInitScript("init_script.cql");
        }
        CassandraQueryWaitStrategy waitStrategy = new CassandraQueryWaitStrategy();
        String startupTimeout = initArgs.get(QUARKUS_CASSANDRA_CONTAINER_STARTUP_TIMEOUT_KEY);
        if (startupTimeout != null) {
            waitStrategy.withStartupTimeout(Duration.parse(startupTimeout));
        }
        this.cassandraContainer.setWaitStrategy((WaitStrategy)waitStrategy);
        String cmd = initArgs.get(QUARKUS_CASSANDRA_CONTAINER_CMD_KEY);
        if (cmd != null) {
            this.cassandraContainer.setCommand(cmd);
        }
    }

    public Map<String, String> start() {
        LOGGER.info("Container {} starting...", (Object)this.cassandraContainer.getDockerImageName());
        this.cassandraContainer.start();
        String contactPoint = this.getContactPoint();
        String localDc = this.getLocalDatacenter();
        if (localDc != null) {
            LOGGER.info("Container {} listening on {} (inferred local DC: {})", new Object[]{this.cassandraContainer.getDockerImageName(), contactPoint, localDc});
            return Map.of(QUARKUS_CASSANDRA_CONTACT_POINTS, contactPoint, QUARKUS_CASSANDRA_LOCAL_DATACENTER, localDc);
        }
        LOGGER.info("Container {} listening on {}", (Object)this.cassandraContainer.getDockerImageName(), (Object)contactPoint);
        return Map.of(QUARKUS_CASSANDRA_CONTACT_POINTS, contactPoint);
    }

    public void stop() {
        if (this.cassandraContainer != null && this.cassandraContainer.isRunning()) {
            LOGGER.info("Container {} stopping...", (Object)this.cassandraContainer.getDockerImageName());
            this.cassandraContainer.stop();
            LOGGER.info("Container {} stopped", (Object)this.cassandraContainer.getDockerImageName());
        }
    }

    private String getContactPoint() {
        String host = this.cassandraContainer.getHost();
        if (host.equals("localhost")) {
            host = "127.0.0.1";
        }
        int port = this.cassandraContainer.getMappedPort(CassandraContainer.CQL_PORT.intValue());
        return host + ":" + port;
    }

    private String getLocalDatacenter() {
        for (Host host : this.cassandraContainer.getCluster().getMetadata().getAllHosts()) {
            String dc = host.getDatacenter();
            if (dc == null) continue;
            return dc;
        }
        LOGGER.warn("Could not determine local datacenter for container {}", (Object)this.cassandraContainer.getDockerImageName());
        return null;
    }
}

