/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.test;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.wait.CassandraQueryWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CassandraTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTestResource.class);
    private static CassandraContainer<?> cassandraContainer;

    public Map<String, String> start() {
        cassandraContainer = new CassandraContainer(DockerImageName.parse((String)"cassandra").withTag("3.11.2"));
        URL resource = Thread.currentThread().getContextClassLoader().getResource("init_script.cql");
        if (resource != null) {
            cassandraContainer.withInitScript("init_script.cql");
        }
        cassandraContainer.setWaitStrategy((WaitStrategy)new CassandraQueryWaitStrategy());
        cassandraContainer.start();
        String exposedPort = String.valueOf(cassandraContainer.getMappedPort(CassandraContainer.CQL_PORT.intValue()));
        String exposedHost = cassandraContainer.getContainerIpAddress();
        if (exposedHost.equals("localhost")) {
            exposedHost = "127.0.0.1";
        }
        LOGGER.info("Started {} on {}:{}", new Object[]{cassandraContainer.getDockerImageName(), exposedHost, exposedPort});
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("quarkus.cassandra.docker_host", exposedHost);
        result.put("quarkus.cassandra.docker_port", exposedPort);
        return result;
    }

    public void stop() {
        if (cassandraContainer != null && cassandraContainer.isRunning()) {
            cassandraContainer.stop();
        }
    }
}

