package com.datastax.oss.quarkus.demo;

import com.datastax.oss.quarkus.runtime.api.mapper.QuarkusGeneratedDaoBean;
import com.datastax.oss.quarkus.runtime.api.mapper.QuarkusGeneratedMapperBean;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import io.quarkus.arc.DefaultBean;
import io.smallrye.mutiny.Uni;
import java.lang.InterruptedException;
import java.lang.SuppressWarnings;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

/**
 * A DAO bean producer for DAO factory methods declared in {@link FruitMapper}.
 *
 * <p>Generated by the DataStax driver mapper, do not edit directly.
 */
@Generated(
    value = "com.datastax.oss.quarkus.internal.mapper.processor.QuarkusMapperGenerator",
    date = "2021-03-26T10:23:14.253Z"
)
@SuppressWarnings("all")
public class FruitMapperProducer {
  private final CompletionStage<QuarkusCqlSession> sessionStage;

  private final CompletionStage<FruitMapper> mapperStage;

  @Inject
  public FruitMapperProducer(CompletionStage<QuarkusCqlSession> sessionStage) {
    this.sessionStage = sessionStage;
    mapperStage = sessionStage.thenApply(session -> new FruitMapperBuilder(session).build());
  }

  @Produces
  @ApplicationScoped
  @Default
  @DefaultBean
  @QuarkusGeneratedMapperBean
  public CompletionStage<FruitMapper> produceFruitMapperAsync() {
    return mapperStage;
  }

  @Produces
  @ApplicationScoped
  @Default
  @DefaultBean
  @QuarkusGeneratedMapperBean
  public FruitMapper produceFruitMapperSync() throws ExecutionException, InterruptedException {
    return mapperStage.toCompletableFuture().get();
  }

  @Produces
  @ApplicationScoped
  @Default
  @DefaultBean
  @QuarkusGeneratedMapperBean
  public Uni<FruitMapper> produceFruitMapperReactive() {
    return Uni.createFrom().completionStage(produceFruitMapperAsync());
  }

  @Produces
  @ApplicationScoped
  @DefaultBean
  @Default
  @QuarkusGeneratedDaoBean
  public FruitDao produceFruitDao() throws ExecutionException, InterruptedException {
    return mapperStage.toCompletableFuture().get().fruitDao();
  }

  @Produces
  @ApplicationScoped
  @DefaultBean
  @Default
  @QuarkusGeneratedDaoBean
  public ReactiveFruitDao produceReactiveFruitDao() throws ExecutionException,
      InterruptedException {
    return mapperStage.toCompletableFuture().get().reactiveFruitDao();
  }
}
