/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.utils;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(NodeUtils.class);
    private static final int TEST_BASE_NODE_WAIT = 60;

    public static void waitForUp(Node node) {
        NodeUtils.waitFor(node, 60, NodeState.UP);
    }

    public static void waitForUp(Node node, int timeoutSeconds) {
        NodeUtils.waitFor(node, timeoutSeconds, NodeState.UP);
    }

    public static void waitForDown(Node node) {
        NodeUtils.waitFor(node, 180, NodeState.DOWN);
    }

    public static void waitForDown(Node node, int timeoutSeconds) {
        NodeUtils.waitFor(node, timeoutSeconds, NodeState.DOWN);
    }

    public static void waitFor(Node node, int timeoutSeconds, NodeState nodeState) {
        logger.debug("Waiting for node {} to enter state {}", (Object)node, (Object)nodeState);
        Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost((long)timeoutSeconds, TimeUnit.SECONDS).until(() -> node.getState().equals((Object)nodeState));
    }
}

