/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.session;

import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.session.SessionRule;

public abstract class SessionRuleBuilder<SelfT extends SessionRuleBuilder<SelfT, SessionT>, SessionT extends Session> {
    protected final CassandraResourceRule cassandraResource;
    protected boolean createKeyspace = true;
    protected NodeStateListener nodeStateListener;
    protected SchemaChangeListener schemaChangeListener;
    protected DriverConfigLoader loader;
    protected boolean createGraph;
    protected boolean isCoreGraph;
    protected String graphProtocol;
    protected final SelfT self = this;

    public SessionRuleBuilder(CassandraResourceRule cassandraResource) {
        this.cassandraResource = cassandraResource;
    }

    public SelfT withKeyspace(boolean createKeyspace) {
        this.createKeyspace = createKeyspace;
        return this.self;
    }

    public SelfT withConfigLoader(DriverConfigLoader loader) {
        this.loader = loader;
        return this.self;
    }

    public SelfT withNodeStateListener(NodeStateListener listener) {
        this.nodeStateListener = listener;
        return this.self;
    }

    public SelfT withSchemaChangeListener(SchemaChangeListener listener) {
        this.schemaChangeListener = listener;
        return this.self;
    }

    public SelfT withCreateGraph() {
        this.createGraph = true;
        return this.self;
    }

    public SelfT withCoreEngine() {
        this.isCoreGraph = true;
        return this.self;
    }

    public SelfT withGraphProtocol(String graphProtocol) {
        this.graphProtocol = graphProtocol;
        return this.self;
    }

    public abstract SessionRule<SessionT> build();
}

