/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ScheduledTaskCapturingEventLoop
extends DefaultEventLoop {
    private final BlockingQueue<CapturedTask> capturedTasks = new ArrayBlockingQueue<CapturedTask>(100);

    public ScheduledTaskCapturingEventLoop(EventLoopGroup parent) {
        super(parent);
    }

    @NonNull
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        CapturedTask<V> task = new CapturedTask<V>(callable, delay, unit);
        boolean added = this.capturedTasks.offer(task);
        Assertions.assertThat((boolean)added).isTrue();
        return ((CapturedTask)task).scheduledFuture;
    }

    @NonNull
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedule(() -> {
            command.run();
            return null;
        }, delay, unit);
    }

    @NonNull
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        CapturedTask<Object> task = new CapturedTask<Object>(() -> {
            command.run();
            return null;
        }, initialDelay, period, unit);
        boolean added = this.capturedTasks.offer(task);
        Assertions.assertThat((boolean)added).isTrue();
        return ((CapturedTask)task).scheduledFuture;
    }

    @NonNull
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public CapturedTask<?> nextTask() {
        try {
            return this.capturedTasks.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Unexpected interruption", (Throwable)e);
            throw new AssertionError();
        }
    }

    public void waitForNonScheduledTasks() {
        ScheduledFuture f = super.schedule(() -> null, 5L, TimeUnit.NANOSECONDS);
        try {
            Uninterruptibles.getUninterruptibly((Future)f, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Assertions.fail((String)"unexpected error", (Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"timed out while waiting for admin tasks to complete", (Throwable)e);
        }
    }

    public class CapturedTask<V> {
        private final FutureTask<V> futureTask;
        private final long initialDelay;
        private final long period;
        private final TimeUnit unit;
        private final ScheduledFuture<V> scheduledFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);

        CapturedTask(Callable<V> task, long initialDelay, TimeUnit unit) {
            this(task, initialDelay, -1L, unit);
        }

        CapturedTask(Callable<V> task, long initialDelay, long period, TimeUnit unit) {
            this.futureTask = new FutureTask<V>(task);
            this.initialDelay = initialDelay;
            this.period = period;
            this.unit = unit;
            Mockito.when((Object)this.scheduledFuture.cancel(ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> this.futureTask.cancel((Boolean)invocation.getArgument(0)));
            Mockito.when((Object)this.scheduledFuture.isDone()).thenAnswer(invocation -> this.futureTask.isDone());
            Mockito.when((Object)this.scheduledFuture.isCancelled()).thenAnswer(invocation -> this.futureTask.isCancelled());
        }

        public void run() {
            ScheduledTaskCapturingEventLoop.this.submit(this.futureTask);
            ScheduledTaskCapturingEventLoop.this.waitForNonScheduledTasks();
        }

        public boolean isCancelled() {
            try {
                this.futureTask.get(3L, TimeUnit.SECONDS);
            }
            catch (CancellationException e) {
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public long getInitialDelay(TimeUnit targetUnit) {
            return targetUnit.convert(this.initialDelay, this.unit);
        }

        public long getPeriod(TimeUnit targetUnit) {
            return targetUnit.convert(this.period, this.unit);
        }
    }
}

