/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;

public class CapturingTimer
implements Timer {
    private final ArrayBlockingQueue<CapturedTimeout> timeoutQueue = new ArrayBlockingQueue(16);

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        CapturedTimeout timeout = new CapturedTimeout(task, this, delay, unit);
        this.timeoutQueue.add(timeout);
        return timeout;
    }

    public CapturedTimeout getNextTimeout() {
        try {
            return this.timeoutQueue.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            Assertions.fail((String)"Unexpected interruption", (Throwable)ie);
            throw new AssertionError();
        }
    }

    public Set<Timeout> stop() {
        if (this.timeoutQueue.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Timeout> timeoutsRemaining = new HashSet<Timeout>(this.timeoutQueue.size());
        for (Timeout timeout : this.timeoutQueue) {
            if (timeout == null) continue;
            timeout.cancel();
            timeoutsRemaining.add(timeout);
        }
        return timeoutsRemaining;
    }

    public static class CapturedTimeout
    implements Timeout {
        private final TimerTask task;
        private final CapturingTimer timer;
        private final long delay;
        private final TimeUnit unit;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private CapturedTimeout(TimerTask task, CapturingTimer timer, long delay, TimeUnit unit) {
            this.task = task;
            this.timer = timer;
            this.delay = delay;
            this.unit = unit;
        }

        public Timer timer() {
            return this.timer;
        }

        public TimerTask task() {
            return this.task;
        }

        public long getDelay(TimeUnit targetUnit) {
            return targetUnit.convert(this.delay, this.unit);
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }

        public boolean cancel() {
            return this.cancelled.compareAndSet(false, true);
        }
    }
}

