/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.collection;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import java.util.Iterator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryPlanTest {
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;

    @Test
    public void should_poll_elements() {
        QueryPlan queryPlan = new QueryPlan(new Object[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Object)queryPlan.poll()).isSameAs((Object)this.node1);
        Assertions.assertThat((Object)queryPlan.poll()).isSameAs((Object)this.node2);
        Assertions.assertThat((Object)queryPlan.poll()).isSameAs((Object)this.node3);
        Assertions.assertThat((Object)queryPlan.poll()).isNull();
        Assertions.assertThat((Object)queryPlan.poll()).isNull();
    }

    @Test
    public void should_return_size() {
        QueryPlan queryPlan = new QueryPlan(new Object[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(3);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(2);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(1);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(0);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(0);
    }

    @Test
    public void should_return_iterator() {
        QueryPlan queryPlan = new QueryPlan(new Object[]{this.node1, this.node2, this.node3});
        Iterator iterator3 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator2 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator1 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator0 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator00 = queryPlan.iterator();
        Assertions.assertThat((Iterator)iterator3).toIterable().containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterator)iterator2).toIterable().containsExactly((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((Iterator)iterator1).toIterable().containsExactly((Object[])new Node[]{this.node3});
        Assertions.assertThat((Iterator)iterator0).toIterable().isEmpty();
        Assertions.assertThat((Iterator)iterator00).toIterable().isEmpty();
    }
}

