/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.internal.core.type.codec.CqlIntToStringCodec;
import com.datastax.oss.driver.internal.core.type.codec.ListCodec;
import com.datastax.oss.driver.internal.core.type.codec.registry.CachingCodecRegistry;
import com.datastax.oss.driver.internal.core.type.codec.registry.CodecRegistryConstants;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CachingCodecRegistryTest {
    @Mock
    private TestCachingCodecRegistry.MockCache mockCache;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void should_find_primitive_codecs_for_types() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.BOOLEAN);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.TINYINT);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.DOUBLE);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.COUNTER);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.FLOAT);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.INT);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.BIGINT);
        this.checkPrimitiveMappings(registry, (TypeCodec<?>)TypeCodecs.SMALLINT);
        this.checkPrimitiveMappings(registry, TypeCodecs.TIMESTAMP);
        this.checkPrimitiveMappings(registry, TypeCodecs.DATE);
        this.checkPrimitiveMappings(registry, TypeCodecs.TIME);
        this.checkPrimitiveMappings(registry, TypeCodecs.BLOB);
        this.checkPrimitiveMappings(registry, TypeCodecs.TEXT);
        this.checkPrimitiveMappings(registry, TypeCodecs.ASCII);
        this.checkPrimitiveMappings(registry, TypeCodecs.VARINT);
        this.checkPrimitiveMappings(registry, TypeCodecs.DECIMAL);
        this.checkPrimitiveMappings(registry, TypeCodecs.UUID);
        this.checkPrimitiveMappings(registry, TypeCodecs.TIMEUUID);
        this.checkPrimitiveMappings(registry, TypeCodecs.INET);
        this.checkPrimitiveMappings(registry, TypeCodecs.DURATION);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    private void checkPrimitiveMappings(TestCachingCodecRegistry registry, TypeCodec<?> codec) {
        DataType cqlType = codec.getCqlType();
        GenericType javaType = codec.getJavaType();
        Assertions.assertThat((Object)registry.codecFor(cqlType, javaType)).isSameAs(codec);
        Assertions.assertThat((Object)registry.codecFor(cqlType)).isSameAs(codec);
        Assertions.assertThat((Object)javaType.__getToken().getType()).isInstanceOf(Class.class);
        Class javaClass = (Class)javaType.__getToken().getType();
        Assertions.assertThat((Object)registry.codecFor(cqlType, javaClass)).isSameAs(codec);
    }

    @Test
    public void should_find_primitive_codecs_for_value() throws Exception {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        Assertions.assertThat((Object)registry.codecFor(true)).isEqualTo((Object)TypeCodecs.BOOLEAN);
        Assertions.assertThat((Object)registry.codecFor((byte)0)).isEqualTo((Object)TypeCodecs.TINYINT);
        Assertions.assertThat((Object)registry.codecFor(0.0)).isEqualTo((Object)TypeCodecs.DOUBLE);
        Assertions.assertThat((Object)registry.codecFor(Float.valueOf(0.0f))).isEqualTo((Object)TypeCodecs.FLOAT);
        Assertions.assertThat((Object)registry.codecFor(0)).isEqualTo((Object)TypeCodecs.INT);
        Assertions.assertThat((Object)registry.codecFor(0L)).isEqualTo((Object)TypeCodecs.BIGINT);
        Assertions.assertThat((Object)registry.codecFor((short)0)).isEqualTo((Object)TypeCodecs.SMALLINT);
        Assertions.assertThat((Object)registry.codecFor(Instant.EPOCH)).isEqualTo((Object)TypeCodecs.TIMESTAMP);
        Assertions.assertThat((Object)registry.codecFor(LocalDate.MIN)).isEqualTo((Object)TypeCodecs.DATE);
        Assertions.assertThat((Object)registry.codecFor(LocalTime.MIDNIGHT)).isEqualTo((Object)TypeCodecs.TIME);
        Assertions.assertThat((Object)registry.codecFor(ByteBuffer.allocate(0))).isEqualTo((Object)TypeCodecs.BLOB);
        Assertions.assertThat((Object)registry.codecFor("")).isEqualTo((Object)TypeCodecs.TEXT);
        Assertions.assertThat((Object)registry.codecFor(BigInteger.ONE)).isEqualTo((Object)TypeCodecs.VARINT);
        Assertions.assertThat((Object)registry.codecFor(BigDecimal.ONE)).isEqualTo((Object)TypeCodecs.DECIMAL);
        Assertions.assertThat((Object)registry.codecFor(new UUID(2L, 1L))).isEqualTo((Object)TypeCodecs.UUID);
        Assertions.assertThat((Object)registry.codecFor(InetAddress.getByName("127.0.0.1"))).isEqualTo((Object)TypeCodecs.INET);
        Assertions.assertThat((Object)registry.codecFor(CqlDuration.newInstance((int)1, (int)2, (long)3L))).isEqualTo((Object)TypeCodecs.DURATION);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_find_primitive_codecs_for_cql_type_and_value() throws Exception {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.BOOLEAN, true)).isEqualTo((Object)TypeCodecs.BOOLEAN);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TINYINT, (byte)0)).isEqualTo((Object)TypeCodecs.TINYINT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.DOUBLE, 0.0)).isEqualTo((Object)TypeCodecs.DOUBLE);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.FLOAT, Float.valueOf(0.0f))).isEqualTo((Object)TypeCodecs.FLOAT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, 0)).isEqualTo((Object)TypeCodecs.INT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.BIGINT, 0L)).isEqualTo((Object)TypeCodecs.BIGINT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.SMALLINT, (short)0)).isEqualTo((Object)TypeCodecs.SMALLINT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TIMESTAMP, Instant.EPOCH)).isEqualTo((Object)TypeCodecs.TIMESTAMP);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.DATE, LocalDate.MIN)).isEqualTo((Object)TypeCodecs.DATE);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TIME, LocalTime.MIDNIGHT)).isEqualTo((Object)TypeCodecs.TIME);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.BLOB, ByteBuffer.allocate(0))).isEqualTo((Object)TypeCodecs.BLOB);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, "")).isEqualTo((Object)TypeCodecs.TEXT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.VARINT, BigInteger.ONE)).isEqualTo((Object)TypeCodecs.VARINT);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.DECIMAL, BigDecimal.ONE)).isEqualTo((Object)TypeCodecs.DECIMAL);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.UUID, new UUID(2L, 1L))).isEqualTo((Object)TypeCodecs.UUID);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INET, InetAddress.getByName("127.0.0.1"))).isEqualTo((Object)TypeCodecs.INET);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.DURATION, CqlDuration.newInstance((int)1, (int)2, (long)3L))).isEqualTo((Object)TypeCodecs.DURATION);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_find_user_codec_for_built_in_java_type() {
        CqlIntToStringCodec intToStringCodec1 = new CqlIntToStringCodec();
        CqlIntToStringCodec intToStringCodec2 = new CqlIntToStringCodec();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, intToStringCodec1, intToStringCodec2);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, GenericType.STRING)).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, String.class)).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, "")).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT)).isSameAs((Object)TypeCodecs.INT);
        Assertions.assertThat((Object)registry.codecFor("")).isSameAs((Object)TypeCodecs.TEXT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_find_user_codec_for_custom_java_type() {
        TextToPeriodCodec textToPeriodCodec1 = new TextToPeriodCodec();
        TextToPeriodCodec textToPeriodCodec2 = new TextToPeriodCodec();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, textToPeriodCodec1, textToPeriodCodec2);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, GenericType.of(Period.class))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, Period.class)).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, Period.ofDays(1))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(Period.ofDays(1))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT)).isSameAs((Object)TypeCodecs.TEXT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_create_list_codec_for_cql_and_java_types() {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT));
        GenericType<List<List<Integer>>> javaType = new GenericType<List<List<Integer>>>(){};
        ImmutableList value = ImmutableList.of((Object)ImmutableList.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, (GenericType)javaType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.listOf((DataType)DataTypes.INT), GenericType.listOf((GenericType)GenericType.INTEGER), false);
    }

    @Test
    public void should_create_list_codec_for_cql_type() {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT));
        GenericType<List<List<Integer>>> javaType = new GenericType<List<List<Integer>>>(){};
        ImmutableList value = ImmutableList.of((Object)ImmutableList.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, null, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.listOf((DataType)DataTypes.INT), null, false);
    }

    @Test
    public void should_create_list_codec_for_cql_type_and_java_value() {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT));
        GenericType<List<List<Integer>>> javaType = new GenericType<List<List<Integer>>>(){};
        ImmutableList value = ImmutableList.of((Object)ImmutableList.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.listOf((DataType)DataTypes.INT), GenericType.listOf((GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_list_codec_for_java_value() {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT));
        GenericType<List<List<Integer>>> javaType = new GenericType<List<List<Integer>>>(){};
        ImmutableList value = ImmutableList.of((Object)ImmutableList.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf((GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_list_codec_for_empty_java_value() {
        GenericType javaType = GenericType.listOf((GenericType)GenericType.listOf(Boolean.class));
        List value = Collections.singletonList(Collections.emptyList());
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
    }

    @Test
    public void should_create_list_codec_for_cql_type_and_empty_java_value() {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT));
        GenericType javaType = GenericType.listOf((GenericType)GenericType.listOf((GenericType)GenericType.INTEGER));
        List value = Collections.singletonList(Collections.emptyList());
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
    }

    @Test
    public void should_create_list_codec_for_java_value_when_first_element_is_a_subtype() throws UnknownHostException {
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.INET);
        GenericType<List<InetAddress>> javaType = new GenericType<List<InetAddress>>(){};
        InetAddress address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        Assertions.assertThat((Object)address).isInstanceOf(Inet4Address.class);
        ImmutableList value = ImmutableList.of((Object)address);
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf(Inet4Address.class), true);
    }

    @Test
    public void should_create_set_codec_for_cql_and_java_types() {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT));
        GenericType<Set<Set<Integer>>> javaType = new GenericType<Set<Set<Integer>>>(){};
        ImmutableSet value = ImmutableSet.of((Object)ImmutableSet.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, (GenericType)javaType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.setOf((DataType)DataTypes.INT), GenericType.setOf((GenericType)GenericType.INTEGER), false);
    }

    @Test
    public void should_create_set_codec_for_cql_type() {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT));
        GenericType<Set<Set<Integer>>> javaType = new GenericType<Set<Set<Integer>>>(){};
        ImmutableSet value = ImmutableSet.of((Object)ImmutableSet.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, null, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.setOf((DataType)DataTypes.INT), null, false);
    }

    @Test
    public void should_create_set_codec_for_cql_type_and_java_value() {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT));
        GenericType<Set<Set<Integer>>> javaType = new GenericType<Set<Set<Integer>>>(){};
        ImmutableSet value = ImmutableSet.of((Object)ImmutableSet.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.setOf((DataType)DataTypes.INT), GenericType.setOf((GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_set_codec_for_java_value() {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT));
        GenericType<Set<Set<Integer>>> javaType = new GenericType<Set<Set<Integer>>>(){};
        ImmutableSet value = ImmutableSet.of((Object)ImmutableSet.of((Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.setOf((GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_set_codec_for_empty_java_value() {
        GenericType javaType = GenericType.setOf((GenericType)GenericType.setOf(Boolean.class));
        Set value = Collections.singleton(Collections.emptySet());
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
    }

    @Test
    public void should_create_set_codec_for_cql_type_and_empty_java_value() {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT));
        GenericType javaType = GenericType.setOf((GenericType)GenericType.setOf(Integer.class));
        Set value = Collections.emptySet();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
    }

    @Test
    public void should_create_set_codec_for_java_value_when_first_element_is_a_subtype() throws UnknownHostException {
        SetType cqlType = DataTypes.setOf((DataType)DataTypes.INET);
        GenericType<Set<InetAddress>> javaType = new GenericType<Set<InetAddress>>(){};
        InetAddress address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        Assertions.assertThat((Object)address).isInstanceOf(Inet4Address.class);
        ImmutableSet value = ImmutableSet.of((Object)address);
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.setOf(Inet4Address.class), true);
    }

    @Test
    public void should_create_map_codec_for_cql_and_java_types() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT));
        GenericType<Map<Integer, Map<Integer, Integer>>> javaType = new GenericType<Map<Integer, Map<Integer, Integer>>>(){};
        ImmutableMap value = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)1, (Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, (GenericType)javaType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT), GenericType.mapOf((GenericType)GenericType.INTEGER, (GenericType)GenericType.INTEGER), false);
    }

    @Test
    public void should_create_map_codec_for_cql_type() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT));
        GenericType<Map<Integer, Map<Integer, Integer>>> javaType = new GenericType<Map<Integer, Map<Integer, Integer>>>(){};
        ImmutableMap value = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)1, (Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, null, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT), null, false);
    }

    @Test
    public void should_create_map_codec_for_java_type() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT));
        GenericType<Map<Integer, Map<Integer, Integer>>> javaType = new GenericType<Map<Integer, Map<Integer, Integer>>>(){};
        ImmutableMap value = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)1, (Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((GenericType)javaType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, new GenericType<Map<Integer, Integer>>(){}, false);
    }

    @Test
    public void should_create_map_codec_for_cql_type_and_java_value() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT));
        GenericType<Map<Integer, Map<Integer, Integer>>> javaType = new GenericType<Map<Integer, Map<Integer, Integer>>>(){};
        ImmutableMap value = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)1, (Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT), GenericType.mapOf((GenericType)GenericType.INTEGER, (GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_map_codec_for_java_value() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT));
        GenericType<Map<Integer, Map<Integer, Integer>>> javaType = new GenericType<Map<Integer, Map<Integer, Integer>>>(){};
        ImmutableMap value = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)1, (Object)1));
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.mapOf((GenericType)GenericType.INTEGER, (GenericType)GenericType.INTEGER), true);
    }

    @Test
    public void should_create_map_codec_for_empty_java_value() {
        GenericType javaType = GenericType.mapOf((GenericType)GenericType.BOOLEAN, (GenericType)GenericType.BOOLEAN);
        ImmutableMap value = ImmutableMap.of((Object)1, Collections.emptyMap());
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        codec.encode((Object)value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, javaType, true);
    }

    @Test
    public void should_create_map_codec_for_cql_type_and_empty_java_value() {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.mapOf((DataType)DataTypes.DOUBLE, (DataType)DataTypes.TEXT));
        GenericType javaType = GenericType.mapOf((GenericType)GenericType.INTEGER, (GenericType)GenericType.mapOf((GenericType)GenericType.DOUBLE, (GenericType)GenericType.STRING));
        ImmutableMap value = ImmutableMap.of((Object)1, Collections.emptyMap());
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        codec.encode((Object)value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, javaType, true);
    }

    @Test
    public void should_create_map_codec_for_java_value_when_first_element_is_a_subtype() throws UnknownHostException {
        MapType cqlType = DataTypes.mapOf((DataType)DataTypes.INET, (DataType)DataTypes.INET);
        GenericType<Map<InetAddress, InetAddress>> javaType = new GenericType<Map<InetAddress, InetAddress>>(){};
        InetAddress address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        Assertions.assertThat((Object)address).isInstanceOf(Inet4Address.class);
        ImmutableMap value = ImmutableMap.of((Object)address, (Object)address);
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((GenericType)javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.mapOf(Inet4Address.class, Inet4Address.class), true);
    }

    @Test
    public void should_create_tuple_codec_for_cql_and_java_types() {
        TupleType cqlType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, GenericType.TUPLE_VALUE);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.TUPLE_VALUE, false);
    }

    @Test
    public void should_create_tuple_codec_for_cql_type() {
        TupleType cqlType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, null, false);
    }

    @Test
    public void should_create_tuple_codec_for_cql_type_and_java_value() {
        TupleType cqlType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.TUPLE_VALUE, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_create_tuple_codec_for_java_value() {
        TupleType cqlType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.TUPLE_VALUE, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_create_udt_codec_for_cql_and_java_types() {
        UserDefinedType cqlType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UdtValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, GenericType.UDT_VALUE);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.UDT_VALUE, false);
    }

    @Test
    public void should_create_udt_codec_for_cql_type() {
        UserDefinedType cqlType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UdtValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, null, false);
    }

    @Test
    public void should_create_udt_codec_for_cql_type_and_java_value() {
        UserDefinedType cqlType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UdtValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor((DataType)cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.UDT_VALUE, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_create_udt_codec_for_java_value() {
        UserDefinedType cqlType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UdtValue value = cqlType.newValue();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new TypeCodec[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts((DataType)cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts((Object)value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.UDT_VALUE, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_not_find_codec_if_java_type_unknown() {
        try {
            CodecRegistry.DEFAULT.codecFor(StringBuilder.class);
            Assertions.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            CodecRegistry.DEFAULT.codecFor(DataTypes.TEXT, StringBuilder.class);
            Assertions.fail((String)"Should not have found a codec for varchar <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            CodecRegistry.DEFAULT.codecFor((Object)new StringBuilder());
            Assertions.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void should_not_allow_covariance_for_lookups_by_java_type() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.codecFor(B.class)).isInstanceOf(CodecNotFoundException.class)).hasMessage("Codec not found for requested operation: [null <-> %s]", new Object[]{B.class.getName()});
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.of(B.class), false);
        inOrder.verifyNoMoreInteractions();
        Assertions.assertThatThrownBy(() -> registry.codecFor(GenericType.listOf(B.class))).isInstanceOf(CodecNotFoundException.class);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf(B.class), false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.of(B.class), false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_allow_covariance_for_lookups_by_cql_type_and_value() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, new B())).isInstanceOf(ACodec.class);
        inOrder.verifyNoMoreInteractions();
        ArrayList list = Lists.newArrayList((Object[])new B[]{new B()});
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.INT);
        TypeCodec actual = registry.codecFor((DataType)cqlType, list);
        Assertions.assertThat((Object)actual).isInstanceOf(ListCodec.class);
        Assertions.assertThat((Object)actual.getJavaType()).isEqualTo((Object)GenericType.listOf(A.class));
        Assertions.assertThat((boolean)actual.accepts((Object)list)).isTrue();
        Assertions.assertThat((boolean)actual.accepts(GenericType.listOf(B.class))).isFalse();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.listOf(B.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_allow_covariance_for_lookups_by_value() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache, new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        Assertions.assertThat((Object)registry.codecFor(new B())).isInstanceOf(ACodec.class);
        inOrder.verifyNoMoreInteractions();
        ArrayList list = Lists.newArrayList((Object[])new B[]{new B()});
        TypeCodec actual = registry.codecFor(list);
        Assertions.assertThat((Object)actual).isInstanceOf(ListCodec.class);
        Assertions.assertThat((Object)actual.getJavaType()).isEqualTo((Object)GenericType.listOf(A.class));
        Assertions.assertThat((boolean)actual.accepts((Object)list)).isTrue();
        Assertions.assertThat((boolean)actual.accepts(GenericType.listOf(B.class))).isFalse();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf(B.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    private static class ACodec
    implements TypeCodec<A> {
        private ACodec() {
        }

        @NonNull
        public GenericType<A> getJavaType() {
            return GenericType.of(A.class);
        }

        @NonNull
        public DataType getCqlType() {
            return DataTypes.INT;
        }

        public ByteBuffer encode(A value, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("irrelevant");
        }

        public A decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("irrelevant");
        }

        @NonNull
        public String format(A value) {
            throw new UnsupportedOperationException("irrelevant");
        }

        public A parse(String value) {
            throw new UnsupportedOperationException("irrelevant");
        }
    }

    private static class B
    extends A {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }

    public static class TextToPeriodCodec
    implements TypeCodec<Period> {
        @NonNull
        public GenericType<Period> getJavaType() {
            return GenericType.of(Period.class);
        }

        @NonNull
        public DataType getCqlType() {
            return DataTypes.TEXT;
        }

        public ByteBuffer encode(Period value, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        public Period decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        @NonNull
        public String format(Period value) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        public Period parse(String value) {
            throw new UnsupportedOperationException("not implemented for this test");
        }
    }

    public static class TestCachingCodecRegistry
    extends CachingCodecRegistry {
        private final MockCache cache;

        public TestCachingCodecRegistry(MockCache cache, TypeCodec<?> ... userCodecs) {
            super("test", CodecRegistryConstants.PRIMITIVE_CODECS, userCodecs);
            this.cache = cache;
        }

        protected TypeCodec<?> getCachedCodec(@Nullable DataType cqlType, @Nullable GenericType<?> javaType, boolean isJavaCovariant) {
            this.cache.lookup(cqlType, javaType, isJavaCovariant);
            return this.createCodec(cqlType, javaType, isJavaCovariant);
        }

        public static interface MockCache {
            public void lookup(@Nullable DataType var1, @Nullable GenericType<?> var2, boolean var3);
        }
    }
}

