/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UuidCodecTest
extends CodecTestBase<UUID> {
    private static final UUID MOCK_UUID = new UUID(2L, 1L);

    public UuidCodecTest() {
        this.codec = TypeCodecs.UUID;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(MOCK_UUID)).isEqualTo("0x00000000000000020000000000000001");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        UUID decoded = (UUID)this.decode("0x00000000000000020000000000000001");
        Assertions.assertThat((long)decoded.getMostSignificantBits()).isEqualTo(2L);
        Assertions.assertThat((long)decoded.getLeastSignificantBits()).isEqualTo(1L);
        Assertions.assertThat((Comparable)((UUID)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x000000000000000200000000000000010000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(MOCK_UUID)).isEqualTo("00000000-0000-0002-0000-000000000001");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Comparable)((UUID)this.parse("00000000-0000-0002-0000-000000000001"))).isEqualTo((Object)MOCK_UUID);
        Assertions.assertThat((Comparable)((UUID)this.parse("NULL"))).isNull();
        Assertions.assertThat((Comparable)((UUID)this.parse("null"))).isNull();
        Assertions.assertThat((Comparable)((UUID)this.parse(""))).isNull();
        Assertions.assertThat((Comparable)((UUID)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a uuid");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(UUID.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(UUID.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)MOCK_UUID)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

