/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.data.DefaultUdtValue;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class UdtCodecTest
extends CodecTestBase<UdtValue> {
    @Mock
    private AttachmentPoint attachmentPoint;
    @Mock
    private CodecRegistry codecRegistry;
    private PrimitiveIntCodec intCodec;
    private TypeCodec<Double> doubleCodec;
    private TypeCodec<String> textCodec;
    private UserDefinedType userType;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.attachmentPoint.getCodecRegistry()).thenReturn((Object)this.codecRegistry);
        Mockito.when((Object)this.attachmentPoint.getProtocolVersion()).thenReturn((Object)ProtocolVersion.DEFAULT);
        this.intCodec = (PrimitiveIntCodec)Mockito.spy((Object)TypeCodecs.INT);
        this.doubleCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.DOUBLE);
        this.textCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.TEXT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, Integer.class)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE, Double.class)).thenAnswer(i -> this.doubleCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, String.class)).thenAnswer(i -> this.textCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE)).thenAnswer(i -> this.doubleCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT)).thenAnswer(i -> this.textCodec);
        this.userType = new DefaultUserDefinedType(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type"), false, (List)ImmutableList.of((Object)CqlIdentifier.fromInternal((String)"field1"), (Object)CqlIdentifier.fromInternal((String)"field2"), (Object)CqlIdentifier.fromInternal((String)"field3")), (List)ImmutableList.of((Object)DataTypes.INT, (Object)DataTypes.DOUBLE, (Object)DataTypes.TEXT), this.attachmentPoint);
        this.codec = TypeCodecs.udtOf((UserDefinedType)this.userType);
    }

    @Test
    public void should_encode_null_udt() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_udt() {
        UdtValue udt = this.userType.newValue();
        udt = (UdtValue)udt.setInt("field1", 1);
        udt = (UdtValue)udt.setToNull("field2");
        udt = (UdtValue)udt.setString("field3", "a");
        Assertions.assertThat((String)this.encode(udt)).isEqualTo("0x0000000400000001ffffffff0000000161");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).encodePrimitive(1, ProtocolVersion.DEFAULT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.doubleCodec});
        ((TypeCodec)Mockito.verify(this.textCodec)).encode((Object)"a", ProtocolVersion.DEFAULT);
    }

    @Test
    public void should_decode_null_udt() {
        Assertions.assertThat((Object)((UdtValue)this.decode(null))).isNull();
    }

    @Test
    public void should_decode_udt() {
        UdtValue udt = (UdtValue)this.decode("0x0000000400000001ffffffff0000000161");
        Assertions.assertThat((int)udt.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)udt.isNull(1)).isTrue();
        Assertions.assertThat((String)udt.getString(2)).isEqualTo("a");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).decodePrimitive(Bytes.fromHexString((String)"0x00000001"), ProtocolVersion.DEFAULT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.doubleCodec});
        ((TypeCodec)Mockito.verify(this.textCodec)).decode(Bytes.fromHexString((String)"0x61"), ProtocolVersion.DEFAULT);
    }

    @Test
    public void should_format_null_udt() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_udt() {
        UdtValue udt = this.userType.newValue();
        udt = (UdtValue)udt.setInt(0, 1);
        udt = (UdtValue)udt.setToNull(1);
        udt = (UdtValue)udt.setString(2, "a");
        Assertions.assertThat((String)this.format(udt)).isEqualTo("{field1:1,field2:NULL,field3:'a'}");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).format((Object)1);
        ((TypeCodec)Mockito.verify(this.doubleCodec)).format(null);
        ((TypeCodec)Mockito.verify(this.textCodec)).format((Object)"a");
    }

    @Test
    public void should_parse_null_udt() {
        Assertions.assertThat((Object)((UdtValue)this.parse(null))).isNull();
        Assertions.assertThat((Object)((UdtValue)this.parse("null"))).isNull();
        Assertions.assertThat((Object)((UdtValue)this.parse("NULL"))).isNull();
    }

    @Test
    public void should_parse_udt() {
        UdtValue udt = (UdtValue)this.parse("{field1:1,field2:NULL,field3:'a'}");
        Assertions.assertThat((int)udt.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)udt.isNull(1)).isTrue();
        Assertions.assertThat((String)udt.getString(2)).isEqualTo("a");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).parse("1");
        ((TypeCodec)Mockito.verify(this.doubleCodec)).parse("NULL");
        ((TypeCodec)Mockito.verify(this.textCodec)).parse("'a'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a udt");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(UdtValue.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(DefaultUdtValue.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(DefaultUdtValue.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)this.userType.newValue())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new DefaultUdtValue(this.userType))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)"not a udt")).isFalse();
    }
}

