/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class IntCodecTest
extends CodecTestBase<Integer> {
    public IntCodecTest() {
        this.codec = TypeCodecs.INT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(0)).isEqualTo("0x00000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Integer)((Integer)this.decode("0x00000000"))).isEqualTo(0);
        Assertions.assertThat((Integer)((Integer)this.decode("0x"))).isNull();
        Assertions.assertThat((Integer)((Integer)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(0)).isEqualTo("0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Integer)((Integer)this.parse("0"))).isEqualTo(0);
        Assertions.assertThat((Integer)((Integer)this.parse("NULL"))).isNull();
        Assertions.assertThat((Integer)((Integer)this.parse("null"))).isNull();
        Assertions.assertThat((Integer)((Integer)this.parse(""))).isNull();
        Assertions.assertThat((Integer)((Integer)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not an int");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Long.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Long.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)123)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Long.MIN_VALUE)).isFalse();
    }
}

