/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class CodecTestBase<T> {
    protected TypeCodec<T> codec;

    protected String encode(T t, ProtocolVersion protocolVersion) {
        ((ObjectAssert)Assertions.assertThat(this.codec).as("Must set codec before calling this method", new Object[0])).isNotNull();
        ByteBuffer bytes = this.codec.encode(t, protocolVersion);
        return bytes == null ? null : Bytes.toHexString((ByteBuffer)bytes);
    }

    protected String encode(T t) {
        return this.encode(t, ProtocolVersion.DEFAULT);
    }

    protected T decode(String hexString, ProtocolVersion protocolVersion) {
        ((ObjectAssert)Assertions.assertThat(this.codec).as("Must set codec before calling this method", new Object[0])).isNotNull();
        ByteBuffer bytes = hexString == null ? null : Bytes.fromHexString((String)hexString);
        this.codec.decode(bytes, protocolVersion);
        return (T)this.codec.decode(bytes, protocolVersion);
    }

    protected T decode(String hexString) {
        return this.decode(hexString, ProtocolVersion.DEFAULT);
    }

    protected String format(T t) {
        ((ObjectAssert)Assertions.assertThat(this.codec).as("Must set codec before calling this method", new Object[0])).isNotNull();
        return this.codec.format(t);
    }

    protected T parse(String s) {
        ((ObjectAssert)Assertions.assertThat(this.codec).as("Must set codec before calling this method", new Object[0])).isNotNull();
        return (T)this.codec.parse(s);
    }
}

