/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BooleanCodecTest
extends CodecTestBase<Boolean> {
    public BooleanCodecTest() {
        this.codec = TypeCodecs.BOOLEAN;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(false)).isEqualTo("0x00");
        Assertions.assertThat((String)this.encode(true)).isEqualTo("0x01");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Boolean)((Boolean)this.decode("0x00"))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)this.decode("0x01"))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.decode("0x"))).isNull();
        Assertions.assertThat((Boolean)((Boolean)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(true)).isEqualTo("true");
        Assertions.assertThat((String)this.format(false)).isEqualTo("false");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Boolean)((Boolean)this.parse("true"))).isEqualTo(true);
        Assertions.assertThat((Boolean)((Boolean)this.parse("false"))).isEqualTo(false);
        Assertions.assertThat((Boolean)((Boolean)this.parse("NULL"))).isNull();
        Assertions.assertThat((Boolean)((Boolean)this.parse("null"))).isNull();
        Assertions.assertThat((Boolean)((Boolean)this.parse(""))).isNull();
        Assertions.assertThat((Boolean)((Boolean)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("maybe");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Boolean.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Boolean.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Boolean.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Boolean.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)true)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Boolean.TRUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

