/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session.throttling;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.session.throttling.MockThrottled;
import com.datastax.oss.driver.internal.core.session.throttling.NanoClock;
import com.datastax.oss.driver.internal.core.session.throttling.RateLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.SettableNanoClock;
import com.datastax.oss.driver.internal.core.util.concurrent.ScheduledTaskCapturingEventLoop;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class RateLimitingRequestThrottlerTest {
    private static final long ONE_HUNDRED_MILLISECONDS = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
    private static final long TWO_HUNDRED_MILLISECONDS = TimeUnit.NANOSECONDS.convert(200L, TimeUnit.MILLISECONDS);
    private static final long TWO_SECONDS = TimeUnit.NANOSECONDS.convert(2L, TimeUnit.SECONDS);
    private static final Duration DRAIN_INTERVAL = Duration.ofMillis(10L);
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private EventLoopGroup adminGroup;
    private ScheduledTaskCapturingEventLoop adminExecutor;
    private SettableNanoClock clock = new SettableNanoClock();
    private RateLimitingRequestThrottler throttler;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND)).thenReturn((Object)5);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE)).thenReturn((Object)10);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_DRAIN_INTERVAL)).thenReturn((Object)DRAIN_INTERVAL);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminGroup);
        this.adminExecutor = new ScheduledTaskCapturingEventLoop(this.adminGroup);
        Mockito.when((Object)this.adminGroup.next()).thenReturn((Object)this.adminExecutor);
        this.throttler = new RateLimitingRequestThrottler((DriverContext)this.context, (NanoClock)this.clock);
    }

    @Test
    public void should_start_immediately_when_under_capacity() {
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(4);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
    }

    @Test
    public void should_allow_new_request_when_under_rate() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        this.clock.add(TWO_HUNDRED_MILLISECONDS);
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
    }

    @Test
    public void should_enqueue_when_over_rate() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).containsExactly((Object[])new Throttled[]{request});
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = this.adminExecutor.nextTask();
        Assertions.assertThat(task).isNotNull();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.NANOSECONDS)).isEqualTo(DRAIN_INTERVAL.toNanos());
    }

    @Test
    public void should_reject_when_queue_is_full() {
        for (int i = 0; i < 15; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).hasSize(10);
        this.clock.add(TWO_HUNDRED_MILLISECONDS);
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
        });
    }

    @Test
    public void should_remove_timed_out_request_from_queue() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        MockThrottled queued1 = new MockThrottled();
        this.throttler.register((Throttled)queued1);
        MockThrottled queued2 = new MockThrottled();
        this.throttler.register((Throttled)queued2);
        this.throttler.signalTimeout((Throttled)queued1);
        Assertions.assertThatStage(queued2.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).containsExactly((Object[])new Throttled[]{queued2});
    }

    @Test
    public void should_dequeue_when_draining_task_runs() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        MockThrottled queued1 = new MockThrottled();
        this.throttler.register((Throttled)queued1);
        Assertions.assertThatStage(queued1.started).isNotDone();
        MockThrottled queued2 = new MockThrottled();
        this.throttler.register((Throttled)queued2);
        Assertions.assertThatStage(queued2.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).hasSize(2);
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = this.adminExecutor.nextTask();
        Assertions.assertThat(task).isNotNull();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.NANOSECONDS)).isEqualTo(DRAIN_INTERVAL.toNanos());
        task.run();
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).containsExactly((Object[])new Throttled[]{queued1, queued2});
        task = this.adminExecutor.nextTask();
        Assertions.assertThat(task).isNotNull();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.NANOSECONDS)).isEqualTo(DRAIN_INTERVAL.toNanos());
        this.clock.add(TWO_HUNDRED_MILLISECONDS);
        task.run();
        Assertions.assertThatStage(queued1.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isTrue());
        Assertions.assertThatStage(queued2.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).containsExactly((Object[])new Throttled[]{queued2});
        task = this.adminExecutor.nextTask();
        Assertions.assertThat(task).isNotNull();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.NANOSECONDS)).isEqualTo(DRAIN_INTERVAL.toNanos());
        this.clock.add(TWO_HUNDRED_MILLISECONDS);
        task.run();
        Assertions.assertThatStage(queued2.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isTrue());
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
        Assertions.assertThat(this.adminExecutor.nextTask()).isNull();
    }

    @Test
    public void should_store_new_permits_up_to_threshold() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        this.clock.add(TWO_SECONDS);
        this.throttler.register((Throttled)new MockThrottled());
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(4);
    }

    @Test
    public void should_keep_accumulating_time_if_no_permits_created() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getStoredPermits()).isEqualTo(0);
        this.clock.add(ONE_HUNDRED_MILLISECONDS);
        MockThrottled queued = new MockThrottled();
        this.throttler.register((Throttled)queued);
        Assertions.assertThatStage(queued.started).isNotDone();
        this.clock.add(ONE_HUNDRED_MILLISECONDS);
        this.adminExecutor.nextTask().run();
        Assertions.assertThatStage(queued.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isTrue());
    }

    @Test
    public void should_reject_enqueued_when_closing() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        ArrayList enqueued = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            MockThrottled request = new MockThrottled();
            this.throttler.register((Throttled)request);
            Assertions.assertThatStage(request.started).isNotDone();
            enqueued.add(request);
        }
        this.throttler.close();
        for (MockThrottled request : enqueued) {
            Assertions.assertThatStage(request.started).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
            });
        }
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
        });
    }
}

