/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.session.ReprepareOnUp;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.channel.EventLoop;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ReprepareOnUpTest {
    @Mock
    private ChannelPool pool;
    @Mock
    private DriverChannel channel;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private TopologyMonitor topologyMonitor;
    @Mock
    private MetricsFactory metricsFactory;
    @Mock
    private SessionMetricUpdater metricUpdater;
    private Runnable whenPrepared;
    private CompletionStage<Void> done;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.pool.next()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.channel.eventLoop()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.eventLoop.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.REPREPARE_CHECK_SYSTEM_TABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.REPREPARE_TIMEOUT)).thenReturn((Object)Duration.ofMillis(500L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REPREPARE_MAX_STATEMENTS)).thenReturn((Object)0);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REPREPARE_MAX_PARALLELISM)).thenReturn((Object)100);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        Mockito.when((Object)this.metricsFactory.getSessionUpdater()).thenReturn((Object)this.metricUpdater);
        this.done = new CompletableFuture<Void>();
        this.whenPrepared = () -> ((CompletableFuture)this.done).complete(null);
    }

    @Test
    public void should_complete_immediately_if_no_prepared_statements() {
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads(new char[0]), this.context, this.whenPrepared);
        reprepareOnUp.start();
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_complete_immediately_if_pool_empty() {
        Mockito.when((Object)this.pool.next()).thenReturn(null);
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_reprepare_all_if_system_table_query_fails() {
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
        Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)((MockAdminQuery)adminQuery).request).query).isEqualTo("SELECT prepared_id FROM system.prepared_statements");
        adminQuery.resultFuture.completeExceptionally(new RuntimeException("mock error"));
        for (char c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_reprepare_all_if_system_table_empty() {
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
        Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)((MockAdminQuery)adminQuery).request).query).isEqualTo("SELECT prepared_id FROM system.prepared_statements");
        adminQuery.resultFuture.complete(new AdminResult(this.preparedIdRows(new char[0]), null, DefaultProtocolVersion.DEFAULT));
        for (char c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_reprepare_all_if_system_query_disabled() {
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.REPREPARE_CHECK_SYSTEM_TABLE)).thenReturn((Object)false);
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        for (char c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_not_reprepare_already_known_statements() {
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
        Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)((MockAdminQuery)adminQuery).request).query).isEqualTo("SELECT prepared_id FROM system.prepared_statements");
        adminQuery.resultFuture.complete(new AdminResult(this.preparedIdRows('d', 'e', 'f'), null, DefaultProtocolVersion.DEFAULT));
        for (char c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_proceed_if_schema_agreement_not_reached() {
        Mockito.when((Object)this.topologyMonitor.checkSchemaAgreement()).thenReturn(CompletableFuture.completedFuture(false));
        this.should_not_reprepare_already_known_statements();
    }

    @Test
    public void should_proceed_if_schema_agreement_fails() {
        Mockito.when((Object)this.topologyMonitor.checkSchemaAgreement()).thenReturn((Object)CompletableFutures.failedFuture((Throwable)new RuntimeException("test")));
        this.should_not_reprepare_already_known_statements();
    }

    @Test
    public void should_limit_number_of_statements_to_reprepare() {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REPREPARE_MAX_STATEMENTS)).thenReturn((Object)3);
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
        Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)((MockAdminQuery)adminQuery).request).query).isEqualTo("SELECT prepared_id FROM system.prepared_statements");
        adminQuery.resultFuture.complete(new AdminResult(this.preparedIdRows(new char[0]), null, DefaultProtocolVersion.DEFAULT));
        for (char c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    @Test
    public void should_limit_number_of_statements_reprepared_in_parallel() {
        char c;
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REPREPARE_MAX_PARALLELISM)).thenReturn((Object)3);
        MockReprepareOnUp reprepareOnUp = new MockReprepareOnUp("test", this.pool, this.getMockPayloads('a', 'b', 'c', 'd', 'e', 'f'), this.context, this.whenPrepared);
        reprepareOnUp.start();
        MockAdminQuery adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
        Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Query.class);
        Assertions.assertThat((String)((Query)((MockAdminQuery)adminQuery).request).query).isEqualTo("SELECT prepared_id FROM system.prepared_statements");
        adminQuery.resultFuture.complete(new AdminResult(this.preparedIdRows(new char[0]), null, DefaultProtocolVersion.DEFAULT));
        Assertions.assertThat((int)reprepareOnUp.queries.size()).isEqualTo(3);
        for (c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
            Assertions.assertThat((int)reprepareOnUp.queries.size()).isEqualTo(3);
        }
        for (c = 'd'; c <= 'f'; c = (char)(c + '\u0001')) {
            adminQuery = (MockAdminQuery)reprepareOnUp.queries.poll();
            Assertions.assertThat((Object)adminQuery.request).isInstanceOf(Prepare.class);
            Assertions.assertThat((String)((Prepare)((MockAdminQuery)adminQuery).request).cqlQuery).isEqualTo("mock query " + c);
            adminQuery.resultFuture.complete(null);
        }
        Assertions.assertThatStage(this.done).isSuccess(v -> Assertions.assertThat((Iterable)reprepareOnUp.queries).isEmpty());
    }

    private Map<ByteBuffer, RepreparePayload> getMockPayloads(char ... values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (char value : values) {
            ByteBuffer id = Bytes.fromHexString((String)("0x0" + value));
            builder.put((Object)id, (Object)new RepreparePayload(id, "mock query " + value, null, Collections.emptyMap()));
        }
        return builder.build();
    }

    private Rows preparedIdRows(char ... values) {
        ColumnSpec preparedIdSpec = new ColumnSpec("system", "prepared_statements", "prepared_id", 0, (RawType)RawType.PRIMITIVES.get(3));
        RowsMetadata rowsMetadata = new RowsMetadata((List)ImmutableList.of((Object)preparedIdSpec), null, null, null);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        for (char value : values) {
            data.add(ImmutableList.of((Object)Bytes.fromHexString((String)("0x0" + value))));
        }
        return new DefaultRows(rowsMetadata, data);
    }

    private static class MockAdminQuery {
        private final Message request;
        private final CompletableFuture<Object> resultFuture;

        public MockAdminQuery(Message request, CompletableFuture<?> resultFuture) {
            this.request = request;
            this.resultFuture = resultFuture;
        }
    }

    private static class MockReprepareOnUp
    extends ReprepareOnUp {
        private Queue<MockAdminQuery> queries = new ArrayDeque<MockAdminQuery>();

        MockReprepareOnUp(String logPrefix, ChannelPool pool, Map<ByteBuffer, RepreparePayload> repreparePayloads, InternalDriverContext context, Runnable whenPrepared) {
            super(logPrefix, pool, repreparePayloads, context, whenPrepared);
        }

        protected CompletionStage<AdminResult> queryAsync(Message message, Map<String, ByteBuffer> customPayload, String debugString) {
            CompletableFuture<AdminResult> resultFuture = new CompletableFuture<AdminResult>();
            this.queries.add(new MockAdminQuery(message, resultFuture));
            return resultFuture;
        }

        protected CompletionStage<ByteBuffer> prepareAsync(Message message, Map<String, ByteBuffer> customPayload) {
            CompletableFuture<ByteBuffer> resultFuture = new CompletableFuture<ByteBuffer>();
            this.queries.add(new MockAdminQuery(message, resultFuture));
            return resultFuture;
        }
    }
}

