/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.pool.ChannelSet;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ChannelSetTest {
    @Mock
    private DriverChannel channel1;
    @Mock
    private DriverChannel channel2;
    @Mock
    private DriverChannel channel3;
    private ChannelSet set;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.set = new ChannelSet();
    }

    @Test
    public void should_return_null_when_empty() {
        Assertions.assertThat((int)this.set.size()).isEqualTo(0);
        Assertions.assertThat((Object)this.set.next()).isNull();
    }

    @Test
    public void should_return_element_when_single() {
        this.set.add(this.channel1);
        Assertions.assertThat((int)this.set.size()).isEqualTo(1);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel1);
        ((DriverChannel)Mockito.verify((Object)this.channel1, (VerificationMode)Mockito.never())).getAvailableIds();
    }

    @Test
    public void should_return_most_available_when_multiple() {
        Mockito.when((Object)this.channel1.getAvailableIds()).thenReturn((Object)2);
        Mockito.when((Object)this.channel2.getAvailableIds()).thenReturn((Object)12);
        Mockito.when((Object)this.channel3.getAvailableIds()).thenReturn((Object)8);
        this.set.add(this.channel1);
        this.set.add(this.channel2);
        this.set.add(this.channel3);
        Assertions.assertThat((int)this.set.size()).isEqualTo(3);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel2);
        ((DriverChannel)Mockito.verify((Object)this.channel1)).getAvailableIds();
        ((DriverChannel)Mockito.verify((Object)this.channel2)).getAvailableIds();
        ((DriverChannel)Mockito.verify((Object)this.channel3)).getAvailableIds();
        Mockito.when((Object)this.channel1.getAvailableIds()).thenReturn((Object)15);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel1);
    }

    @Test
    public void should_remove_channels() {
        Mockito.when((Object)this.channel1.getAvailableIds()).thenReturn((Object)2);
        Mockito.when((Object)this.channel2.getAvailableIds()).thenReturn((Object)12);
        Mockito.when((Object)this.channel3.getAvailableIds()).thenReturn((Object)8);
        this.set.add(this.channel1);
        this.set.add(this.channel2);
        this.set.add(this.channel3);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel2);
        this.set.remove(this.channel2);
        Assertions.assertThat((int)this.set.size()).isEqualTo(2);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel3);
        this.set.remove(this.channel3);
        Assertions.assertThat((int)this.set.size()).isEqualTo(1);
        Assertions.assertThat((Object)this.set.next()).isEqualTo((Object)this.channel1);
        this.set.remove(this.channel1);
        Assertions.assertThat((int)this.set.size()).isEqualTo(0);
        Assertions.assertThat((Object)this.set.next()).isNull();
    }
}

